/* vi: set sw=4 ts=4 autoindent: */
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <sys/ioctl.h>
#include "sysinfo.h"
#include "open_debug.h"


#define NET_DEBUG	0

extern int query_netdevice(char *device_name, int query_flag, void *buf);

//dWANdefault gateway
//return:0 䤣
//return:>0 default gateway
unsigned long
getWANroute(char *p_wanname)
{
	FILE *fp;
	char buf[120], *cp;
	unsigned long ul;

	//---=== init area ===---
	if(p_wanname == NULL)
	{
		return 0;
	}

	if(!strncmp(p_wanname, "ppp", 3))	//O ppp ܥt~Bz
	{
		query_netdevice(p_wanname, SIOCGIFDSTADDR, &ul);
	}
	else
	{
		fp = fopen("/proc/net/route", "r");
		if(fp == NULL)
		{
#if	NET_DEBUG > 0
			Nprintf("/proc/net/route open error!\n");
#endif
			return 0;
		}
		else
		{
			while( fgets(buf, 120, fp)!=NULL )
			{
				
				if( !strncmp(buf, p_wanname, strlen(p_wanname)) )
				{					
					cp = strtok(buf, " \t\n");	//iface
					cp = strtok(NULL, " \t\n");	//destination
					sscanf(cp, "%lx", &ul);
					if(ul == 0)	//default gateway
					{						
						cp = strtok(NULL, " \t\n");	//getway
						sscanf(cp, "%lx", &ul);
						fclose(fp);
						return ul;
					}
				}
			}
			ul = 0;	//not found
			fclose(fp);
		}
	}
	return ul;
}
