# We need include diff.mk for we want to add some marco to CFLAGS
include $(TOPDIR)/diff.mk
#---------------------------------------------------
#                COMPILE OPTIONS
#---------------------------------------------------
# You should NOT use ':=' for we should not expand this variable until we use it.
#ECHO_CMD         =  @echo $@;
#CROSS_COMPILE   :=  xscale_be-
CROSS_COMPILE   :=  arm-linux-

CC               =  $(ECHO_CMD)$(CROSS_COMPILE)gcc -mbig-endian
CPP             :=  $(CROSS_COMPILE)cpp
ifeq ($(CROSS_COMPILE), xscale_be-)
LD              :=  $(CROSS_COMPILE)ld
else
LD              :=  $(CROSS_COMPILE)ld -EB
endif
AS              :=  $(CROSS_COMPILE)as
AR              :=  $(CROSS_COMPILE)ar
STRIP           :=  $(CROSS_COMPILE)strip
RANLIB          :=  $(CROSS_COMPILE)ranlib
OBJCOPY         :=  $(CROSS_COMPILE)objcopy
OBJDUMP         :=  $(CROSS_COMPILE)objdump

export CC CPP LD AS AR STRIP RANLIB OBJCOPY OBJDUMP

#---------------------------------------------------
# CFLAGS
#---------------------------------------------------

CFLAGS      :=
CFLAGS      +=      -D$(MODULE_NAME)
CFLAGS      +=      -D$(VENDOR_NAME)
CFLAGS      +=      -D$(PRODUCT_NAME)
CFLAGS      +=      -Os    

#---------------------------------------------------
# Globe functinos define
#---------------------------------------------------
ifeq ($(NO_PRINTER), 1)
    CFLAGS  +=      -DNO_PRINTER
else
    ifeq ($(USB_PRINTER), 1)
        CFLAGS +=   -DUSB_PRINTER
    endif
    ifeq ($(PARELLEL_PRINTER), 1)
        CFLAGS +=   -DPARAELLEL_PRINTER
    endif
endif
ifeq ($(_QUOTA_), 1)
    CFLAGS  +=      -D_QUOTA_
endif
ifeq ($(_FTP_), 1)
    CFLAGS  +=      -D_FTP_
endif
ifeq ($(_SSL_SUPPORT_), 1)
    CFLAGS  +=      -D_SSL_SUPPORT_
endif
ifeq ($(_NTP_SUPPORT_), 1)
    CFLAGS  +=      -D_NTP_SUPPORT_
endif

ifeq ($(_CAMERA_), 1)
    CFLAGS  +=      -D_CAMERA_
endif 

#---------------------------------------------------
# We should warning all messages
#---------------------------------------------------
CFLAGS          +=  -Wall

#---------------------------------------------------
# We use this flags to build depence files which extend filename is ".d"
#---------------------------------------------------
CFLAGS          +=  -MD

CFLAGS          +=  -DEMBED #-O2

#---------------------------------------------------
#                KERNEL PATH
#---------------------------------------------------
K_PATH          := $(TOPDIR)/../kernel
K_INC_PATH      := $(K_PATH)/include

#---------------------------------------------------
#                COMMON PATH
#---------------------------------------------------
COMM_LIB_PATH   := $(TOPDIR)/lib
COMM_INC_PATH   := $(TOPDIR)/include

#---------------------------------------------------
#                TARGET PATH
#---------------------------------------------------

# RAMDISK path
RAMDISK_DIR     :=  $(TOPDIR)/../ramdisk

# Target path
T_SBIN          := $(RAMDISK_DIR)/sbin
T_BIN           := $(RAMDISK_DIR)/bin
T_USBIN         := $(RAMDISK_DIR)/usr/sbin
T_UBIN          := $(RAMDISK_DIR)/usr/bin


T_ETC           := $(RAMDISK_DIR)/etc
T_HOME          := $(RAMDISK_DIR)/home

T_LIB           := $(RAMDISK_DIR)/lib

T_SHARE         := $(RAMDISK_DIR)/share


