#include "../des/des.h"

typedef int BOOL;
#define FALSE 0;
#define TRUE 1;

typedef struct {

    int frwdOperation ; /**< Opcode for forward operation */
    int revOperation ;  /**< Opcode for reverse operation */
    int cipherAlgo;     /**< Cipher Algorithm */
    int cipherMode;     /**< Cipher Mode */ 
    int cipherKeyLen;                  /**< Cipher Key Length */
    int cipherBlockLen;		  /**< Cipher Algorithm's Block Length */
    int cipherInitialVectorLen;        /**< Initial vector length */
    int authAlgo;        /**< Authentication Algorithm */   
    int authKeyLen;                    /**< Authentication Key Length */
    int authDigestLen;                 /**< Authentication Digest Length */
    BOOL useDifferentSrcAndDestMbufs;     /**< Use different source and
                                           *  destination buffers.
	                                   */
	int bufferlen;                                   
	unsigned char* cipherKey;
	unsigned char* IV;
	unsigned char* data;                                          
	                                   

}CryptoSSLServiceParam;

int CRYPTO_DES_ECB(const unsigned char *input,unsigned char *output,
		      long length,unsigned char *DES_KEY,
		      int enc);
int CRYPTO_DES_CBC(const unsigned char *input,unsigned char *output,
		      long length,unsigned char *DES_KEY,DES_cblock *ivec,
		      int enc);
int CRYPTO_3DES_ECB(const unsigned char *input,unsigned char *output,
		      long length,unsigned char *DES_KEY,
		      int enc);
int CRYPTO_3DES_CBC(const unsigned char *input,unsigned char *output,
		      long length,unsigned char *DES_KEY,DES_cblock *ivec,
		      int enc);
int CRYPTO_AES128_ECB(const unsigned char *input,unsigned char *output,
		      long length,unsigned char *AES_KEY,
		      int enc);
int CRYPTO_AES128_CBC(const unsigned char *input,unsigned char *output,
		      long length,unsigned char *AES_KEY,unsigned char *ivec,
		      int enc);	
int CRYPTO_AES192_ECB(const unsigned char *input,unsigned char *output,
		      long length,unsigned char *AES_KEY,
		      int enc);
int CRYPTO_AES192_CBC(const unsigned char *input,unsigned char *output,
		      long length,unsigned char *AES_KEY,unsigned char *ivec,
		      int enc);	
int CRYPTO_AES256_ECB(const unsigned char *input,unsigned char *output,
		      long length,unsigned char *AES_KEY,
		      int enc);
int CRYPTO_AES256_CBC(const unsigned char *input,unsigned char *output,
		      long length,unsigned char *AES_KEY,unsigned char *ivec,
		      int enc);		      		      	      		      	      		      		      
		      		      		      

#define DEV_CRYPTOSSL "/dev/ix"


/*
 * #defines and macros used in this file.
 */

#define CRYPTO_ACC_MAX_CIPHER_KEY_LENGTH 32  /**<
                                                 * Max length (byte) of cipher
                                                 * key for DES (64 bit),
                                                 * 3DES (192 bit), AES (128, 192
                                                 * & 256 bit).
                                                 */
#define CRYPTO_ACC_MAX_CIPHER_IV_LENGTH 16   /**<
                                                 * Max IV length in bytes.
                                                 */
#define CRYPTO_ACC_MAX_AUTH_KEY_LENGTH 64    /**<
                                                 * Max length (byte) of
                                                 * authentication key for
                                                 * SHA1 and MD5.
                                                 * Key size > 64 bytes need to 
                                                 * be hashed to produce 
                                                 * shorter key by calling API 
                                                 * ixCryptoAccHashKeyGenerate().
                                                 * (SHA1 : 20 bytes, MD5 : 16 
                                                 * bytes by default according 
                                                 * to RFC2104.       
                                                 * If key size <= 64 bytes,
                                                 * authentication key can be 
                                                 * used for registration 
                                                 * directly.
                                                 */
#define CRYPTO_ACC_MAX_AUTH_IV_LENGTH 20     /**<
                                                 * Max length (byte) of initial
                                                 * chaining variable for
                                                 * SHA1 (160 bit) and
                                                 * MD5 (128 bit).
                                                 */
#define  CRYPTO_ACC_MAX_QUEUE_DEPTH 64       /**<
                                                 * Max queue depth supported
                                                 * by the Queue Manager.
                                                 */
#define  CRYPTO_ACC_MAX_ACTIVE_SA_TUNNELS 1000  /**<
                                                    * Maximum active tunnels
                                                    * supported could be changed
                                                    * by the client based on the
                                                    * application's requirements.
                                                    * Number of active tunnels
                                                    * will not impact the
                                                    * performance but will have
                                                    * an impact on the memory
                                                    * needed to keep the
                                                    * crypto context information
                                                    * will depend on it. Overall
                                                    * memory requirement depends
                                                    * on the number of tunnels.
                                                    */


/*
 * Constants value for DES algorithm in unit bytes
 */

#define CRYPTO_ACC_DES_KEY_64     8  /**<
                                         * DES key length in bytes
                                         */
#define CRYPTO_ACC_DES_BLOCK_64   8  /**<
                                         * DES cipher block length in bytes
                                         */
#define CRYPTO_ACC_DES_IV_64      8  /**<
                                         * DES initialization vector length 
                                         * in bytes
                                         */
#define CRYPTO_ACC_3DES_KEY_192   24 /**<
                                         * 3DES key length in bytes
                                         */

/*
 * Constants value for AES algorithm in unit bytes
 */

#define CRYPTO_ACC_AES_KEY_128    16 /**<
                                         * AES-128 key length in bytes
                                         */
#define CRYPTO_ACC_AES_KEY_192    24 /**<
                                         * AES-192 key length in bytes
                                         */
#define CRYPTO_ACC_AES_KEY_256    32 /**<
                                         * AES-256 key length in bytes
                                         */
#define CRYPTO_ACC_AES_BLOCK_128  16 /**<
                                         * AES cipher block length in bytes
                                         */
#define CRYPTO_ACC_AES_CBC_IV_128 16 /**<
                                         * AES initialization vector length 
                                         * in bytes for CBC mode
                                         */
#define CRYPTO_ACC_AES_CTR_IV_128 16  /**<
                                         * AES initialization vector length 
                                         * in bytes for CTR mode.
                                         */

#define CRYPTO_ACC_CCM_AAD_LEN_384   48 
                                        /**<
                                         * 48 Bytes of additional authenticated
                                         * data for CBC-MAC computation.
                                         * Currently only this value is 
                                         * supported.
                                         */

#define CRYPTO_ACC_AES_CCM_IV_512    \
                  (CRYPTO_ACC_AES_CTR_IV_128 + CRYPTO_ACC_CCM_AAD_LEN_384)
                                        /**<
                                         * CCM Initialization vector has 2
                                         * components to it. First is the IV
                                         * for the CTR mode encryption and 
                                         * second is the additional authentication
                                         * data for the CBC-MAC generation.
					 */

/*
 * Constants value for ARC4 algorithm in unit bytes
 */

#define CRYPTO_ACC_ARC4_KEY_128 16    /**<
                                          * Key length for ARC4 algorithms.
                                          */
#define CRYPTO_ACC_ARC4_BLOCK_8    1  /**<
                                          * ARC4 algorithm block size
                                          */                                           
                                          
/*
 * Constants value for SHA1 algorithm in unit bytes
 */

#define CRYPTO_ACC_SHA1_KEY_160    20    /**<
                                             * SHA1 key length in bytes
                                             */
#define CRYPTO_ACC_SHA1_DIGEST_160 20    /**< 
                                             * SHA1 message digest length
                                             * in bytes
                                             */


/*
 * Constants value for MD5 algorithm in unit bytes
 */

#define CRYPTO_ACC_MD5_KEY_128     16    /**<
                                             * MD5 key length in bytes
                                             */
#define CRYPTO_ACC_MD5_DIGEST_128  16    /**< 
                                             * MD5 message digest length
                                             * in bytes
                                             */

/*
 * Constants value for CBC MAC algorithm in unit bytes
 */
#define CRYPTO_ACC_CCM_DIGEST_64   8     /**<
                                             * CCM digest length in bytes.
                                             * Currently only this value
                                             * (of 8 bytes)is supported for
                                             * CCM digest length.
                                             */
                                          

/*
 * Constants value for WEP CRC/IV algorithm in unit bytes
 */

#define CRYPTO_ACC_WEP_CRC_DIGEST_32 4  /**<
                                            * Digest length of WEP ICV in bytes
                                            */
 
/*
 * Typedefs whose scope is limited to this file.
 */


/**
 * @enum IxCryptoAccCfg
 *
 * @brief Possible configuration definitions.
 *
 * @note Enums to define various possible configurations.
 *    
 */
typedef enum
{
    CRYPTO_ACC_CFG_WEP_XSCALE_ACC_EN,  /**< Enable access to WEP-XScale
                                           * processing only. Access to WEP-NPE
                                           * and hardware accelerators are 
                                           * disabled
                                           */
    CRYPTO_ACC_CFG_CRYPTO_NPE_ACC_EN,  /**< 
                                           * Enable access to Hardware 
                                           * accelerators (WEP XScale engine 
                                           * is also enabled). This is the 
                                           * default configuration for
                                           * the cryptoAcc component.
                                           */
    CRYPTO_ACC_CFG_WEP_NPE_ACC_EN,     /**< Enable access to WEP NPE 
                                           * and XScale engine.
                                           */

    CRYPTO_ACC_CFG_CRYPTO_WEP_NPE_ACC_EN,
                                         /**< Enable access to the Hardware 
                                          * accelerators, WEP - NPE and XScale
                                          * engines.
                                          */
    CRYPTO_ACC_CFG_TYPE               /**< 
                                          * Maximum value for types of 
                                          * configurations.
                                          */
} IxCryptoAccCfg;



/**
 * @enum IxCryptoAccOperation
 *
 * @brief Cryptographic Operation Definitions  
 *
 */ 
typedef enum 
{
    CRYPTO_ACC_OP_ENCRYPT = 0,       /**< Encrypt operation */
    CRYPTO_ACC_OP_DECRYPT,           /**< Decrypt operation */
    CRYPTO_ACC_OP_AUTH_CALC,         /**< 
                                         * Authentication calculation 
                                         * operation
                                         */
    CRYPTO_ACC_OP_AUTH_CHECK,        /**<
                                         * Authentication verification 
                                         * operation
                                         */
    CRYPTO_ACC_OP_ENCRYPT_AUTH,      /**<
                                         * Encryption followed by 
                                         * authentication calculation 
                                         * operation
                                         */
    CRYPTO_ACC_OP_AUTH_DECRYPT,      /**<
                                         * Authentication verification 
                                         * followed by decryption
                                         */
    CRYPTO_ACC_OP_TYPE_OF_OPERATION  /**< 
                                         * Maximum value for types of
                                         * operation
                                         */
} IxCryptoAccOperation;



/**
 * @enum IxCryptoAccCipherAlgo
 *
 * @brief Cipher Algorithm Definitions  
 *
 * @note 3DES and AES will be supported if not violating import/export rules.
 */
typedef enum
{
    CRYPTO_ACC_CIPHER_NULL = 0,    /**< NULL encryption */
    CRYPTO_ACC_CIPHER_DES,         /**< DES algorithm */
    CRYPTO_ACC_CIPHER_3DES,        /**< Triple DES algorithm */
    CRYPTO_ACC_CIPHER_AES,         /**< AES algorithm */
    CRYPTO_ACC_CIPHER_ARC4,        /**< ARC4 Algorithm */
    CRYPTO_ACC_CIPHER_ALGO_TYPE    /**< 
                                       * Maximum value for types of cipher 
                                       * algorithm
                                       */
} IxCryptoAccCipherAlgo;



/**
 * @enum IxCryptoAccCipherMode
 *
 * @brief Cipher Mode Definitions  
 *
 * @note CFB and OFB are not supported.
 */
typedef enum
{
    CRYPTO_ACC_MODE_NULL = 0,    /**< NULL cipher mode */
    CRYPTO_ACC_MODE_ECB,         /**< ECB mode of operation */
    CRYPTO_ACC_MODE_CBC,         /**< CBC mode of operation */
    CRYPTO_ACC_MODE_CTR,         /**< 
                                     * CTR mode of operation, only 
                                     * applicable to AES
                                     */
    CRYPTO_ACC_MODE_CCM,         /**< CCM mode of operation, only 
                                     * applicable with AES cipher Algo. 
                                     */
    CRYPTO_ACC_MODE_TYPE         /**< 
                                     * Maximum value for types of 
                                     * operation 
                                     */
} IxCryptoAccCipherMode;



/**
 * @enum IxCryptoAccAuthAlgo
 *
 * @brief Authentication Algorithm Definitions  
 *
 * @note Only two authentication algorithms are supported, SHA1 and MD5
 *       for IPSEC application, while WEP_CRC is only for WEP application.
 */
typedef enum
{
    CRYPTO_ACC_AUTH_NULL = 0,    /**< NULL authentication */
    CRYPTO_ACC_AUTH_SHA1,        /**< SHA1 algorithm */
    CRYPTO_ACC_AUTH_MD5,         /**< MD5 algorithm */
    CRYPTO_ACC_AUTH_CBC_MAC,     /**< CBC MAC algorithm only applicable 
                                     * along with CCM cipher mode
                                     */
    CRYPTO_ACC_AUTH_WEP_CRC,     /**< WEP CRC algorithm */
    CRYPTO_ACC_AUTH_TYPE         /**< 
                                     * Maximum value for types of 
                                     * authentication algorithm
                                     */
} IxCryptoAccAuthAlgo;


