#ifndef __NTP_H__
#define __NTP_H__

#define MAX_SERVER_LEN		128

typedef struct ntp_info{
	char	ntp_enable[4];
	char	ntp_server[MAX_SERVER_LEN];
	int		hour;		//  0~12
	int 	minute;		//	0~59
	int 	ampm;		//0: am, 1: pm
	int		interval; 	//1: 1 hour, 2: 2 hour, 4: 4 hour, 8: 8 hour, 12: 12 hour, 24: 24 hour	
	int		change;		//0: change, 1: no change
}ntp_info;

int get_ntp_enable(char buf[128],char **buf1,int *msg,char err_sec[128]);
int get_ntp_server(char buf[128],char **buf1,int *msg,char err_sec[128]);
int get_hour(char buf[128],char **buf1,int *msg,char err_sec[128]);
int get_minute(char buf[128],char **buf1,int *msg,char err_sec[128]);
int get_ampm(char buf[128],char **buf1,int *msg,char err_sec[128]);
int get_interval(char buf[128],char **buf1,int *msg,char err_sec[128]);
int get_sync_status(char buf[128],char **buf1,int *msg,char err_sec[128]);
int set_ntp_enable(char *value,int flag,char *msg,void *cfg);
int set_ntp_server(char *value,int flag,char *msg,void *cfg);
int set_hour(char *value,int flag,char *msg,void *cfg);
int set_minute(char *value,int flag,char *msg,void *cfg);
int set_ampm(char *value,int flag,char *msg,void *cfg);
int set_interval(char *value,int flag,char *msg,void *cfg);




#endif

