#ifndef _PARSER_H_
#define _PARSER_H_
#include "cgi-lib.h"

#define         CheckVal        0
#define         SetVal          1
    
   
//---------------------------------------------------------------
// purpose: get configuration data
// output: buf - buffer for the return data
//         *buf1 - if the return data > 128 bytes then GetFun
//                 will allocate a buffer by itself and put the
//                 buffer address in *buf1
//         msg   - index of error message, GetFun will set this
//                 if error occurred.
//         err_sec - error message section name
// return: 0 - success
// Note: 1. Right now only select tag can use buf1
//       2. If GetFun return data in *buf1 then caller must free
//          the memory after using the data
//---------------------------------------------------------------
typedef int (*GetFun) (char buf[128], char **buf1, int *msg,
		       char err_sec[128]);

//---------------------------------------------------------------
// purpose: get array items
// output: *buf - array items
//         msg   - index of error message, ArrayFun will set this
//                 if error occurred.
//         err_sec - error message section name
// return: 0 - success
// Note: caller must free buf afrer using the data
//---------------------------------------------------------------
typedef int (*ArrayFun) (char **buf, int *msg, char err_sec[128]);

//-----------------------------------------
// input: value - value to save
//        flag - 0: check the value range
//               1: save the value
// output: msg - error message (128 bytes)
//         cfg - save data in here
//-----------------------------------------
typedef int (*SetFun) (char *value, int flag, char *msg, void *cfg);
typedef struct keyfun_tab {
    char *key;
     GetFun getfun;
     SetFun setfun;
 } keyfun_tab;
 
typedef struct arrayfun_tab {
    char *key;
     ArrayFun fun;
} arrayfun_tab;
typedef int (*Process) (void);
typedef struct proc_q {
    char name[10];
     Process fun;
     struct proc_q *next;
} proc_q;
typedef struct proc_log {
    proc_q * tail;
    int total;
} proc_log;
typedef struct process_tab {
    char name[10];
     int priority;		//0-5, 0 is the highest priority
    Process fun;
} process_tab;

//------------------------------------------------------
// purpose: do post functions
// input: head - cgi tag list
//        pq   - proess queue pointer array
//        in   - process in queue log array
//        log  - process log array
//        flag - 0 - check variable range
//               1 - set values
// output:
//        msg  - buffer to save error message
// return: 0 - success
//------------------------------------------------------
typedef int (*PostCgiFun) (LIST * head, proc_q ** pq, int *in,
			   proc_log * log, int flag, char *msg);

//-----------------------------------------------
// purpose: cgi to output the complete html file
// input: msg - error message for message variable
//        head - cgi variable list
// return: 0 - successful
//-----------------------------------------------
typedef int (*GetCgiFun) (char *msg, LIST * head);
typedef struct cgi_tab {
    char *name;
     GetCgiFun getfun;
     PostCgiFun postfun;
} cgi_tab;

//-----------------------------------------------------------------------------
// purpose: parser html file and fill dynamic data
// input: fname - html file name
//        funtab - get function table
//        arytab - java script array function table
//        msg    - error message to fill in message variable
//        head   - cgi variable list
//-----------------------------------------------------------------------------
int html_parser(char *fname, keyfun_tab * funtab, arrayfun_tab * arytab,
		char *msg, LIST * head);

//void logerr(char *);
int GetCgiTabIndex(char *name);

#endif	/*  */
