var HelpOptionsVar = "width=480,height=420,scrollbars,toolbar,resizable,dependent=yes";
var GlossOptionsVar = "width=420,height=180,scrollbars,toolbar,resizable,dependent=yes";
var bigsub   = "width=620,height=460,scrollbars,menubar,resizable,status,dependent=yes";
var smallsub = "width=440,height=320,scrollbars,resizable,dependent=yes";
var sersub   = "width=500,height=380,scrollbars,resizable,status,dependent=yes";
var memsub   = "width=630,height=320,scrollbars,menubar,resizable,status,dependent=yes";
var helpWinVar = null;
var glossWinVar = null;
var datSubWinVar = null;
var ValidStr = 'abcdefghijklmnopqrstuvwxyz-';
var hex_str = "ABCDEFabcdef0123456789";

function showMsg()
{
	var msgVar=document.forms[0].message.value;
	if (msgVar.length > 1) 
		alert(msgVar);
}

function closeWin(win_var)
{
	if   ((win_var != null) && (win_var.closed == false)) 
			win_var.close();
}

function openHelpWin(file_name)
{
   helpWinVar = window.open(file_name,'help_win',HelpOptionsVar);
   if (helpWinVar.focus)
		setTimeout('helpWinVar.focus()',200);
}

function openGlossWin()
{
	glossWinVar = window.open('','gloss_win',GlossOptionsVar);
	if (glossWinVar.focus)
		setTimeout('glossWinVar.focus()',200);
}

function openDataSubWin(filename,win_type)
{
	closeWin(datSubWinVar);
	datSubWinVar = window.open(filename,'datasub_win',win_type);
	if (datSubWinVar.focus)
		setTimeout('datSubWinVar.focus()',200); 
}

function closeSubWins()
{
	closeWin(helpWinVar);
	closeWin(glossWinVar);
	closeWin(datSubWinVar);
}

function checkBlank(fieldObj, fname)
{
	var msg = "";
	if (fieldObj.value.length < 1)
		msg = addstr(msg_blank,fname);
	return msg;
}

function checkNoBlanks(fObj, fname)
{
	var space = " ";
 	if (fObj.value.indexOf(space) >= 0 )
			return msg_space;
	else return "";
}

function checkValid(text_input_field, field_name, Valid_Str, max_size, mustFill)
{
	var error_msg= "";
	var size = text_input_field.value.length;
	var str = text_input_field.value;

	if ((mustFill) && (size != max_size) )
		error_msg = addstr(msg_blank_in,field_name);
 	for (var i=0; i < size; i++)
  	{
    	if (!(Valid_Str.indexOf(str.charAt(i)) >= 0))
    	{
			error_msg = addstr(msg_invalid,field_name,Valid_Str);
			break;
    	}
  	}
  	return error_msg;
}

function checkInvalid(text_input_field, field_name, InvalidStr)
// check that no chars in "InvalidStr" appear in input
{
	var str = text_input_field.value;

  for (var i=0; i < InvalidStr.length; i++)
  {
    if (str.indexOf(InvalidStr.charAt(i)) >= 0)
    {
 			alert("\nInvalid character or characters in " + field_name +
			"\n\nThe following characters are not allowed:\n" + InvalidStr);
			return false;
    }
  }
  return true;
}


function checkInt(text_input_field, field_name, min_value, max_value, required)
// NOTE: Doesn't allow negative numbers, required is true/false
{
	var str = text_input_field.value;
	var error_msg= "";
	

	if (text_input_field.value.length==0) // blank
	{
		if (required)
			error_msg = addstr(msg_blank,field_name);
	}
	else // not blank, check contents
	{
		for (var i=0; i < str.length; i++)
		{
			if ((str.charAt(i) < '0') || (str.charAt(i) > '9'))
				error_msg = addstr(msg_check_invalid,field_name);
		}
		if (error_msg.length < 2) // don't parse if invalid
		{

			var int_value = parseInt(str, 10);
			if (int_value < min_value)
				error_msg = addstr(msg_greater,field_name,(min_value - 1));
			if (int_value > max_value)
				error_msg = addstr(msg_less,field_name,(max_value + 1));
		}
	}
	if (error_msg.length > 1)
		error_msg = error_msg + "\n";
	return(error_msg);
}

function search_string(s_string, sub_string)
{
	var i=0, j;
	var first_char = sub_string.charAt(0);
	var sub_length = sub_string.length;
	
	while (i < s_string.length)
	{
		if (s_string.charAt(i) == first_char)
		{
			j = 0;
			while ((j < sub_length) && (s_string.charAt(i+j) == sub_string.charAt(j)))
					j++;
			if (j == sub_length) // all chars match
				return(i); // match starts at i
		}
		i++;
	}
	return -1; // not found
}

function getRadioCheckedValue(radio_object)
{
	var size = radio_object.length;
	for (var i = 0; i < size; i++)
	{
		if (radio_object[i].checked == true)
			return(radio_object[i].value)
	}
	return (radio_object[0].value); // first value if nothing checked
}

function getRadioIndex(radio_object, checked_value)  
{
	var size = radio_object.length;
	for (var i = 0; i < size; i++)
	{
		if (radio_object[i].value == checked_value)
			return  i;
	}

	return  0;   // if no match
}

function getSelIndex(sel_object, sel_text)
{
	if (sel_text.length == 0)
		return -1;   //  Nothing may be valid. e.g. New SAP contain errors & returned.
	var size = sel_object.options.length;
	for (var i = 0; i < size; i++)
	{
		if (sel_object.options[i].text == sel_text)
			return(i);
	}
	return -1;  // if no match
}


function checkIpValue(ip1,ip2,ip3,ip4,min1,max1,min2,max2,min3,max3,min4,max4,flag,msg)
{
	var error_msg = "";

	error_msg=checkInt(ip1,msg,min1,max1,flag);
	if(error_msg.length>0)
		return error_msg;
	error_msg=checkInt(ip2,msg,min2,max2,flag);
	if(error_msg.length>0)
		return error_msg;
	error_msg=checkInt(ip3,msg,min3,max3,flag);
	if(error_msg.length>0)
		return error_msg;
	error_msg=checkInt(ip4,msg,min4,max4,flag);
	if(error_msg.length>0)
		return error_msg;
		
	return error_msg;
}

function makeStr(strchar, strSize)
{
	var newStr = "";
	for (var i = 0; i < strSize; i++)
		newStr+= strchar;
	return newStr;
}

function ignoreSpaces(string)
{
       var temp = "";
       var first=1;
       
       string = '' + string;
       splitstring = string.split(" ");
       for(i = 0; i < splitstring.length; i++)
            if(splitstring[i]!=""){
                if(first==1){
                      if(splitstring[i]!=" "){
                          temp=splitstring[i];
                          first=0;
                      }
                }          
               else
                      temp = temp +  " " + splitstring[i];
            }          
       return temp;
}