#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include "logging.h"
#include "main.h"
#include "commands.h"
#include "utility.h"
//#include "PRO_file.h"


static char *isShare(char *p1,usershare *shares);

typedef struct code_trans {
   char code1[2];
   char code2[2];
   int  num;
} code_trans;

static code_trans code_ta[]={
	{{0x87,0x54},{0xfa,0x4a},10},
	{{0xee,0xef},{0xfa,0x40},10},
	{{0x87,0x82},{0xfa,0x59},1},
	{{0x87,0x84},{0xfa,0x5a},1},
	{{0x87,0x8a},{0xfa,0x58},1}
/*	{{0x87,0x90},{0x81,0xe0},1},
	{{0x87,0x91},{0x81,0xdf},1},
	{{0x87,0x92},{0x81,0xe7},1},
	{{0x87,0x95},{0x81,0xe3},1},
	{{0x87,0x96},{0x81,0xdb},1},
	{{0x87,0x97},{0x81,0xda},1},
	{{0x87,0x9a},{0x81,0xe6},1},
	{{0x87,0x9b},{0x81,0xbf},1},
	{{0x87,0x9c},{0x81,0xbe},1},
	{{0xed,0x40},{0xfa,0x5c},35},
	{{0xed,0x63},{0xfa,0x80},28},
	{{0xed,0x80},{0xfa,0x9c},97},
	{{0xed,0xe1},{0xfb,0x40},28},
	{{0xee,0x40},{0xfb,0x5c},35},
	{{0xee,0x63},{0xfb,0x80},35},
	{{0xee,0x80},{0xfb,0x9c},97},
	{{0xee,0xe1},{0xfc,0x40},12},
	{{0xee,0xf9},{0x81,0xca},1},
	{{0xee,0xfa},{0xfa,0x55},1},
	{{0xfa,0x54},{0x81,0xca},1},
	{{0xfa,0x5b},{0x81,0xe6},1}  
*/
};

static int hd_mode[] = {
    DSK1_MODE,
    DSK2_MODE
};

void transfer(unsigned char *input,int flag)
{
	int i,j,k,len,code_num;
	unsigned char c0,c1,c2,c3;
	unsigned char *p,*q;
		
	code_num = sizeof(code_ta) / sizeof(struct code_trans);
	len = strlen(input);
	p=q=input;
	for(i =0;i<len;i++)
	{	
		for(j=0;j<code_num;j++)
		{	
			if(!flag)
			{
				c0=code_ta[j].code1[0];
				c1=code_ta[j].code1[1];
				c2=code_ta[j].code2[0];
				c3=code_ta[j].code2[1];
			}
			else 
			{
				c0=code_ta[j].code2[0];
				c1=code_ta[j].code2[1];
				c2=code_ta[j].code1[0];
				c3=code_ta[j].code1[1];
			}

				
			if((*p)==c0)
			{	
				if(i!=0){
					if( ((*(p-1)>=0x80 && *(p-1)<=0x9F) || (*(p-1)>=0xE0 && *(p-1)<=0xEF) || (*(p-1)>=0xF0 && *(p-1)<=0xFC)) && ((*p>=0x40 && *p<=0x7E) || (*p>=0x80 && *p<=0xFC))){
						goto next;
					}
				}				
				q=p+1;
				for(k=0;k<code_ta[j].num;k++)
				{
					if((*q)==(c1+k))
					{
						*p = c2;
						*q = c3+k;
						p ++;
						i ++;
						break;
					}
						
				}		
			}	
		}
next:	
		p = p+1;
		q = p;
	}
	return;
}

char *convertDir(char *dirname,usershare *usershare,char *current_share)
{
     char *p1=NULL,*p2=NULL,*p3=NULL,*p4=NULL;
     char dir1[MAXCMD + 1];
     char cwd[256];   
      
     if(!dirname||!dirname[0]||!usershare)
           return NULL;
     getcwd(cwd, sizeof(cwd) - 1);
     bftpd_log("[%s:%d] cwd is <%s> and dirname is <%s>.\n", __FILE__, __LINE__, cwd, dirname);
     if(strcmp(cwd,"/")==0&&dirname[0]=='.')
     	strcpy(dir1,dirname+1);
     else
     	strcpy(dir1,dirname);	
     p1=strtok(dir1,"/");
     if(!p1)  
           return NULL;
     else{
              p3=isShare(p1,usershare);
            bftpd_log("[%s:%d] p1 is <%s> and p3 is <%s>.\n", __FILE__, __LINE__, p1, p3);
              if(!p3)
              	return NULL;
              else{
                    p2=strtok(NULL,"");
                    if(!p2){
                        if(current_share)
                           strcpy(current_share,p1);
                        bftpd_log("[%s:%d] current_share is <%s> and p3 is <%s>.\n", __FILE__, __LINE__, current_share, p3);
                        return p3;
                    }    
                    else{
                    	if(p3[strlen(p3)-1]!='/')
                        	p4=malloc(strlen(p2)+strlen(p3)+2);
                        else
                        	p4=malloc(strlen(p2)+strlen(p3)+1);
                        if(!p4){
                             free(p3);
                             return NULL;                             
                        }      
                         else{
                         	if(p3[strlen(p3)-1]!='/')
                               		sprintf(p4,"%s/%s",p3,p2);
                               	else
                               		sprintf(p4,"%s%s",p3,p2);
                               free(p3);
                               if(current_share)
                                    strcpy(current_share,p1);
                                bftpd_log("[%s:%d] current_share is <%s> and p4 is <%s>.\n", __FILE__, __LINE__, current_share, p4);

                               return p4;
                      }       
                 }    
            }	
     }
     if(current_share)
         current_share[0]=0;
     return NULL;
}
 
static char *isShare(char *p1,usershare *shares)
{
    char *shareDir;
    usershare *current;   
     
    if(!p1||!shares)
         return NULL;
    current=shares;
    while(current){
	 if(!strcmp(p1,current->share)){
//             shareDir=malloc(strlen(current->dir)+1);
             shareDir=malloc(300);

             if(!shareDir){
                 return NULL;
                }
                
              strcpy(shareDir,current->dir);
              transfer(shareDir,0);
              return shareDir;
         }
	 current=current->next;
     }
     return NULL;
}             
  
#ifndef NO_GROUP
int userInGroup(char *usr,char *group)
 {
 	group_list *glist;
 	grp_user *gUser;
 	int i=0;
 	 
 	if(!usr||!usr[0]||!group||!group[0])
 	    	return 0;
        glist=ginfo;
        while(glist)
	{ 
          	if(!strcmp(group,glist->name))
		{
          		gUser=glist->pUser;
            		while(i<gUser->nUsers){
              			if(strcmp(usr,*((gUser->ppUser)+i))==0)
                 			return 1;
              			i++;
            		}  
          	} 
          	glist=glist->pNext;
        }  
        return 0;	      
} 	
#endif 

int getUserShare(char *usr,usershare **shares)
{
 	sh_list *shlist; 
#ifndef NO_GROUP 	
 	grp_list *group;
 	int i=0;
#else
        u_list *u;
#endif          
 	usershare *newitem,*tail=NULL;
 	int find=0;
 	
#ifndef NO_GROUP 	
 	i=userInGroup(usr,FSH_ADMIN_GRP);
#endif 	
        for(shlist=shinfo;shlist;shlist=shlist->pNext){
               find=0; 
#ifndef NO_GROUP               	
               if(i)
                  find=1;
               else{	
                   group=shlist->pGroup;
                   while(group){
      	              if(userInGroup(usr,group->name)){   
      	              	 find=1;
      	              	 break;
      	             } 	 
      	              group=group->pNext;
      	           }
      	       } 
#else
                u=shlist->user;
                while(u){
      	              if(!strcmp(usr,u->name)){   
      	              	 find=1;
      	              	 break;
      	             } 	 
      	             u=u->next;
      	        }
#endif
      	       if(find){      
      	          newitem=(usershare *)malloc(sizeof(usershare));  	
      	          if(!newitem)
      	             goto err;
      	          newitem->next=NULL;
      	          if(!tail)
      	              *shares=tail=newitem;
      	          else{
      	             tail->next=newitem;
      	             tail=tail->next;
      	          }
      	          newitem->share=malloc(strlen(shlist->sh.name)+1);
      	          if(!(newitem->share))
      	             goto err;
      	          newitem->dir=malloc(strlen(shlist->sh.dir)+50);
      	          if(!(newitem->dir))
      	             goto err;	
      	          strcpy(newitem->share,shlist->sh.name);

                  if(hd_mode[shlist->sh.hard_index] == DSK_MODE_NORMAL /* FIRST_DSK */){
                      sprintf(newitem->dir, "%s%s", FSH_MNTHD1_DATA, shlist->sh.dir);  
                  }
                  else if(hd_mode[shlist->sh.hard_index] == DSK_MODE_SHARE /* SECOND_DSK */){
                      sprintf(newitem->dir, "%s%s", FSH_FLASH_SHARE_DIR, shlist->sh.dir);
                  }

                  bftpd_log("newitem->dir is <%s>.\n", newitem->dir);
      	          //sprintf(newitem->dir,"/hd~%d/data%s",shlist->sh.hard_index,shlist->sh.dir);
      	      }        
       }
       return 0;
err:
     freeUserShare(*shares);
     return 1;
}

int getShareDir(char *sharename,char *dir)
{
  usershare *current;
  int len=0;
      	
  if(!share||!dir)
    return 1;
  current=share;
  while(current){     
       if(!strcmp(current->share,sharename)){
       	    strcpy(dir,current->dir);
       	    len=strlen(dir)-1;
       	    if(dir[len]=='/'&&len!=0)
       	       dir[len]=0;
       	    return 0;
       }	        
       current=current->next;
  }
  return 0;        	
	
}	 
 
void  freeUserShare(usershare *shares)
{
	usershare *current;
	
	current=shares;
	while(current){
		if(current->share)
		      free(current->share);
		if(current->dir)
		      free(current->dir);   
		current=current->next;
	}
	return;
}		      
	
int folderIsShare(char *folder,usershare *shares)
{
    usershare *current;
    char p1[FSH_MaxShareLen+6];
    char cwd[256];
    
    bftpd_log("folder is <%s>.\n", folder);
    if(!folder||!folder[0])
        return 0;
    if(strstr(folder,"/.")||strstr(folder,"../"))
       return 1;    
    getcwd(cwd, sizeof(cwd) - 1);    
    current=shares;
    while(current){
    	strcpy(p1,current->share);
        bftpd_log("p1 is <%s> folder is <%s> pwd is <%s> cwd is <%s>\n",
                p1, folder, pwd, cwd);
        //if(!strcmp(folder,p1)&&strstr(pwd,"/hd~")!=pwd&&!strcmp(cwd,"/"))
#ifndef __FOR_SINGLE_HDD_AND_USB_
        if(!strcmp(folder,p1)&&strstr(pwd,FSH_HD1_NAME)!=pwd&&strstr(pwd,FSH_HD2_NAME)!=pwd&&!strcmp(cwd,"/"))
#else
        if(!strcmp(folder,p1)&&strstr(pwd,FSH_MNT_DIR_HDD"/"FSH_HD1_NAME)!=pwd&&strstr(pwd, FSH_MNT_DIR_USB_FLASH)!=pwd&&!strcmp(cwd,"/"))
#endif
            return 1;
        sprintf(p1,"/%s",current->share);
        if(!strcmp(folder,p1))
            return 1;
        sprintf(p1,"/%s/",current->share);
        if(!strcmp(folder,p1))
            return 1;
        sprintf(p1,"./%s",current->share);
        //if(!strcmp(folder,p1)&&strstr(pwd,"/hd~")!=pwd&&!strcmp(cwd,"/"))
#ifndef __FOR_SINGLE_HDD_AND_USB_
        if(!strcmp(folder,p1)&&strstr(pwd,FSH_HD1_NAME)!=pwd&&strstr(pwd,FSH_HD2_NAME)!=pwd&&!strcmp(cwd,"/"))
#else
        if(!strcmp(folder,p1)&&strstr(pwd,FSH_MNT_DIR_HDD"/"FSH_HD1_NAME)!=pwd&&strstr(pwd, FSH_MNT_DIR_USB_FLASH)!=pwd&&!strcmp(cwd,"/"))
#endif
            return 1;
        sprintf(p1,"./%s/",current->share);
        //if(!strcmp(folder,p1)&&strstr(pwd,"/hd~")!=pwd&&!strcmp(cwd,"/"))
#ifndef __FOR_SINGLE_HDD_AND_USB_
        if(!strcmp(folder,p1)&&strstr(pwd,FSH_HD1_NAME)!=pwd&&strstr(pwd,FSH_HD2_NAME)!=pwd&&!strcmp(cwd,"/"))
#else
        if(!strcmp(folder,p1)&&strstr(pwd,FSH_MNT_DIR_HDD"/"FSH_HD1_NAME)!=pwd&&strstr(pwd, FSH_MNT_DIR_USB_FLASH)!=pwd&&!strcmp(cwd,"/"))
#endif
            return 1;
		sprintf(p1,"%s/",current->share);
        //if(!strcmp(folder,p1)&&strstr(pwd,"/hd~")!=pwd&&!strcmp(cwd,"/"))
#ifndef __FOR_SINGLE_HDD_AND_USB_
        if(!strcmp(folder,p1)&&strstr(pwd,FSH_HD1_NAME)!=pwd&&strstr(pwd,FSH_HD2_NAME)!=pwd&&!strcmp(cwd,"/"))
#else
        if(!strcmp(folder,p1)&&strstr(pwd,FSH_MNT_DIR_HDD"/"FSH_HD1_NAME)!=pwd&&strstr(pwd, FSH_MNT_DIR_USB_FLASH)!=pwd&&!strcmp(cwd,"/"))
#endif     
            return 1;
        current=current->next;
    }
    return 0;       
}	

void getUpDir(char *dir)
{
	char *p1;
	int len=0;
  	
	if(!dir)
		return;
	len=strlen(dir);
	if(len>1){
		len--;
		while(*(dir+len)=='/'){
			*(dir+len)='\0';
			len--;	
		}	     
	}
	p1=strrchr(dir,'/');
	if(!p1)
		return;
	if(p1==dir){
		strcpy(dir,"/");     	
		return;
	}
	*p1=0;
	return;  
}

int checkFolder(char *filename,usershare *shares,int *readonly, int *convert, int flag)
{
  char file[MAXCMD + 1],*p1;
  char cwd[256];
  usershare *current;
  sh_list *shlist; 
#ifndef NO_GROUP  
  grp_list *group;
  int i=0;
#else
  u_list *u;
#endif  
  int len;
  
  if(!filename||!shares)
      return 1;
  getcwd(cwd, sizeof(cwd) - 1);
//  DBCS_SJIS2CAP(filename,0);
  transfer(filename,0);
  if(strncmp(filename,"..",2)==0)
  	return 1;
  if(strcmp(cwd,"/")==0&&filename[0]=='.')
	filename++; 
  if(strcmp(cwd,"/")==0&&*filename=='\0')
	*filename='/';
  if(!strcmp(filename,"/")){
     if(flag)
        return 2;  	
     if(readonly)
        *readonly=0;	    
     return 0;
  }
  len=strlen(filename)-1;
  if(strstr(filename,"../")==filename||strstr(filename,"/../")||(filename[len]=='.' && filename[len-1]=='.' && filename[len-2]=='/')) 
      return 1;
  strcpy(file,filename);          
  p1=strtok(file,"/");
  if(!p1)
     return 1;
#ifndef NO_GROUP     
  i=userInGroup(user,FSH_ADMIN_GRP);   
#endif  
  bftpd_log("cwd is <%s> pwd is <%s>.\n", cwd, pwd);
#ifndef __FOR_SINGLE_HDD_AND_USB_
  if(!strcmp(cwd,"/")&& /* strstr(pwd,"/hd~")!=pwd */ strstr(pwd, FSH_HD1_NAME)!=pwd && strstr(pwd, FSH_HD2_NAME)!=pwd){
#else
  if(!strcmp(cwd,"/")&& strstr(pwd, FSH_MNT_DIR_HDD"/"FSH_HD1_NAME)!=pwd && strstr(pwd, FSH_MNT_DIR_USB_FLASH)!=pwd){
#endif
	current=shares;   
        while(current){
            bftpd_log("p1 is <%s> share is <%s>.\n", p1, current->share);
              if(!strcmp(p1,current->share)){
              	    if(flag){
              	       if(folderIsShare(filename,shares))
              	          return 2;
              	    }
                    if(readonly){
#ifndef NO_GROUP                    	
                       if(i){
                       	 *readonly=1;
      	                     return 0;
                       }	
                       else{	
                          for(shlist=shinfo;shlist;shlist=shlist->pNext){
                      	        if(strcmp(shlist->sh.name,p1))
   	                           continue;   
                                group=shlist->pGroup;
                                while(group){
      	                           if(userInGroup(user,group->name)){      	
      	                               *readonly=(group->nAccess==7)?1:0;
      	                               return 0;
      	                            }   
      	                            group=group->pNext;
                                }
                          }	
                          *readonly=0;
                          return 0;
                      }    
#else
                      for(shlist=shinfo;shlist;shlist=shlist->next){
                         if(strcmp(shlist->sh.name,p1))
   	                    continue;   
                         u=shlist->user;
                         while(u){
      	                    if(!strcmp(user,u->name)){      	
      	                        *readonly=(u->access==7)?1:0;
      	                         return 0;
      	                     }   
      	                     u=u->next;
                         }
                      }	
                      *readonly=0;
                      return 0;
#endif                       
                   }	 
                   return 0;
              }//if(!strcmp(p1,current->share)){   
              current=current->next;
        }
        if(flag)
           return 2;
        else
           return 1;
   }
   else{
     if(filename[0]=='/'){
     	current=shares;   
        while(current){
              if(!strcmp(p1,current->share)){
              	  if(flag){
              	      if(folderIsShare(filename,shares))
              	         return 2;
              	  }  
                  if(readonly){
#ifndef NO_GROUP                      	
                       if(i){
                       	   *readonly=1;
      	                   return 0;
                       }	
                       else{	
                           for(shlist=shinfo;shlist;shlist=shlist->pNext){
                      	       if(strcmp(shlist->sh.name,p1))
   	                             continue;   
                               group=shlist->pGroup;
                               while(group){
      	                          if(userInGroup(user,group->name)){      	
      	                               *readonly=(group->nAccess==7)?1:0;
      	                               return 0;
      	                          }   
      	                          group=group->pNext;
                               }
                           }	
                           *readonly=0;
                       }	  
                       return 0;
#else
                       for(shlist=shinfo.shlist;shlist;shlist=shlist->next){
                                if(strcmp(shlist->name,p1))
   	                            continue;   
                                u=shlist->user;
                                while(u){
      	                           if(!strcmp(user,u->name)){      	
      	                               *readonly=(u->access==7)?1:0;
      	                               return 0;
      	                           }   
      	                           u=u->next;
                                }
                       }	
                       *readonly=0;
                       return 0;
#endif                       
                    }  
                    return 0; 
              } //if(!strcmp(p1,current->share))     
              current=current->next;
        }
        if(flag)
           return 2;
        else
           return 1; 
     }
     else{
         if(convert) 
           *convert=0;      
         if(readonly){
#ifndef NO_GROUP         	
            if(i){
               *readonly=1;
      	       return 0;
            }	
            else{		
               for(shlist=shinfo;shlist;shlist=shlist->pNext){
                  if(strcmp(shlist->sh.name,currentshare))
   	             continue;   
                  group=shlist->pGroup;
                  while(group){
      	             if(userInGroup(user,group->name)){      	
      	                *readonly=(group->nAccess==7)?1:0;
      	                return 0;
      	             }   
      	             group=group->pNext;
                  }
               }	//for
               *readonly=0;
            }   
#else
            for(shlist=shinfo;shlist;shlist=shlist->next){
                if(strcmp(shlist->sh.name,currentshare))
   	            continue;   
                u=shlist->user;
                while(u){
      	             if(!strcmp(user,u->name)){      	
      	                   *readonly=(u->access==7)?1:0;
      	                   return 0;
      	             }   
      	             u=u->next;
                }
            }	
            *readonly=0;
            return 0;

#endif            
        }
         return 0;	           	
      }                 
   } 
   return 1;    
}					
