#!/bin/sh
#=================================================================
# This script will build Inter IXP lib's "environment.linux.sh".
# Only need HARDHAT_BASE as the first argument for we assume that
# we have already known the locations of kernel and IXP lib.
#=================================================================

if [ $# -ne 1 ] ; then
    echo "You should tell me where your Monta vista install!"
    exit 1
fi

ROOTDIR=`/bin/pwd`
LINUXDIR="$ROOTDIR"/kernel
IXPLIBDIR="$ROOTDIR"/ixp400_xscale_sw
HARDHATDIR="$1"

ENV_FILE="$IXPLIBDIR"/buildUtils/environment.linux.sh
#=================================================================

# Build the environment file
cat <<EOF >"$ENV_FILE"
#
# Automatically generated by "mkixpenv.sh", dont edit it
#
# Change the following line to point to your linux kernel source tree
LINUX_SRC=$LINUXDIR

# Change the following line to point to the root of your Monta Vista install
HARDHAT_BASE=$HARDHATDIR

# You may want to edit the following to point to your ixp400_xscale_sw
# directory. Otherwise you must source this file from that directory.
IX_XSCALE_SW=$IXPLIBDIR

IX_TARGET=linuxbe

export LINUX_SRC HARDHAT_BASE IX_XSCALE_SW IX_TARGET
EOF

