/**
 * ============================================================================
 * = COPYRIGHT
 * File Version: $Revision: 1.1.1.1 $
 * 
 * -- Intel Copyright Notice --
 * 
 * Copyright 2002-2003 Intel Corporation All Rights Reserved.
 * 
 * The source code contained or described herein and all documents
 * related to the source code ("Material") are owned by Intel Corporation
 * or its suppliers or licensors.  Title to the Material remains with
 * Intel Corporation or its suppliers and licensors.
 * 
 * The Material is protected by worldwide copyright and trade secret laws
 * and treaty provisions. No part of the Material may be used, copied,
 * reproduced, modified, published, uploaded, posted, transmitted,
 * distributed, or disclosed in any way except in accordance with the
 * applicable license agreement .
 * 
 * No license under any patent, copyright, trade secret or other
 * intellectual property right is granted to or conferred upon you by
 * disclosure or delivery of the Materials, either expressly, by
 * implication, inducement, estoppel, except in accordance with the
 * applicable license agreement.
 * 
 * Unless otherwise agreed by Intel in writing, you may not remove or
 * alter this notice or any other notice embedded in Materials by Intel
 * or Intel's suppliers or licensors in any way.
 * 
 * For further details, please see the file README.TXT distributed with
 * this software.
 * 
 * -- End Intel Copyright Notice --
 *
 * = PRODUCT
 *      Intel(r) IXP425 Software Release
 *
 * = LIBRARY
 *      OSSL - Operating System Services  Library
 *
 * = MODULE
 *      OSSL OSAPI Fucntions Interface layer header file
 *
 * = FILENAME
 *       os_api.h
 *
 * = DESCRIPTION
 *   This file contains the prototypes of OS specific wrapper
 *   functions. These API functions are called by OSSL APIs.
 *   The functions can be divided into following classes:
 *
 *        thread-related wrapper functions around thread calls
 *        synchronization-related wrapper function around mutex and semaphores       
 *
 *   Both classes of functions provide the basic types of function one
 *   would expect. Namely, creation and deletion functions as well as
 *   the standard "wait" and "exit". Additionally, a couple of utility
 *   functions which enable to pause the execution of a thread
 *   are also provided.
 *
 *   Note: A slew of othe wrapper functions around semaphores,
 *         mutexes, and timers are also defined.
 *
 *   OS Thread APIs: 
 *              os_thread_create
 *              os_thread_get_id
 *              os_thread_kill
 *              os_thread_exit
 *              os_thread_set_priority
 *
 **********************************************************************
 *   OS Semaphore APIs
 *
 *   Contains the VxWorks wrapper functions that allows for initialization,
 *   posting, waiting and deletion of thread semaphores.
 *
 *   Function: os_thread_sema_create
 *             os_thread_sema_P
 *             os_thread_sema_flush
 *             os_thread_sema_V
 *             os_thread_sema_destroy
 *
 * 
 **********************************************************************
 *
 *********************************************************************
 *   OS Mutex APIs
 *
 *   Contains the VxWorks wrapper functions that allows for initialization,
 *   posting, waiting and deletion of thread mutexes.
 *
 *   Function: os_thread_mutex_create
 *             os_thread_mutex_lock
 *             os_thread_mutex_unlock
 *             os_thread_mutex_destroy
 *
 *
 **********************************************************************
 **********************************************************************
 *   OS Timer APIs
 *
 *   Contains the VxWorks wrapper functions that allows for initialization,
 *   posting, waiting and deletion of thread mutexes.
 *
 *   Function: os_sleep
 *             os_sleep_tick
 *             os_time_get
 *
 **********************************************************************
 *      
 *
 * = AUTHOR
 *      Intel Corporation
 *
 * = AKNOWLEDGEMENTS
 *      
 *
 * = CREATION TIME
 *      1/8/2002 1:53:42 PM
 *
 * = CHANGE HISTORY
 *  Moved the OS header files from ossl.h to os_api.h 
 *
 * ============================================================================
 */

#ifndef _OSAPI_H
#define _OSAPI_H

/* INCLUDES */

#ifdef __vxworks

#include  "errno.h"
#include  "unistd.h"
#include "string.h"
#include "signal.h"
#include "vxWorks.h"
#include "memLib.h"
#include "signal.h"
#include "private/sigLibP.h"
#include "private/timerLibP.h"
#include "taskLib.h"
#include "taskHookLib.h"
#include "semLib.h"
#include "private/semLibP.h"
#include "timers.h"
#include "time.h"
#include "errno.h"
#include "string.h"
#include "sched.h"
#include "objLib.h"
#include "intLib.h"
#include "smObjLib.h"
#include "stdlib.h"
#include "ix_ossl.h"
#include "os_datatypes.h"
#include "sysLib.h"


/* Define the error code returned by OS functions */

#define  VXWORKS_SUCCESS OK
#define  SEMA_SUCCESS OK
#define  SEMA_ERROR -1
#define  OS_SUCCESS 0       /* os call is successful */

#endif



/* FUNCTIONS */

#ifdef __cplusplus
extern "C"{
#endif

/**
 * NAME: os_thread_create
 *
 * DESCRIPTION: Create a cancellable thread that will execute the
 *               user-provided entry point function. Custom arguments
 *               can be passed to this function using the "arg"
 *               argument. 
 *
 * @Param:  - IN       start_routine  pointer to thread's entry point function
 *
 * @Param:  - IN       ptrThreadInfo  pointer to custom argument structure that
 *                                      will be passed to entry point function
 *
 * @Param:  - OUT      ptrTid         address at which the thread id of the
 *                                    newly created thread will be returned
 * @Param:  - OUT      osError        pointer to the datastructure where OS 
 *                                    error codes are returned.
 */
int  os_thread_create(
                      void * (*start_routine)(void *),
                      ix_ossl_thread_main_info_t *ptrThreadInfo,
                      ix_ossl_thread_t* ptrTid, 
                      os_error* osError
                     );

                                
/**
 * NAME: os_thread_get_id
 *
 * DESCRIPTION: Returns the thread id of the calling thread
 *
 * @Param:  - OUT       address at which the thread id of the
 *                      inquiring thread will be returned
 * 
 */
int os_thread_get_id(ix_ossl_thread_t* ptrTid);                               
                                
/**
 * NAME: os_thread_exit
 *
 * DESCRIPTION: This function causes the calling thread to exit. It
 *              gives the opportunity (this is not a requirement!) to
 *              the caller to pass back to a waiting parent a pointer
 *              to a custom data structure and an ix_error token.
 *
 *
 * @Param:  - OUT    retObj  pointer to custom data structure
 *                           (null if no data structure is returned)
 *
 */
int os_thread_exit(void* retObj);


/**
 * NAME: os_thread_kill
 *
 * DESCRIPTION: Kills the running thread specified by its thread id.
 *
 * @Param:  - IN         tid     id of the thread to be killed
 *
 * @Param:  - OUT       osError  pointer to the datastructure where OS 
 *                               error conditions are returned. 
 */
int  os_thread_kill(ix_ossl_thread_t tid, os_error* osError);

/**
 * NAME: os_thread_set_priority
 *
 * DESCRIPTION: This function sets the priority of the indicated thread.
 *     	        possible values for 'priority' are IX_OSSL_PRI_HIGH, 
 *              IX_OSSL_PRI_MED, and IX_OSSL_PRI_LOW. The effect of priority
 *              is OS dependant.  	  
 *
 * @Param:  - IN    pointer to the thread object 
 * @Param:  - IN    priority  priority level.
 * @Param:  - OUT   osError   pointer to the datastructure where OS 
 *                  error conditions are returned.
 *
 */
ix_error os_thread_set_priority(
                                ix_ossl_thread_t* tid, 
                                ix_ossl_thread_priority  priority,
			                             os_error* osError
                               ); 


/**
 * NAME: os_thread_sema_create
 *
 * DESCRIPTION: Create a thread semaphore object.
 *
 * @Param:  - IN    value that the semaphore should be initialize to.
 *
 * @Param:  - OUT   id of the thread semaphore created.
 * @Param:  - OUT   osError   pointer to the datastructure where the 
 *                  error conditions are returned.
 */
int  os_thread_sema_create(
                           int value, 
                           ix_ossl_sem_t* sid, 
                           os_error* osError
                          );

/**
 * NAME: os_thread_sema_P
 *
 * DESCRIPTION: Waits on the specified semaphore until the units are available
 *              or timeout occurs. 
 *
 * @Param:  - IN    sid      pointer  to the semaphore object.
 * @Param:  - IN    timeout  timeout value.
 * @Param:  - OUT   osError  pointer to the datastructure where the 
 *                           error conditions are returned.
 */
int  os_thread_sema_P(
                      ix_ossl_sem_t* sid,
                      ix_uint32 timeout,
                      os_error* osError
                     );

/**
 * NAME: os_thread_sema_V
 *
 * DESCRIPTION: This function releases the specified  semaphore and the
 *              semaphore state becomes available after this function call.
 *
 * @Param:  - IN      sid       pointer to the thread semaphore object.
 * @Param:  - OUT     osError   pointer to the datastructure where the 
 *                              error conditions are returned.
 *
 */
int  os_thread_sema_V(ix_ossl_sem_t* sid, os_error* osError);


/**
 * NAME:  os_thread_sema_destroy
 *
 * DESCRIPTION: Destroy the thread semaphore object.
 *
 * @Param:  - IN   sid       pointer to the thread semaphore object.
 * @Param:  - OUT  osError   pointer to the datastructure where the 
 *                           error conditions are returned.
 */
int  os_thread_sema_destroy(ix_ossl_sem_t* sid, os_error* osError);


/**
 * NAME: os_thread_mutex_create
 *
 * DESCRIPTION: Create a thread mutex object.
 *
 * @Param:  - IN      start_state  the value that the mutex state should be initialized to.
 *
 * @Param:  - OUT     mid          id of the thread mutex created.
 * @Param:  - OUT     osError      pointer to the datastructure where the 
 *                                 error conditions are returned.
 *
 */
int  os_thread_mutex_create(
                            ix_ossl_mutex_state start_state,
                            ix_ossl_mutex_t* mid,  
                            os_error* osError
                           );

/**
 * NAME: os_thread_mutex_lock
 *
 * DESCRIPTION: This function locks the mutex. If the mutex is already
 *              locked, the task will block. If the time indicated in 
 *              'timeout' is reached, the task will unblock and retun 
 *              error indication. If timeout is set to '0', the task will
 *              never block.
 *
 * @Param:  - IN  mid       pointer to the thread mutex object.
 * @Param:  - IN  timeout   'timeout' value
 * @Param:  - OUT osError   pointer to the datastructure where the 
 *                          error conditions are returned.
 */
int  os_thread_mutex_lock(
                          ix_ossl_mutex_t* mid, 
                          ix_uint32 timeout, 
                          os_error* osError
                         );

/**
 * NAME: os_thread_mutex_unlock
 *
 * DESCRIPTION: This function unlocks the mutex. If there are tasks
 *              pending on the mutex, the next one is given the lock.
 *              If there are no pending tasks, then the mutex is 
 *              unlocked.
 *
 * @Param:  - IN   mid       pointer to the thread mutex object.
 * @Param:  - OUT  osError   pointer to the datastructure where the 
 *                            error conditions are returned.
 */
int  os_thread_mutex_unlock(ix_ossl_mutex_t* mid, os_error* osError);


/**
 * NAME: os_thread_mutex_destroy
 *
 * DESCRIPTION: Destroy the thread mutex object.
 *
 * @Param:  - IN    mutex      pointer to the thread mutex object.
 * @Param:  - OUT   osError   pointer to the datastructure where the 
 *                            error conditions are returned.
 */
int  os_thread_mutex_destroy(ix_ossl_mutex_t* mutex, os_error* osError);


/**
 * NAME: os_sleep
 *
 * DESCRIPTION: This function causes the calling thread to sleep for the 
 *              specified time.
 *
 * @Param:  - IN sleeptime_ms  sleep time specified in milliseconds.
 * @Param:  - OUTosError       pointer to the datastructure where the 
 *                             error conditions are returned.
 *
 */
int os_sleep(ix_uint32 sleeptime_ms, os_error* osError);

/**
 * NAME: os_sleep_tick
 *
 * DESCRIPTION: This function causes the calling thread to sleep for the 
 *  	           time specified in OS ticks.
 *
 * @Param:  - IN    sleeptime_ticks  sleep time specified in OS ticks.
 * @Param:  - OUT   osError          pointer to the datastructure where the 
 *                                   error conditions are returned.
 *
 */
int os_sleep_tick(ix_uint32 sleeptime_ticks, os_error *osError);

/**
 * NAME: os_time_get
 *
 * DESCRIPTION: This function places the current value of time, in
 *              (seconds, nanoseconds), into the '*ptime' structure. This 
 *              function does not provide a time-of-day. The purpose is 
 *              to provide a nano-second resolution time.
 *
 * @Param:  - OUT ptime         addres to the time structure.
 * @Param:  - OUT osError       pointer to the datastructure where the 
 *                               error conditions are returned.
 *
 */
int os_time_get(ix_ossl_time_t *ptime, os_error *osError);

#ifdef __cplusplus
}
#endif
 
#endif /* _OSSL_H */

