/*
 * File Version: $Revision: 1.1.1.1 $
 * 
 * -- Intel Copyright Notice --
 * 
 * Copyright 2002-2003 Intel Corporation All Rights Reserved.
 * 
 * The source code contained or described herein and all documents
 * related to the source code ("Material") are owned by Intel Corporation
 * or its suppliers or licensors.  Title to the Material remains with
 * Intel Corporation or its suppliers and licensors.
 * 
 * The Material is protected by worldwide copyright and trade secret laws
 * and treaty provisions. No part of the Material may be used, copied,
 * reproduced, modified, published, uploaded, posted, transmitted,
 * distributed, or disclosed in any way except in accordance with the
 * applicable license agreement .
 * 
 * No license under any patent, copyright, trade secret or other
 * intellectual property right is granted to or conferred upon you by
 * disclosure or delivery of the Materials, either expressly, by
 * implication, inducement, estoppel, except in accordance with the
 * applicable license agreement.
 * 
 * Unless otherwise agreed by Intel in writing, you may not remove or
 * alter this notice or any other notice embedded in Materials by Intel
 * or Intel's suppliers or licensors in any way.
 * 
 * For further details, please see the file README.TXT distributed with
 * this software.
 * 
 * -- End Intel Copyright Notice --
*/
#ifndef _LINUX_IXP425_H_
#define _LINUX_IXP425_H_

#include <asm/types.h>
#include <asm/hardware.h>
#include <asm/arch/irqs.h>

 
#include <linux/version.h>
#if (LINUX_VERSION_CODE < KERNEL_VERSION(2,4,20))
/* The names of these IRQ #defines changed from the MontaVista
 * 3.0 (2.4.18) kernel to the 3.1 (2.4.20) kernel. The following
 * lines are for backward compatibility with MVL 3.0.
 */
#define IRQ_IXP425_NPEA         IRQ_IXP425_INTC_NPEA
#define IRQ_IXP425_NPEB         IRQ_IXP425_INTC_NPEB
#define IRQ_IXP425_NPEC         IRQ_IXP425_INTC_NPEC
#define IRQ_IXP425_QM1          IRQ_IXP425_INTC_QM1
#define IRQ_IXP425_QM2          IRQ_IXP425_INTC_QM2
#define IRQ_IXP425_USB          IRQ_IXP425_INTC_USB
#define IRQ_IXP425_TIMER1       IRQ_IXP425_INTC_TIMER1
#define IRQ_IXP425_WDOG         IRQ_IXP425_INTC_WDOG
#define IRQ_IXP425_TIMESTAMP    IRQ_IXP425_INTC_TIMESTAMP
#define IRQ_IXP425_XSCALE_PMU   IRQ_IXP425_INTC_XSCALE_PMU
/* The following is used by perfProfAcc */
#define IRQ_IXP425_AHB_PMU      IRQ_IXP425_INTC_AHB_PMU
#endif /* kernel < 2.4.20 */


#define IXP425_INT_LVL_NPEA     IRQ_IXP425_NPEA
#define IXP425_INT_LVL_NPEB     IRQ_IXP425_NPEB
#define IXP425_INT_LVL_NPEC     IRQ_IXP425_NPEC

#define IXP425_INT_LVL_QM1      IRQ_IXP425_QM1
#define IXP425_INT_LVL_QM2      IRQ_IXP425_QM2
#define IXP425_INT_LVL_USB      IRQ_IXP425_USB

#define IXP425_INT_LVL_TIMER1     IRQ_IXP425_TIMER1
#define IXP425_INT_LVL_TIMER2     IRQ_IXP425_TIMER2
#define IXP425_INT_LVL_WDOG       IRQ_IXP425_WDOG
#define IXP425_INT_LVL_TIMESTAMP  IRQ_IXP425_TIMESTAMP
#define IXP425_INT_LVL_XSCALE_PMU IRQ_IXP425_XSCALE_PMU

#define IXP425_OSST_TICKS_PER_SECOND	60

#endif
