/*
 * File Version: $Revision: 1.1.1.1 $
 * 
 * -- Intel Copyright Notice --
 * 
 * Copyright 2002-2003 Intel Corporation All Rights Reserved.
 * 
 * The source code contained or described herein and all documents
 * related to the source code ("Material") are owned by Intel Corporation
 * or its suppliers or licensors.  Title to the Material remains with
 * Intel Corporation or its suppliers and licensors.
 * 
 * The Material is protected by worldwide copyright and trade secret laws
 * and treaty provisions. No part of the Material may be used, copied,
 * reproduced, modified, published, uploaded, posted, transmitted,
 * distributed, or disclosed in any way except in accordance with the
 * applicable license agreement .
 * 
 * No license under any patent, copyright, trade secret or other
 * intellectual property right is granted to or conferred upon you by
 * disclosure or delivery of the Materials, either expressly, by
 * implication, inducement, estoppel, except in accordance with the
 * applicable license agreement.
 * 
 * Unless otherwise agreed by Intel in writing, you may not remove or
 * alter this notice or any other notice embedded in Materials by Intel
 * or Intel's suppliers or licensors in any way.
 * 
 * For further details, please see the file README.TXT distributed with
 * this software.
 * 
 * -- End Intel Copyright Notice --
*/
#ifndef _VX_H_
#define _VX_H_

#include <vx_types.h>
#include <linux/time.h>
#include <linux/version.h> /* needed for backward-compatibility check below */

int task_data_start_internal(void *unused);

int taskSpawn (
    char *  name,      /* name of new task (stored at pStackBase) */
    int     priority,  /* priority of new task */
    int     options,   /* task option word */
    int     stackSize, /* size (bytes) of stack needed plus name */
    FUNCPTR entryPt,   /* entry point of new task */
    int     arg1,      /* 1st of 10 req'd task args to pass to func */
    int     arg2,
    int     arg3,
    int     arg4,
    int     arg5,
    int     arg6,
    int     arg7,
    int     arg8,
    int     arg9,
    int     arg10
);

STATUS taskDelete(int tid);

int taskIdSelf(void);

STATUS taskDelay(int ticks);

STATUS taskPrioritySet(int tid, int newPriority);

int sysClkRateGet(void);

#define CLOCK_REALTIME 0

//#if (LINUX_VERSION_CODE < KERNEL_VERSION(2,4,20))
/* Seems SnapGear linux do not define this. Argon Cheng 2005-01-10 */
/* The Monta Vista 3.1 (2.4.20) kernel headers define a clockid_t
 * type. The following line is for backward compatibility with the 3.0
 * (2.4.18) kernel.
 */
/*temporarily remove it to compile nas_camera*/
#ifndef clockid_t
typedef int clockid_t;
#endif

//#endif

int clock_gettime(clockid_t clock_id, struct timespec *tp);

ULONG tickGet(void);

typedef struct semaphore *SEM_ID;
#define WAIT_FOREVER (-1)
#define NO_WAIT (0)
STATUS semGive(SEM_ID semId);
STATUS semTake(SEM_ID semId, int timeout);

#define logInit(fd, maxMsgs)
#define logFdSet(fd)
#define ioTaskStdGet(task, fd)

#define logMsg printk

#endif
