/**
 * @file IxTypes.h
 *
 * @date 28-NOV-2001

 * @brief This file contains basic types used by the IXP425 software
 *
 * Design Notes:
 *    This file shall only include fundamental types and definitions to be
 *    shared by all the IXP425 components.
 *    Please DO NOT add component-specific types here.
 *
 * @version $Revision: 1.1.1.1 $
 * 
 * @par
 * -- Intel Copyright Notice --
 * 
 * @par
 * Copyright 2001-2003 Intel Corporation All Rights Reserved.
 * 
 * @par
 * The source code contained or described herein and all documents
 * related to the source code ("Material") are owned by Intel Corporation
 * or its suppliers or licensors.  Title to the Material remains with
 * Intel Corporation or its suppliers and licensors.
 * 
 * @par
 * The Material is protected by worldwide copyright and trade secret laws
 * and treaty provisions. No part of the Material may be used, copied,
 * reproduced, modified, published, uploaded, posted, transmitted,
 * distributed, or disclosed in any way except in accordance with the
 * applicable license agreement .
 * 
 * @par
 * No license under any patent, copyright, trade secret or other
 * intellectual property right is granted to or conferred upon you by
 * disclosure or delivery of the Materials, either expressly, by
 * implication, inducement, estoppel, except in accordance with the
 * applicable license agreement.
 * 
 * @par
 * Unless otherwise agreed by Intel in writing, you may not remove or
 * alter this notice or any other notice embedded in Materials by Intel
 * or Intel's suppliers or licensors in any way.
 * 
 * @par
 * For further details, please see the file README.TXT distributed with
 * this software.
 * 
 * @par
 * -- End Intel Copyright Notice --
 */

/**
 * @defgroup IxTypes IXP425 Types (IxTypes) 
 *
 * @brief Basic data types used by the IXP425 project
 *
 * @{
 */

#ifndef IxTypes_H

#ifndef __doxygen_HIDE

#define IxTypes_H

#endif /* __doxygen_HIDE */

#ifdef __vxworks

#include <vxWorks.h>

#endif

typedef void (*IxVoidFnPtr)(void);

typedef void (*IxVoidFnVoidPtr)(void *);

#ifndef __INCvxTypesOldh
typedef int (*FUNCPTR)(void);
typedef int STATUS;
typedef int BOOL;
typedef unsigned char  UCHAR;
typedef unsigned short USHORT;
typedef unsigned int   UINT;
typedef unsigned long  ULONG;
typedef char  INT8;
typedef short INT16;
typedef int   INT32;
typedef unsigned char  UINT8;
typedef unsigned short UINT16;
typedef unsigned int   UINT32;
typedef unsigned long long UINT64;
typedef void VOID;

#define OK (0)
#define ERROR (-1)

#ifndef NELEMENTS
#define NELEMENTS(x) (sizeof(x) / sizeof((x)[0]))
#endif

#endif /* __INCvxTypesOldh */

typedef volatile UINT32 VUINT32;

typedef volatile INT32 VINT32;

/* IXP425-specific types */

typedef UINT32 IX_STATUS;

/**
 * Standard return values
 */
#define IX_SUCCESS 0
#define IX_FAIL 1

/**
 * Definition of TRUE
 */
#ifndef TRUE
#define TRUE (1)
#endif

#if TRUE != 1
#error TRUE is not defined to 1
#endif

/**
 * Definition of FALSE 
 */
#ifndef FALSE
#define FALSE (0)
#endif

#if FALSE != 0 
#error FALSE is not defined to 0
#endif

/**
 * definition of NULL
 */
#ifndef NULL
#define NULL 0L
#endif /* NULL */

#ifndef PRIVATE
#ifdef IX_PRIVATE_OFF
#define PRIVATE /* nothing */
#else
#define PRIVATE static
#endif /* IX_PRIVATE_OFF */
#endif /* PRIVATE */

#ifndef PUBLIC
#define PUBLIC
#endif /* PUBLIC */

#endif /* IxTypes_H */

/**
 * @} addtogroup IxTypes
 */
