/** 
 * @file IxOsServicesEndianess.h
 * 
 * @brief Header file for determining system endianess and OS
 * 
 * @par
 * @version $Revision: 1.1.1.1 $
 * 
 * @par
 * -- Intel Copyright Notice --
 * 
 * @par
 * Copyright 1999-2003 Intel Corporation All Rights Reserved.
 * 
 * @par
 * The source code contained or described herein and all documents
 * related to the source code ("Material") are owned by Intel Corporation
 * or its suppliers or licensors.  Title to the Material remains with
 * Intel Corporation or its suppliers and licensors.
 * 
 * @par
 * The Material is protected by worldwide copyright and trade secret laws
 * and treaty provisions. No part of the Material may be used, copied,
 * reproduced, modified, published, uploaded, posted, transmitted,
 * distributed, or disclosed in any way except in accordance with the
 * applicable license agreement .
 * 
 * @par
 * No license under any patent, copyright, trade secret or other
 * intellectual property right is granted to or conferred upon you by
 * disclosure or delivery of the Materials, either expressly, by
 * implication, inducement, estoppel, except in accordance with the
 * applicable license agreement.
 * 
 * @par
 * Unless otherwise agreed by Intel in writing, you may not remove or
 * alter this notice or any other notice embedded in Materials by Intel
 * or Intel's suppliers or licensors in any way.
 * 
 * @par
 * For further details, please see the file README.TXT distributed with
 * this software.
 * 
 * @par
 * -- End Intel Copyright Notice --
 */
 
#ifndef IxOsServicesEndianess_H
#define IxOsServicesEndianess_H

#if defined (__vxworks) || defined (__linux)

/* get ntohl/ntohs/htohl/htons macros and CPU definitions for VxWorks */
#include <netinet/in.h>

#else

#error Unknown OS, please add a section with the include file for htonl/htons/ntohl/ntohs

#endif /* vxworks or linux */

/* Compiler specific endianness selector - WARNING this works only with arm gcc, use appropriate defines with diab */
#if defined (__ARMEL__)

#ifndef __LITTLE_ENDIAN

#define __LITTLE_ENDIAN

#endif

#elif defined (__ARMEB__) || CPU == SIMSPARCSOLARIS

#ifndef __BIG_ENDIAN

#define __BIG_ENDIAN

#endif

#else

#error Error, could not identify target endianness

#endif /* endianness selector */

/* OS mode selector */
#if defined (__vxworks) && defined (__LITTLE_ENDIAN)

#define IX_OSSERV_VXWORKS_LE

#elif defined (__vxworks) && defined (__BIG_ENDIAN)

#define IX_OSSERV_VXWORKS_BE

#elif defined (__linux) && defined (__BIG_ENDIAN)

#define IX_OSSERV_LINUX_BE

#else

#error Unknown OS/Endianess combination - only WxWorks LE, VxWorks BE and Linux BE are supported

#endif /* mode selector */

#ifdef __XSCALE__
static __inline__ UINT32 ixOsServWordSwap(UINT32 wordIn)
{
    /* Storage for the swapped word */
    UINT32 wordOut;

    /* wordIn = A, B, C, D */
    __asm__ (" eor r1, %1, %1, ror #16;"  /* R1 =      A^C, B^D, C^A, D^B */
	     " bic r1, r1, #0x00ff0000;"  /* R1 =      A^C, 0  , C^A, D^B */
	     " mov %0, %1, ror #8;"       /* wordOut = D,   A,   B,   C   */
	     " eor %0, %0, r1, lsr #8;"   /* wordOut = D,   C,   B,   A   */
	     : "=r" (wordOut) : "r" (wordIn) : "r1");

    return wordOut;
}
#endif


/* Low-level conversion macros - DO NOT USE UNLESS ABSOLUTELY NEEDED */
#ifdef __XSCALE__
#define IX_OSSERV_SWAP_LONG(wData)          (ixOsServWordSwap(wData))
#else
#define IX_OSSERV_SWAP_LONG(wData)          ((wData >> 24) | (((wData >> 16) & 0xFF) << 8) | (((wData >> 8) & 0xFF) << 16) | ((wData & 0xFF) << 24))
#endif
#define IX_OSSERV_SWAP_SHORT(sData)         ((sData >> 8) | ((sData & 0xFF) << 8))
#define IX_OSSERV_SWAP_SHORT_ADDRESS(sAddr) ((sAddr) ^ 0x2)
#define IX_OSSERV_SWAP_BYTE_ADDRESS(bAddr)  ((bAddr) ^ 0x3)

#define IX_OSSERV_BE_XSTOBUSL(wData)  (wData)
#define IX_OSSERV_BE_XSTOBUSS(sData)  (sData)
#define IX_OSSERV_BE_XSTOBUSB(bData)  (bData)
#define IX_OSSERV_BE_BUSTOXSL(wData)  (wData)
#define IX_OSSERV_BE_BUSTOXSS(sData)  (sData)
#define IX_OSSERV_BE_BUSTOXSB(bData)  (bData)

#define IX_OSSERV_LE_AC_XSTOBUSL(wAddr) (wAddr)
#define IX_OSSERV_LE_AC_XSTOBUSS(sAddr) IX_OSSERV_SWAP_SHORT_ADDRESS(sAddr)
#define IX_OSSERV_LE_AC_XSTOBUSB(bAddr) IX_OSSERV_SWAP_BYTE_ADDRESS(bAddr)
#define IX_OSSERV_LE_AC_BUSTOXSL(wAddr) (wAddr)
#define IX_OSSERV_LE_AC_BUSTOXSS(sAddr) IX_OSSERV_SWAP_SHORT_ADDRESS(sAddr)
#define IX_OSSERV_LE_AC_BUSTOXSB(bAddr) IX_OSSERV_SWAP_BYTE_ADDRESS(bAddr)

#define IX_OSSERV_LE_DC_XSTOBUSL(wData) IX_OSSERV_SWAP_LONG(wData)
#define IX_OSSERV_LE_DC_XSTOBUSS(sData) IX_OSSERV_SWAP_SHORT(sData)
#define IX_OSSERV_LE_DC_XSTOBUSB(bData) (bData)
#define IX_OSSERV_LE_DC_BUSTOXSL(wData) IX_OSSERV_SWAP_LONG(wData)
#define IX_OSSERV_LE_DC_BUSTOXSS(sData) IX_OSSERV_SWAP_SHORT(sData)
#define IX_OSSERV_LE_DC_BUSTOXSB(bData) (bData)

#endif /* IxOsServicesEndianess_H */
