/**
 * @file
 *
 * @brief This file includes the OS dependant MBUF header files.
 *
 * @version $Revision: 1.1.1.1 $
 * 
 * @par
 * -- Intel Copyright Notice --
 * 
 * @par
 * Copyright 2002-2003 Intel Corporation All Rights Reserved.
 * 
 * @par
 * The source code contained or described herein and all documents
 * related to the source code ("Material") are owned by Intel Corporation
 * or its suppliers or licensors.  Title to the Material remains with
 * Intel Corporation or its suppliers and licensors.
 * 
 * @par
 * The Material is protected by worldwide copyright and trade secret laws
 * and treaty provisions. No part of the Material may be used, copied,
 * reproduced, modified, published, uploaded, posted, transmitted,
 * distributed, or disclosed in any way except in accordance with the
 * applicable license agreement .
 * 
 * @par
 * No license under any patent, copyright, trade secret or other
 * intellectual property right is granted to or conferred upon you by
 * disclosure or delivery of the Materials, either expressly, by
 * implication, inducement, estoppel, except in accordance with the
 * applicable license agreement.
 * 
 * @par
 * Unless otherwise agreed by Intel in writing, you may not remove or
 * alter this notice or any other notice embedded in Materials by Intel
 * or Intel's suppliers or licensors in any way.
 * 
 * @par
 * For further details, please see the file README.TXT distributed with
 * this software.
 * 
 * @par
 * -- End Intel Copyright Notice --
 */

/**
 * @defgroup IxOsBuffMgt IXP425 OS Memory Buffer Management (IxOsBuffMgt) API
 *
 * @brief IXP425 OS Memory Buffer Management
 *
 * @{
 */

#ifndef IxOsBuffMgt_inc
#define IxOsBuffMgt_inc

#ifdef __vxworks

#include <vxWorks.h>
#include <net/mbuf.h>
#include <netBufLib.h>

#define m_net_pool m_pkthdr.rcvif

#define IX_MBUF M_BLK

#else 

#include <linux/skbuff.h>

typedef struct __IX_MBUF 
{  
  struct __IX_MBUF   *ix_next __attribute__ ((aligned(32)));  /* NPE offset 0  */
  struct __IX_MBUF   *ix_nextPacket;
  char             *ix_data;        /* NPE offset 8  */
  int               ix_len;         /* NPE offset 12 */
  unsigned char     ix_type;
  unsigned char     ix_flags;       /* NPE offset 17 */
  unsigned short    ix_reserved;
  
  struct 
  {
     unsigned int      ix_pool;
     unsigned int      len;   /* NPE offset 24 */
  } ix_pktHeader;
  
  void              *priv;     /* make a 32 bytes structure */
} IX_MBUF;

#define	m_next     ix_next
#define	m_len      ix_len
#define	m_data     ix_data
#define	m_type     ix_type
#define	m_flags	   ix_flags
#define	m_nextpkt  ix_nextPacket
#define m_act      ix_nextPacket
#define	m_pkthdr   ix_pktHeader 
#define m_net_pool ix_pktHeader.ix_pool

#define SIZEOF_IP_HEADER sizeof(struct iphdr)

/* This function sets the skb field in mbuf with the given skb pointer. 
 * If not NULL, mbuf data and length fields are set from the skb values.
 * This function returns the previous value of mbuf->skb.
 */
static inline struct sk_buff *mbuf_swap_skb(IX_MBUF *mbuf, struct sk_buff *skb)
{
    struct sk_buff *res = mbuf->priv;
    mbuf->priv = skb;

    if (!skb)
	return res;

    mbuf->m_data = skb->data;
    mbuf->ix_pktHeader.len = mbuf->m_len = skb->len;

    return res;
}

#endif /* __vxworks */

/* common definitions */

/**
 * @def IX_MBUF_MDATA(m_blk_ptr)
 *
 * @brief Return pointer to the data in the mbuf
 */
#define IX_MBUF_MDATA(m_blk_ptr)   		   (m_blk_ptr)->m_data

/**
 * @def IX_MBUF_MLEN(m_blk_ptr)
 *
 * @brief Return the data length
 */
#define IX_MBUF_MLEN(m_blk_ptr)   		   (m_blk_ptr)->m_len

/**
 * @def IX_MBUF_TYPE(m_blk_ptr)
 *
 * @brief Return the data type in the mbuf
 */
#define IX_MBUF_TYPE(m_blk_ptr)   		   (m_blk_ptr)->m_type

/**
 * @def IX_MBUF_NEXT_BUFFER_IN_PKT_PTR(m_blk_ptr)
 *
 * @brief Return pointer to the next mbuf in a single packet
 */
#define IX_MBUF_NEXT_BUFFER_IN_PKT_PTR(m_blk_ptr)  (m_blk_ptr)->m_next

/**
 * @def IX_MBUF_NEXT_PKT_IN_CHAIN_PTR(m_blk_ptr)
 *
 * @brief Return pointer to the next packet in the chain
 */
#define IX_MBUF_NEXT_PKT_IN_CHAIN_PTR(m_blk_ptr)   (m_blk_ptr)->m_nextpkt

/**
 * @def IX_MBUF_ALLOCATED_BUFF_LEN(m_blk_ptr)
 *
 * @brief Return the allocated buffer size
 */
#define IX_MBUF_ALLOCATED_BUFF_LEN(m_blk_ptr)      (m_blk_ptr)->m_len

/**
 * @def IX_MBUF_PKT_LEN(m_blk_ptr)
 *
 * @brief Return the total length of all the data in the mbuf chain for this packet
 */
#define IX_MBUF_PKT_LEN(m_blk_ptr)		   (m_blk_ptr)->m_pkthdr.len

/**
 * @def IX_MBUF_FLAGS(m_blk_ptr)
 *
 * @brief Return the buffer flags
 */
#define IX_MBUF_FLAGS(m_blk_ptr)   		   (m_blk_ptr)->m_flags

/**
 * @def IX_MBUF_NET_POOL(m_blk_ptr)
 *
 * @brief Return pointer to a network pool
 */
#if defined __vxworks
#define IX_MBUF_NET_POOL(m_blk_ptr)		   (m_blk_ptr)->pClBlk->pNetPool
#elif defined __linux
#define IX_MBUF_NET_POOL(m_blk_ptr)		   (m_blk_ptr)->m_net_pool
#endif

#endif /* ndef IxOsBuffMgt_inc */
