/*
 * File Version: $Revision: 1.1.1.1 $
 * 
 * -- Intel Copyright Notice --
 * 
 * Copyright 2003 Intel Corporation All Rights Reserved.
 * 
 * The source code contained or described herein and all documents
 * related to the source code ("Material") are owned by Intel Corporation
 * or its suppliers or licensors.  Title to the Material remains with
 * Intel Corporation or its suppliers and licensors.
 * 
 * The Material is protected by worldwide copyright and trade secret laws
 * and treaty provisions. No part of the Material may be used, copied,
 * reproduced, modified, published, uploaded, posted, transmitted,
 * distributed, or disclosed in any way except in accordance with the
 * applicable license agreement .
 * 
 * No license under any patent, copyright, trade secret or other
 * intellectual property right is granted to or conferred upon you by
 * disclosure or delivery of the Materials, either expressly, by
 * implication, inducement, estoppel, except in accordance with the
 * applicable license agreement.
 * 
 * Unless otherwise agreed by Intel in writing, you may not remove or
 * alter this notice or any other notice embedded in Materials by Intel
 * or Intel's suppliers or licensors in any way.
 * 
 * For further details, please see the file README.TXT distributed with
 * this software.
 * 
 * -- End Intel Copyright Notice --
*/
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>
#include <netdb.h>
#include <socket.h>
#include <unistd.h>
#include <in.h>
#include <sockLib.h>
#include <inetLib.h>

#define RRQ_OPCODE  (1)
#define DATA_OPCODE (3)
#define ACK_OPCODE  (4)
#define ERR_OPCODE  (5)

#define INITIAL_TFTP_PORT (69)

#define MAX_SIZE (516) /* 2 bytes opcode + 2 bytes block # + 512 bytes data */

#define PROGRESS_THRESHOLD (100 * 1024 / 512) /* 100 kb, i.e. 200 blocks */

int ixFlashTftpGet(char *server, char *file, unsigned char *tftpDestBuffer);

int ixFlashTftpGet(char *server, char *file, unsigned char *tftpDestBuffer)
{
  int sock;
  struct sockaddr_in myAddr, remoteAddr;
  int remoteAddrLength = sizeof (remoteAddr);
  unsigned long host;
  
  char buffer[MAX_SIZE];
    
  int packetLength;
  int sentLength;
  
  int offset   = 0;
  int progress = 0;
  
  int thisBlock;
  int blockNumber = 1; /* transfers start at block #1 */
  
  int opCode;
  
  int sendAck;
  
  host = inet_addr(server);
  
  if (host == 0)
  {
    printf("Fatal: could not get address for %s\n", server);
    
    return -1;
  }  

  /* set up remote address */
  remoteAddr.sin_family      = AF_INET;
  remoteAddr.sin_addr.s_addr = host;
  remoteAddr.sin_port        = htons(INITIAL_TFTP_PORT);
  
  /* set up our address */
  myAddr.sin_family      = AF_INET;
  myAddr.sin_addr.s_addr = htonl(INADDR_ANY);
  myAddr.sin_port        = htons(0); /* any */
  
  if ((sock = socket(AF_INET, SOCK_DGRAM, 0)) == -1)
  {
      printf("Fatal: internal error - could not create socket");

      return -1;
  }
  
  if (bind(sock, (struct sockaddr *) &myAddr, sizeof(myAddr)) == -1)
  {
      printf("Fatal: could not bind socket");

      close(sock);
      
      return -1;
  }  
        
  printf("Retrieving %s from %s\n", file, server);  
  
  /* build RRQ */
  * (unsigned short *) &buffer[0] = htons(RRQ_OPCODE);
  
  packetLength = 2;
  
  strcpy(&buffer[packetLength], file);
  
  packetLength += strlen(file) + 1;
  
  strcpy(&buffer[packetLength], "octet");
  
  packetLength += strlen("octet") + 1;
    
  /* send RRQ */
  sentLength = sendto(sock, buffer, packetLength, 0, (struct sockaddr *) &remoteAddr, remoteAddrLength);
  
  if (sentLength < 0)
  {
    printf("Fatal: error sending read request - return code %d\n", sentLength);
    
    close(sock);
    
    return -1;
  }
  
  /* start receiving data */
  do
  {
    packetLength = recvfrom(sock, buffer, MAX_SIZE, 0, (struct sockaddr *) &remoteAddr, &remoteAddrLength);
    
    /* check opcode */
    opCode = ntohs(* (unsigned short *) &buffer[0]);
    
    if (opCode == ERR_OPCODE)
    {
      printf("\nError: transfer failed with error 0x%04x, host replied [%s]\n", * (unsigned short *) &buffer[2], &buffer[4]);
      
      close(sock);
      
      return -1;
    }
    else if (opCode != DATA_OPCODE)
    {
      printf("\nError: transfer failed, unexpected opcode 0x%04x\n", opCode);
      
      close(sock);
      
      return -1;
    }

    /* get block number */
    thisBlock = ntohs(* (unsigned short *) &buffer[2]);
    
    sendAck = 0;
    
    if (thisBlock == blockNumber) /* received what we expected? */
    {
      /* advance block number */
      blockNumber++;
      
      /* progress indicator - one dot initially, then one per 100k */
      progress++;
      
      if (progress == PROGRESS_THRESHOLD || offset == 0)
      {
        printf(".");
        progress = 0;
      }
      
      /* save data */
      memcpy(&tftpDestBuffer[offset], &buffer[4], packetLength - 4);
      
      offset += packetLength - 4;

      /* send ack */
      sendAck = 1;
    }
    else if (thisBlock > blockNumber)
    {
      printf("\nError: data got lost beyond protocol retrying capability\n");
      
      close(sock);
      
      return -1;
    }
    else if (thisBlock < blockNumber)
    {
      /* ignore data but acknowledge anyway, hopefully this one will be received */
      sendAck = 1;
    }
    
    if (sendAck)
    {
      * (unsigned short *) &buffer[0] = htons(ACK_OPCODE);
      * (unsigned short *) &buffer[2] = htons(thisBlock);

      sentLength = sendto(sock, buffer, 4, 0, (struct sockaddr *) &remoteAddr, remoteAddrLength);

      if (sentLength < 0)
      {
        printf("\nFatal: error sending ack - return code %d\n", sentLength);
        
        close(sock);

        return -1;
      }
    }
  } while (packetLength == MAX_SIZE);

  /* receive complete */
  close(sock);
  
  printf("\nReceived %d bytes\n", offset);

  return offset;
}

