/**
 * @file IxEthAcc.c
 *
 * @author Intel Corporation
 * @date 20-Feb-2001
 *
 * @brief This file contains the implementation of the IXP425 Ethernet Access Component
 *
 * Design Notes:
 *
 * -- Intel Copyright Notice --
 * 
 * @par
 * Copyright 2001-2003 Intel Corporation All Rights Reserved.
 * 
 * @par
 * The source code contained or described herein and all documents
 * related to the source code ("Material") are owned by Intel Corporation
 * or its suppliers or licensors.  Title to the Material remains with
 * Intel Corporation or its suppliers and licensors.
 * 
 * @par
 * The Material is protected by worldwide copyright and trade secret laws
 * and treaty provisions. No part of the Material may be used, copied,
 * reproduced, modified, published, uploaded, posted, transmitted,
 * distributed, or disclosed in any way except in accordance with the
 * applicable license agreement .
 * 
 * @par
 * No license under any patent, copyright, trade secret or other
 * intellectual property right is granted to or conferred upon you by
 * disclosure or delivery of the Materials, either expressly, by
 * implication, inducement, estoppel, except in accordance with the
 * applicable license agreement.
 * 
 * @par
 * Unless otherwise agreed by Intel in writing, you may not remove or
 * alter this notice or any other notice embedded in Materials by Intel
 * or Intel's suppliers or licensors in any way.
 * 
 * @par
 * For further details, please see the file README.TXT distributed with
 * this software.
 * 
 * @par
 * -- End Intel Copyright Notice --
 */



#include <IxEthAcc.h>
#include <IxEthDB.h>
#include <IxFeatureCtrl.h>

#include "IxEthAcc_p.h"
#include "IxEthAccMac_p.h"
#include "IxEthAccMii_p.h"

/**
 * @addtogroup IxEthAcc
 *@{
 */


/**
 * @brief Per port information data strucure.
 *
 * @ingroup IxEthAccPri
 *
 */

ixEthAccPortDataInfo ixEthAccPortData[IX_ETH_ACC_NUMBER_OF_PORTS];



IxEthAccStatus ixEthAccInit()
{
  /*
   * Initialize Control plane
   */
  if (ixEthDBInit() != IX_ETH_ACC_SUCCESS)
  {
      return IX_ETH_ACC_FAIL;
  }

  /*
   * Initialize Data plane
   */
   if ( ixEthAccInitDataPlane()  != IX_ETH_ACC_SUCCESS )
   {
       return IX_ETH_ACC_FAIL;
   }


   if ( ixEthAccRegisterQMgrCallbacks() != IX_ETH_ACC_SUCCESS )
   {
       return IX_ETH_ACC_FAIL;
   }

   /*
    * Initialize MII 
    */
   if ( ixEthAccMiiInit() != IX_ETH_ACC_SUCCESS )
   {
       return IX_ETH_ACC_FAIL;
   }
   
   /*
    * Initialize MAC I/O memory
    */
   if (ixEthAccMacMemInit() != IX_ETH_ACC_SUCCESS)
   {
     return IX_ETH_ACC_FAIL;
   }
   
  /*
   * Set init flag.
   */

   ixEthAccServiceInit = TRUE;
   
   return IX_ETH_ACC_SUCCESS;

}

void ixEthAccUnload(void)
{
  ixEthAccMiiUnload();
  ixEthAccMacUnload();
}

IxEthAccStatus ixEthAccPortInit( IxEthAccPortId portId)
{

  IxEthAccStatus ret=IX_ETH_ACC_SUCCESS;

   if ( !  IX_ETH_ACC_IS_SERVICE_INITIALIZED() ) 
   {
   	return(IX_ETH_ACC_FAIL);
   }

   /*
    * Check for valid port
    */
    
   if ( ! IX_ETH_ACC_IS_PORT_VALID(portId) )
   {
       return (IX_ETH_ACC_INVALID_PORT);
   }   

   if (IX_ETH_ACC_SUCCESS != ixEthAccSingleEthNpeCheck(portId))
   {
       IX_ETH_ACC_WARNING_LOG("EthAcc: Unavailable Eth %d: Cannot initialize Eth port.\n",(INT32) portId,0,0,0,0,0);
       return IX_ETH_ACC_SUCCESS ;
   }   

   if ( IX_ETH_IS_PORT_INITIALIZED(portId) )
   {
   	/* Already initialized */
   	return(IX_ETH_ACC_FAIL);
   }

    /*
     * Clear port values - 0.
     */
    IX_ETH_ACC_MEMSET(&ixEthAccPortData[portId], 0, sizeof(ixEthAccPortDataInfo));


    /* 
     * Clear port callbacks.
     */

    ixEthAccPortData[portId].ixEthAccRxData.rxCallbackFn = 0;
    ixEthAccPortData[portId].ixEthAccRxData.rxCallbackTag = 0;
    ixEthAccPortData[portId].ixEthAccRxData.freeBufferList.pHead = NULL;
    ixEthAccPortData[portId].ixEthAccRxData.freeBufferList.pTail = NULL;

    ixEthAccPortData[portId].ixEthAccTxData.txBufferDoneCallbackFn = 0;
    ixEthAccPortData[portId].ixEthAccTxData.txCallbackTag = 0;
    ixEthAccPortData[portId].ixEthAccTxData.schDiscipline = FIFO_NO_PRIORITY;


    /*
     * Set the port init flag.
     */

    ixEthAccPortData[portId].portInitialized = TRUE;
    
    if(ixEthAccMacInit(portId)!=IX_ETH_ACC_SUCCESS)
    {
	return IX_ETH_ACC_FAIL;
    }

    /* init learning/filtering database structures for this port */
    ixEthDBPortInit(portId);

    return(ret);    
}


