/**
 * @file    IxTimersCodelet_p.h
 *
 * @date    11-June-2003
 *
 * @brief   Private header file for the IXP425 hardware timers
 *
 * @version $Revision: 1.1.1.1 $
 * 
 * @par
 * -- Intel Copyright Notice --
 * 
 * @par
 * Copyright 2002-2003 Intel Corporation All Rights Reserved.
 * 
 * @par
 * The source code contained or described herein and all documents
 * related to the source code ("Material") are owned by Intel Corporation
 * or its suppliers or licensors.  Title to the Material remains with
 * Intel Corporation or its suppliers and licensors.
 * 
 * @par
 * The Material is protected by worldwide copyright and trade secret laws
 * and treaty provisions. No part of the Material may be used, copied,
 * reproduced, modified, published, uploaded, posted, transmitted,
 * distributed, or disclosed in any way except in accordance with the
 * applicable license agreement .
 * 
 * @par
 * No license under any patent, copyright, trade secret or other
 * intellectual property right is granted to or conferred upon you by
 * disclosure or delivery of the Materials, either expressly, by
 * implication, inducement, estoppel, except in accordance with the
 * applicable license agreement.
 * 
 * @par
 * Unless otherwise agreed by Intel in writing, you may not remove or
 * alter this notice or any other notice embedded in Materials by Intel
 * or Intel's suppliers or licensors in any way.
 * 
 * @par
 * For further details, please see the file README.TXT distributed with
 * this software.
 * 
 * @par
 * -- End Intel Copyright Notice --
 *
 * 
 *
 */

/**
 * @defgroup Codelets IXP425 Codelets
 *
 * @brief IXP425 demo codelets
 *
 * @{
 */

/**
 * @ingroup Codelets
 *
 * @defgroup IxTimerAPI IXP425 Timers (IxTimersCodelet)
 *
 * @brief IXP425 Timer component Private header file
 *
 * These utilities provide support for the timer codelet component
 *
 * @{
 */

#ifndef __IXTIMERSCODELET_P_H__
#define __IXTIMERSCODELET_P_H__

#include "IxTimersCodelet.h"

/**
 *
 * @ingroup IxTimerAPI
 *
 * @fn ixTimerMemMap (void)
 *
 * @brief Maps the timer address space
 *
 * This function is called in order to map the physical address space
 * for the timer to virtual adress space
 *
 * @param none
 *
 * @return @li IX_SUCCESS, the timer physical address space was mapped to
 * virtual address space
 * @return @li IX_FAIL, the timer physical address space failed to be mapped
 * to virtual address space
 *
 */
PUBLIC IX_STATUS
ixTimerMemMap (void);

/**
 *
 * @ingroup IxTimerAPI
 *
 * @fn ixTimerMemUnmap (void)
 *
 * @brief Unmaps the timer address space
 *
 * This function is called in order to unmap the physical address space
 * for the timer
 *
 * @param none
 *
 * @return none
 *
 */
PUBLIC void
ixTimerMemUnmap (void);

#endif 
/* __IXTIMERSCODELET_P_H__ */
