/**
 * file IxHssAccCodeletMbuf.h
 *
 * date 29 May 2002
 *
 * brief This file contains the interface for mbuf pool implementation
 * of the HSS Access Codelet.
 *
 * File Version: $Revision: 1.1.1.1 $
 * 
 * -- Intel Copyright Notice --
 * 
 * Copyright 2002-2003 Intel Corporation All Rights Reserved.
 * 
 * The source code contained or described herein and all documents
 * related to the source code ("Material") are owned by Intel Corporation
 * or its suppliers or licensors.  Title to the Material remains with
 * Intel Corporation or its suppliers and licensors.
 * 
 * The Material is protected by worldwide copyright and trade secret laws
 * and treaty provisions. No part of the Material may be used, copied,
 * reproduced, modified, published, uploaded, posted, transmitted,
 * distributed, or disclosed in any way except in accordance with the
 * applicable license agreement .
 * 
 * No license under any patent, copyright, trade secret or other
 * intellectual property right is granted to or conferred upon you by
 * disclosure or delivery of the Materials, either expressly, by
 * implication, inducement, estoppel, except in accordance with the
 * applicable license agreement.
 * 
 * Unless otherwise agreed by Intel in writing, you may not remove or
 * alter this notice or any other notice embedded in Materials by Intel
 * or Intel's suppliers or licensors in any way.
 * 
 * For further details, please see the file README.TXT distributed with
 * this software.
 * 
 * -- End Intel Copyright Notice --
 *
 * sa IxHssAccCodelet.h
 */

/**
 * ingroup IxHssAccCodelet
 *
 * defgroup IsHssAccCodeletMbuf IXP425 HSS Access Codelet MBuf Pool (IsHssAccCodeletMbuf) API
 *
 * brief The interface for mbuf pool implementation of the HSS Access Codelet.
 *
 * {
*/

#ifndef IXHSSACCCODELETMBUF_H
#define IXHSSACCCODELETMBUF_H

#include "IxOsBuffMgt.h"
#include "IxOsBuffPoolMgt.h"

/*
 * #defines for function return types, etc.
 */

/** preferred netBufLib cluster size is 2K */
#define MBUF_SIZE 2048

/*
 * Put the user defined include files required.
 */

/*
 * Typedefs
 */

/**
 * typedef IxHssAccCodeletMbufPool
 * brief   Pool Id type used to reference a particular mbuf pool
 */

typedef IX_MBUF_POOL IxHssAccCodeletMbufPool;

/*
 * Prototypes for interface functions.
 */

/**
 * fn IX_MBUF * ixHssAccCodeletMbufGet (
           IxHssAccCodeletMbufPool *poolId,
           unsigned mbufSize)
 *
 * param IxHssAccCodeletMbufPool *poolId (in) - pointer to the pool
 *                                               to get the mbuf from.
 *
 * This routine gets an mbuf from the specified mbuf memory pool
 * 
 * return
 *      - A pointer to the mbuf, or NULL if no mbuf was got from the pool
 */

IX_MBUF *
ixHssAccCodeletMbufGet (
    IxHssAccCodeletMbufPool *poolId);


/**
 * fn void ixHssAccCodeletMbufChainFree (
           IX_MBUF *pMbuf)
 *
 * param IX_MBUF *pMbuf (in) - A pointer to the first mbuf in
                               the mbuf chain to be freed
 *
 * This frees a chain of mbufs back to its memory pool
 * 
 * return
 *      - None
 */

void
ixHssAccCodeletMbufChainFree (
    IX_MBUF *pMbuf);


/**
 * fn void ixHssAccCodeletMbufPoolInit (
           IxHssAccCodeletMbufPool **poolIdPtr,
           unsigned numPoolMbufs,
           unsigned poolMbufSize)
 *
 * param IxHssAccCodeletMbufPool **poolIdPtr (out) - A pointer to the mbuf
 * pool pointer created
 * param unsigned numPoolMbufs (in) - The number of mbufs the pool should
 * contain
 * param unsigned poolMbufSize (in) - The size, in bytes, of the mbufs in
 * the pool
 *
 * This creates a memory pool of mbufs.  Use ixHssAccCodeletMbufGet() to
 * get an mbuf from the pool, and ixHssAccCodeletMbufFree() or
 * ixHssAccCodeletMbufChainFree() to return mbufs to the pool
 * 
 * return
 *      - None
 */

void
ixHssAccCodeletMbufPoolInit (
    IxHssAccCodeletMbufPool **poolIdPtr,
    unsigned numPoolMbufs,
    unsigned poolMbufSize);


#endif /* #ifndef IXHSSACCCODELETMBUF_H */

/**} defgroup IxHssAccCodeletMbuf*/

/**} defgroup Codelets*/

