/**
 * @file IxHssAccCodeletMbuf.c
 *
 * @date 29 May 2002
 *
 * @brief This file contains the mbuf pool implementation of the HSS Access
 * Codelet.
 *
 * @version $Revision: 1.1.1.1 $
 * 
 * @par
 * -- Intel Copyright Notice --
 * 
 * @par
 * Copyright 2002-2003 Intel Corporation All Rights Reserved.
 * 
 * @par
 * The source code contained or described herein and all documents
 * related to the source code ("Material") are owned by Intel Corporation
 * or its suppliers or licensors.  Title to the Material remains with
 * Intel Corporation or its suppliers and licensors.
 * 
 * @par
 * The Material is protected by worldwide copyright and trade secret laws
 * and treaty provisions. No part of the Material may be used, copied,
 * reproduced, modified, published, uploaded, posted, transmitted,
 * distributed, or disclosed in any way except in accordance with the
 * applicable license agreement .
 * 
 * @par
 * No license under any patent, copyright, trade secret or other
 * intellectual property right is granted to or conferred upon you by
 * disclosure or delivery of the Materials, either expressly, by
 * implication, inducement, estoppel, except in accordance with the
 * applicable license agreement.
 * 
 * @par
 * Unless otherwise agreed by Intel in writing, you may not remove or
 * alter this notice or any other notice embedded in Materials by Intel
 * or Intel's suppliers or licensors in any way.
 * 
 * @par
 * For further details, please see the file README.TXT distributed with
 * this software.
 * 
 * @par
 * -- End Intel Copyright Notice --
 *
 * @sa IxHssAccCodelet.h
 * @sa IxHssAccCodeletMbuf.h
 */

/*
 * Put the system defined include files required.
 */

/*
 * Put the user defined include files required.
 */

#include "IxAssert.h"
#include "IxOsBuffMgt.h"
#include "IxOsBuffPoolMgt.h"
#include "IxHssAccCodeletMbuf.h"


/*
 * Function definition: ixHssAccCodeletMbufGet
 */

IX_MBUF *
ixHssAccCodeletMbufGet (
    IxHssAccCodeletMbufPool *poolId)
{
    IX_MBUF *newMbuf;
    IX_STATUS status;

    status = IX_MBUF_POOL_GET(poolId, &newMbuf);

    IX_ENSURE ((status == IX_SUCCESS),
	       "ixHssAccCodeletMbufGet - cannot get a new buffer from pool\n");

    return newMbuf;
}


/*
 * Function definition: ixHssAccCodeletMbufChainFree
 */

void
ixHssAccCodeletMbufChainFree (
    IX_MBUF *pMbuf)
{
    IX_MBUF_POOL_PUT_CHAIN(pMbuf);
}


/*
 * Function definition: ixHssAccCodeletMbufPoolInit
 */

void
ixHssAccCodeletMbufPoolInit (
    IxHssAccCodeletMbufPool **poolIdPtr,
    unsigned numPoolMbufs,
    unsigned poolMbufSize)
{
    IX_STATUS status;

    status = IX_MBUF_POOL_INIT(poolIdPtr, numPoolMbufs, poolMbufSize,
			       "HssAcc Codelet Pool");

    IX_ASSERT (status == IX_SUCCESS);
}
