/**
 * @file IxHssAccCodelet.c
 *
 * @date 26 Mar 2002
 *
 * @brief This file contains the main routine for the HSS Access Codelet.
 *
 * @version $Revision: 1.1.1.1 $
 * 
 * @par
 * -- Intel Copyright Notice --
 * 
 * @par
 * Copyright 2002-2003 Intel Corporation All Rights Reserved.
 * 
 * @par
 * The source code contained or described herein and all documents
 * related to the source code ("Material") are owned by Intel Corporation
 * or its suppliers or licensors.  Title to the Material remains with
 * Intel Corporation or its suppliers and licensors.
 * 
 * @par
 * The Material is protected by worldwide copyright and trade secret laws
 * and treaty provisions. No part of the Material may be used, copied,
 * reproduced, modified, published, uploaded, posted, transmitted,
 * distributed, or disclosed in any way except in accordance with the
 * applicable license agreement .
 * 
 * @par
 * No license under any patent, copyright, trade secret or other
 * intellectual property right is granted to or conferred upon you by
 * disclosure or delivery of the Materials, either expressly, by
 * implication, inducement, estoppel, except in accordance with the
 * applicable license agreement.
 * 
 * @par
 * Unless otherwise agreed by Intel in writing, you may not remove or
 * alter this notice or any other notice embedded in Materials by Intel
 * or Intel's suppliers or licensors in any way.
 * 
 * @par
 * For further details, please see the file README.TXT distributed with
 * this software.
 * 
 * @par
 * -- End Intel Copyright Notice --
 *
 * @sa IxHssAccCodelet.h
 */

/*
 * Put the system defined include files required.
 */

#include <ioLib.h>
#include <logLib.h>
#include <stdio.h>

#ifdef __vxworks
#include <end.h>    /* END drivers */
#include <endLib.h> /* END drivers */
#endif

/*
 * Put the user defined include files required.
 */
#include "ixp425.h"
#include "IxHssAcc.h"
#include "IxNpeDl.h"
#include "IxNpeMh.h"
#include "IxOsServices.h"
#include "IxQMgr.h"
#include "ix_ossl.h"
#include "IxTypes.h"

#include "IxHssAccCodelet.h"

/*
 * #defines and macros used in this file.
 */

/**
 * NPE-A Image 
 */

#define IX_HSSACC_CODELET_NPEA_IMAGE_ID IX_NPEDL_NPEIMAGE_NPEA_HSS_2_PORT

/*
 * Typedefs whose scope is limited to this file.
 */

/*
 * Variable declarations global to this file only.  Externs are followed by
 * static variables.
 */

/* Service Flag */
extern BOOL packetisedFlag ;
extern BOOL channelisedFlag ;

/*
 * Function prototypes.
 */
IX_STATUS
ixHssAccCodeletServiceMain (IxHssAccCodeletPortMode portMode);

/*
 * Function definition: ixHssAccCodeletMain
 */
PUBLIC IX_STATUS
ixHssAccCodeletMain (IxHssAccCodeletOperation operationType,
                     IxHssAccCodeletPortMode portMode,
                     IxHssAccCodeletVerifyMode verifyMode)
{
    /* Setup codelet services */
    switch (operationType)
    {
      case IX_HSSACC_CODELET_PKT_CHAN_SERV :
           packetisedFlag = TRUE ;
           channelisedFlag = TRUE ;
           break ;

      case IX_HSSACC_CODELET_PKT_SERV_ONLY :     
           packetisedFlag = TRUE ;
           break ;

      case IX_HSSACC_CODELET_CHAN_SERV_ONLY :
           channelisedFlag = TRUE ;
           break ;

      default:
	printf ("Invalid operationType option! \n");
        printf ("Please choose one of the following options: \n"); 
        printf ("%u : Packetised Service Only.\n", IX_HSSACC_CODELET_PKT_SERV_ONLY);
        printf ("%u : Channelised Service Only. \n", IX_HSSACC_CODELET_CHAN_SERV_ONLY); 
        printf ("%u : Packetised & Channelised Services.\n", IX_HSSACC_CODELET_PKT_CHAN_SERV);
        return IX_FAIL;
    }

    /* Check HSS Port Mode */
    if ((IX_HSSACC_CODELET_HSS_PORT_0_ONLY > portMode) &&
        (IX_HSSACC_CODELET_DUAL_PORTS < portMode))
    {
	printf ("Invalid portMode option! \n");
        printf ("Please choose one of the following options: \n"); 
        printf ("%u : HSS Port 0 Only.\n", IX_HSSACC_CODELET_HSS_PORT_0_ONLY);
        printf ("%u : HSS Port 1 Only.\n", IX_HSSACC_CODELET_HSS_PORT_1_ONLY);
        printf ("%u : Both HSS Port 0 and 1. \n", IX_HSSACC_CODELET_DUAL_PORTS); 
        return IX_FAIL;
    }

    /* Check Verify Mode */
    if ((IX_HSSACC_CODELET_VERIFY_ON != verifyMode) &&
        (IX_HSSACC_CODELET_VERIFY_OFF != verifyMode))
    { 
 	printf ("Invalid verifyMode option! \n");
        printf ("Please choose one of the following options: \n"); 
        printf ("%u : Codelet verifies received traffic.\n", IX_HSSACC_CODELET_VERIFY_ON);
        printf ("%u : Codelet does not verify received traffic.\n", IX_HSSACC_CODELET_VERIFY_OFF);
        return IX_FAIL;     
    }
    else 
    {
        /*
         * Enable verification in both packatised and channelised services. 
         */
        ixHssAccCodeletPacketisedVerifySet ((verifyMode == IX_HSSACC_CODELET_VERIFY_ON ? TRUE : FALSE));
        ixHssAccCodeletChannelisedVerifySet((verifyMode == IX_HSSACC_CODELET_VERIFY_ON ? TRUE : FALSE));
    }
   
    /* The codelet only supports PHY Loopback. Disable codelet loopback  */
    ixHssAccCodeletHssLoopbackSet (TRUE);
    ixHssAccCodeletCodeletLoopbackSet (FALSE);
 
    /* Initialize npeDl, npeMh, QMgr and hssAcc */
    if (IX_SUCCESS != ixHssAccCodeletInit())
    {
        printf("ixHssAccCodeletInit() fails ! Exit \n") ;
        return IX_FAIL;
    }

    /* Start HSS Services */
    ixHssAccCodeletServiceStart(portMode);

    return IX_SUCCESS ;
}

/*
 * Function definition: ixHssAccCodeletServiceMain
 */
IX_STATUS
ixHssAccCodeletServiceMain (IxHssAccCodeletPortMode portMode)
{
    IxHssAccHdlcPort hdlcPortId;
    UINT32 i;
 
    /**********************/
    /* CONFIGURE HSS PORT */
    /**********************/

    if ((IX_HSSACC_CODELET_HSS_PORT_0_ONLY == portMode) ||
        (IX_HSSACC_CODELET_DUAL_PORTS == portMode))
    {
        ixHssAccCodeletConfigure (IX_HSSACC_HSS_PORT_0);
    }

    if ((IX_HSSACC_CODELET_HSS_PORT_1_ONLY == portMode) ||
        (IX_HSSACC_CODELET_DUAL_PORTS == portMode))
    {
        ixHssAccCodeletConfigure (IX_HSSACC_HSS_PORT_1);
    }

    /******************/
    /* START SERVICES */
    /******************/

    if (TRUE == packetisedFlag)
    {

        if ((IX_HSSACC_CODELET_HSS_PORT_0_ONLY == portMode) ||
            (IX_HSSACC_CODELET_DUAL_PORTS == portMode))
        {
            /* start the Packetised Service for all clients */
            for (hdlcPortId = 0; hdlcPortId < IX_HSSACC_HDLC_PORT_MAX;
                 hdlcPortId++)
            {
                ixHssAccCodeletPacketisedServiceStart (IX_HSSACC_HSS_PORT_0, hdlcPortId);
            }
	}

        if ((IX_HSSACC_CODELET_HSS_PORT_1_ONLY == portMode) ||
            (IX_HSSACC_CODELET_DUAL_PORTS == portMode))
        {
            /* start the Packetised Service for all clients */
            for (hdlcPortId = 0; hdlcPortId < IX_HSSACC_HDLC_PORT_MAX;
                 hdlcPortId++)
            {
                ixHssAccCodeletPacketisedServiceStart (IX_HSSACC_HSS_PORT_1, hdlcPortId);
            }
	}
    }

    if (TRUE == channelisedFlag)
    { 
        if ((IX_HSSACC_CODELET_HSS_PORT_0_ONLY == portMode) ||
            (IX_HSSACC_CODELET_DUAL_PORTS == portMode))
        {
            /* start the Channelised Service for the single client */
            ixHssAccCodeletChannelisedServiceConfigure (IX_HSSACC_HSS_PORT_0);
	}

        if ((IX_HSSACC_CODELET_HSS_PORT_1_ONLY == portMode) ||
            (IX_HSSACC_CODELET_DUAL_PORTS == portMode))
        {
            /* start the Channelised Service for the single client */
            ixHssAccCodeletChannelisedServiceConfigure (IX_HSSACC_HSS_PORT_1);
	}

        if ((IX_HSSACC_CODELET_HSS_PORT_0_ONLY == portMode) ||
            (IX_HSSACC_CODELET_DUAL_PORTS == portMode))
        {
            /* start the Channelised Service for the single client */
            ixHssAccCodeletChannelisedServiceStart (IX_HSSACC_HSS_PORT_0);
	}

        if ((IX_HSSACC_CODELET_HSS_PORT_1_ONLY == portMode) ||
            (IX_HSSACC_CODELET_DUAL_PORTS == portMode))
        {
            /* start the Channelised Service for the single client */
            ixHssAccCodeletChannelisedServiceStart (IX_HSSACC_HSS_PORT_1);
	}
    }
 
    /*********************/
    /* EXERCISE SERVICES */
    /*********************/

    for (i = 0; i < (IX_HSSACC_CODELET_DURATION_IN_MS/200); i++)
    {
        if (TRUE == packetisedFlag)
        {
            if ((IX_HSSACC_CODELET_HSS_PORT_0_ONLY == portMode) ||
                (IX_HSSACC_CODELET_DUAL_PORTS == portMode))
            {
                /* let each packetised client exercise the Packetised Service */
                for (hdlcPortId = 0; hdlcPortId < IX_HSSACC_HDLC_PORT_MAX;
                     hdlcPortId++)
                {
                    ixHssAccCodeletPacketisedServiceRun (IX_HSSACC_HSS_PORT_0, hdlcPortId);
                }
	    }

            if ((IX_HSSACC_CODELET_HSS_PORT_1_ONLY == portMode) ||
                (IX_HSSACC_CODELET_DUAL_PORTS == portMode))
            {
                /* let each packetised client exercise the Packetised Service */
                for (hdlcPortId = 0; hdlcPortId < IX_HSSACC_HDLC_PORT_MAX;
                     hdlcPortId++)
                {
                    ixHssAccCodeletPacketisedServiceRun (IX_HSSACC_HSS_PORT_1, hdlcPortId);
                }
	    }
        }

        if (TRUE == channelisedFlag)
        {
            if ((IX_HSSACC_CODELET_HSS_PORT_0_ONLY == portMode) ||
                (IX_HSSACC_CODELET_DUAL_PORTS == portMode))
            {
                /* let the channelised client exercise the Channelised Service */
                ixHssAccCodeletChannelisedServiceRun (IX_HSSACC_HSS_PORT_0);
	    }

            if ((IX_HSSACC_CODELET_HSS_PORT_1_ONLY == portMode) ||
                (IX_HSSACC_CODELET_DUAL_PORTS == portMode))
            {
                /* let the channelised client exercise the Channelised Service */
                ixHssAccCodeletChannelisedServiceRun (IX_HSSACC_HSS_PORT_1);
	    }
        }

        /* sleep for 200ms */
        ixOsServTaskSleep (200);
    } /* for (i ... */

    /*****************/
    /* STOP SERVICES */
    /*****************/

    if (TRUE == packetisedFlag)
    {
        if ((IX_HSSACC_CODELET_HSS_PORT_0_ONLY == portMode) ||
            (IX_HSSACC_CODELET_DUAL_PORTS == portMode))
        {
            /* stop the Packetised Service for all clients */
            for (hdlcPortId = 0; hdlcPortId < IX_HSSACC_HDLC_PORT_MAX;
                 hdlcPortId++)
            {
                ixHssAccCodeletPacketisedServiceStop (IX_HSSACC_HSS_PORT_0, hdlcPortId);
            }
	}

        if ((IX_HSSACC_CODELET_HSS_PORT_1_ONLY == portMode) ||
            (IX_HSSACC_CODELET_DUAL_PORTS == portMode))
        {
            /* stop the Packetised Service for all clients */
            for (hdlcPortId = 0; hdlcPortId < IX_HSSACC_HDLC_PORT_MAX;
                 hdlcPortId++)
            {
                ixHssAccCodeletPacketisedServiceStop (IX_HSSACC_HSS_PORT_1, hdlcPortId);
            }
	}
    }

    if (TRUE == channelisedFlag)
    {
        if ((IX_HSSACC_CODELET_HSS_PORT_0_ONLY == portMode) ||
            (IX_HSSACC_CODELET_DUAL_PORTS == portMode))
        { 
            /* stop the Channelised Service for the single client */
            ixHssAccCodeletChannelisedServiceStop (IX_HSSACC_HSS_PORT_0);
	}

        if ((IX_HSSACC_CODELET_HSS_PORT_1_ONLY == portMode) ||
            (IX_HSSACC_CODELET_DUAL_PORTS == portMode))
        { 
            /* stop the Channelised Service for the single client */
            ixHssAccCodeletChannelisedServiceStop (IX_HSSACC_HSS_PORT_1);
	}
    } 

    if ((IX_HSSACC_CODELET_HSS_PORT_0_ONLY == portMode) ||
        (IX_HSSACC_CODELET_DUAL_PORTS == portMode)) 
    { 
        ixHssAccCodeletShow(IX_HSSACC_HSS_PORT_0);
    }

    if ((IX_HSSACC_CODELET_HSS_PORT_1_ONLY == portMode) ||
        (IX_HSSACC_CODELET_DUAL_PORTS == portMode)) 
    { 
        ixHssAccCodeletShow(IX_HSSACC_HSS_PORT_1);
    }

    return IX_SUCCESS;
}

/*
 * Function definition: ixHssAccCodeletServiceStart
 */
void
ixHssAccCodeletServiceStart (IxHssAccCodeletPortMode portMode)
{
    /* Display the settings of the codelet */
    printf ("HSS Acc Codelet tries to start with following settings : \n");
    if (IX_HSSACC_CODELET_DUAL_PORTS == portMode)
    {
      printf ("\t>HSS Port 0 and HSS Port 1.\n");
    }
    else
    {
      printf ("\t>HSS Port %d Only.\n", (portMode==IX_HSSACC_CODELET_HSS_PORT_0_ONLY ? 0: 1));
    }
    printf("\t>Packetised Service. [%s]\n",( TRUE == packetisedFlag ? "On" : "Off"));
    printf("\t>Channelised Service.[%s]\n",( TRUE == channelisedFlag ? "On" : "Off"));

    printf ("HSS Acc Codelet is being started and executed. \n");
    printf ("Codelet will run for %u ms\n\n", IX_HSSACC_CODELET_DURATION_IN_MS); 
  
    ixHssAccCodeletServiceMain(portMode);
}

/*
 * Function definition: ixHssAccCodeletInit
 */
IX_STATUS
ixHssAccCodeletInit (void)
{
    IxQMgrDispatcherFuncPtr dispatcherFunc ; 

    printf ("Setting the debug level & redirecting output\n");

    /* set the debug level */
    logInit (ioTaskStdGet (0,1), 1);
    logFdSet (ioTaskStdGet (0,1));
    ixOsServLogLevelSet (LOG_ERROR); /* LOG_ALL, LOG_MESSAGE, ... */

#ifdef __vxworks
    /* When the ixe drivers are running, the codelets
    * cannot run.
    */
    if (endFindByName ("ixe", 0) != NULL)
    {
      printf("FAIL : Driver ixe0 detected\n");
      return IX_FAIL;
    }
    if (endFindByName ("ixe", 1) != NULL)
    {
      printf("FAIL : Driver ixe1 detected\n");
      return IX_FAIL;
    }
#endif

    /*Initialize and Start NPE-A */
    printf ("Initializing and starting NPE-A ...");
    if (IX_SUCCESS != ixNpeDlNpeInitAndStart (IX_HSSACC_CODELET_NPEA_IMAGE_ID))
    {
	printf ("Error initialising and starting NPE A!\n");
	return (IX_FAIL);
    }
    printf (" successful.\n");

    /* initialise the IxNpeMh component */
    printf ("Initializing NpeMh Component ...");
    if (IX_SUCCESS != ixNpeMhInitialize (IX_NPEMH_NPEINTERRUPTS_YES))
    {
        printf ("ixNpeMhInitialize failed\n");
        return (IX_FAIL);
    }
    printf (" successful.\n");

    /* initialise the QMgr component */
    printf ("Initializing QMgr Component ...");
    if (IX_SUCCESS != ixQMgrInit())
    {
        printf ("ixQMgrInit failed\n");
        return (IX_FAIL);
    }
    printf (" successful.\n");    

    printf ("Bind Queue Dispatcher to interrupt vector ...");
    ixQMgrDispatcherLoopGet(&dispatcherFunc);

    /* Hook the QM QUELOW dispatcher to interrupt */
    if (IX_SUCCESS != ixOsServIntBind(IXP425_INT_LVL_QM1, /* vector */
                                      (IxVoidFnVoidPtr)dispatcherFunc, /* routine */
                                      (void *) IX_QMGR_QUELOW_GROUP)) /* parameter */
    {
        printf ("ixOsServIntBind failed to bind to QM1 interrupt\n");
        return (IX_FAIL);
    }
    printf (" successful.\n");

    /* initialise the HssAcc component */
    printf("Intializing HssAcc Component ...");
    if (IX_SUCCESS != ixHssAccInit())
    {
        printf ("ixHssAccInit failed\n");
        return IX_FAIL;
    }
    printf (" successful.\n");

    return IX_SUCCESS;
}




