/*
 * FileName:    IxAtmUtilsUtopia.c
 * Author: Intel Corporation
 * Created:     15 May 2002
 * Description: Codelet utils.
 *
 *
 * Design Notes:
 *
 *
 * File Version: $Revision: 1.1.1.1 $
 * 
 * -- Intel Copyright Notice --
 * 
 * Copyright 2002-2003 Intel Corporation All Rights Reserved.
 * 
 * The source code contained or described herein and all documents
 * related to the source code ("Material") are owned by Intel Corporation
 * or its suppliers or licensors.  Title to the Material remains with
 * Intel Corporation or its suppliers and licensors.
 * 
 * The Material is protected by worldwide copyright and trade secret laws
 * and treaty provisions. No part of the Material may be used, copied,
 * reproduced, modified, published, uploaded, posted, transmitted,
 * distributed, or disclosed in any way except in accordance with the
 * applicable license agreement .
 * 
 * No license under any patent, copyright, trade secret or other
 * intellectual property right is granted to or conferred upon you by
 * disclosure or delivery of the Materials, either expressly, by
 * implication, inducement, estoppel, except in accordance with the
 * applicable license agreement.
 * 
 * Unless otherwise agreed by Intel in writing, you may not remove or
 * alter this notice or any other notice embedded in Materials by Intel
 * or Intel's suppliers or licensors in any way.
 * 
 * For further details, please see the file README.TXT distributed with
 * this software.
 * 
 * -- End Intel Copyright Notice --
 */

/*
 * System defined include files
 */
#include <string.h>

/*
 * User defined include files
 */
#include "IxTypes.h"
#include "IxOsServices.h"
#include "IxAssert.h"
#include "ixp425.h"
#include "IxOsServicesMemMap.h"
#include "IxAtmCodelet_p.h"

#define BSR_CTRL1 0x2

#define EXPBUS_REGS_LOCATION    IX_OSSERV_EXP_BUS_REGS_PHYS_BASE 

/* EXPBus location in memory map */
#define EXP_MEMMAP_BOOTMODE     IX_OSSERV_EXP_BUS_BOOT_PHYS_BASE 
#define EXP_MEMMAP_NORMALMODE   IX_OSSERV_EXP_BUS_PHYS_BASE

/* EXPBus register address definitions */
#define EXP_TIMING_CS5  (EXPBUS_REGS_LOCATION + 0x14)

#define EXPBUS_STIMULUS_CS      5       /* CS line index*/
#define EXP_TIMING_CS_STIMULUS  EXP_TIMING_CS5    /* CS cfg register address dedicated to stimulus */

#define EXP_CNFG0       (EXPBUS_REGS_LOCATION + 0x20)
#define EXP_CNFG1       (EXPBUS_REGS_LOCATION + 0x24)
#define EXP_CNFG2       (EXPBUS_REGS_LOCATION + 0x28)

/* EXPBus EXP_TIMING_CSx bit definitions */
#define EXP_TIMING_CS_EN_MASK   0x80000000  /* Bit 31 - Chip select enabled when set to 1 */
#define EXP_TIMING_CS_T1_MASK   0x30000000  /* Bit 29:28 - T1 Address timing (0 - normal timing) */
#define EXP_TIMING_CS_T2_MASK   0x0C000000  /* Bit 27:26 - T2 setup phase timing (0 - timing) */
#define EXP_TIMING_CS_T3_MASK   0x03C00000  /* Bit 25:22 - T3 strobe phase timing (0 - normal timing) */
#define EXP_TIMING_CS_T4_MASK   0x00300000  /* Bit 21:20 - T4 hold phase timing (0 - normal timing) */
#define EXP_TIMING_CS_T5_MASK   0x000F0000  /* Bit 19:16 - T5 recovery phase timing (0 - normal timing) */
#define EXP_TIMING_CS_CNFG_MASK 0x00003C00  /* Bit 13:10 - device mem size = 2^(9+CNFG) : 0 - 2^9 = 512 bytes */
#define EXP_TIMING_CS_WR_MASK   0x00000002  /* Bit 1 - WR_EN - enables writes when set to 1 */

/* configuration used by stimulus */
#define EXP_TIMING_CFG_STIMULUS  ( EXP_TIMING_CS_EN_MASK | EXP_TIMING_CS_T1_MASK |EXP_TIMING_CS_T2_MASK | EXP_TIMING_CS_T3_MASK | EXP_TIMING_CS_T4_MASK | EXP_TIMING_CS_T5_MASK | EXP_TIMING_CS_CNFG_MASK | EXP_TIMING_CS_WR_MASK )

/* EXPBus EXP_CNFG0 bit definitions */
#define EXP_CNFG0_MEMMAP_MASK   0x80000000  /* Location of EXPBus in memory space: 1 - 0x0, 0 - 0x50000000 */

/* function prototype */
PRIVATE void    
writeStimulusReg(unsigned uRegOffset, UINT16 uregValue);

PRIVATE UINT16  
readStimulusReg(unsigned uRegOffset);

PRIVATE void 
registerWrite(volatile unsigned *reg, unsigned value);

PRIVATE void 
fpgaStimulusEnable(void);

/****************************************************************************/

/* Write to stimulus register. uRegOffset is an offset from start of EXPBus mem. Function properly 
   recognizes current EXPBus mapping */
PRIVATE void    
writeStimulusReg(unsigned uRegOffset, UINT16 uregValue)
{
    UINT32  uCurrentEXPBusLocation;
        
    /* Figure out where EXPBus address space is mapped (from AHB point if view) */
    if( *( (UINT32*) (EXP_CNFG0) ) & EXP_CNFG0_MEMMAP_MASK) 
        uCurrentEXPBusLocation = EXP_MEMMAP_BOOTMODE;
    else
        uCurrentEXPBusLocation = EXP_MEMMAP_NORMALMODE;
        
    /* Write value to EXPBus register (CS, on which stimuls resides is coded into bit 26:24) */
    *( (UINT16*) (uCurrentEXPBusLocation + uRegOffset + (EXPBUS_STIMULUS_CS<<24) ) ) = uregValue;
}

/* Read stimulus register. uRegOffset is an offset from start of EXPBus mem. Function properly 
   recognizes current EXPBus mapping */
PRIVATE UINT16  
readStimulusReg(unsigned uRegOffset)
{
    UINT32  uCurrentEXPBusLocation;
            
    /* Figure out where EXPBus address space is mapped (from AHB point if view) */
    if( *( (UINT32*) (EXP_CNFG0) ) & EXP_CNFG0_MEMMAP_MASK) 
        uCurrentEXPBusLocation = EXP_MEMMAP_BOOTMODE;
    else
        uCurrentEXPBusLocation = EXP_MEMMAP_NORMALMODE;
        
    /* Read value from EXPBus register (CS, on which stimuls resides is coded into bit 26:24) */
    return *( (UINT16*) (uCurrentEXPBusLocation + uRegOffset + (EXPBUS_STIMULUS_CS<<24) ) );
}

PRIVATE void 
registerWrite(volatile unsigned *reg, unsigned value)
{
  *reg = value;
}
/* Function configures EXPBus to enable INTEL/16-bit mode on CS5 used for configuration of stimulus */
PRIVATE void 
fpgaStimulusEnable(void)
{
    /* configure CS, on which resides stimulus hardware to support INTEL/16-bit, non-multiplexed */
    registerWrite( (unsigned*) (EXP_TIMING_CS_STIMULUS), EXP_TIMING_CFG_STIMULUS );
}

/******************************************************************
 *
 * setStimulusAsMaster()
 * inputs: void
 *         
 * returns: BOOL pass/fail
 *
 ******************************************************************/
PUBLIC BOOL 
ixAtmUtilsUtopiaFpgaStimulusAsMasterSet(void)
{
    UINT32 regVal;

    fpgaStimulusEnable();
    
    regVal= readStimulusReg(BSR_CTRL1);
    
    if(regVal == 0)
    {
	return FALSE;	
    }

    /* write to the sel_utp_n bit in the stimulus make sure this low enabled */
    regVal= regVal & 0xEFFF;

    regVal= regVal | 0x0600;  
    regVal= regVal ^ 0x0400;  
    writeStimulusReg(BSR_CTRL1, regVal); 
    
    regVal= readStimulusReg(BSR_CTRL1);

    /* mask out the dont cares and check the master is enabled */
    regVal = regVal & 0x600;

    if(regVal != 0x200)
    {
	return FALSE;
    }	

    return TRUE;
}










