/*
 * FileName:    IxAtmUtilsCodeletBufMan.c
 * Description:  Utils Buffer Management
 *
 *
 * Design Notes:
 *
 *
 * File Version: $Revision: 1.1.1.1 $
 * 
 * -- Intel Copyright Notice --
 * 
 * Copyright 2002-2003 Intel Corporation All Rights Reserved.
 * 
 * The source code contained or described herein and all documents
 * related to the source code ("Material") are owned by Intel Corporation
 * or its suppliers or licensors.  Title to the Material remains with
 * Intel Corporation or its suppliers and licensors.
 * 
 * The Material is protected by worldwide copyright and trade secret laws
 * and treaty provisions. No part of the Material may be used, copied,
 * reproduced, modified, published, uploaded, posted, transmitted,
 * distributed, or disclosed in any way except in accordance with the
 * applicable license agreement .
 * 
 * No license under any patent, copyright, trade secret or other
 * intellectual property right is granted to or conferred upon you by
 * disclosure or delivery of the Materials, either expressly, by
 * implication, inducement, estoppel, except in accordance with the
 * applicable license agreement.
 * 
 * Unless otherwise agreed by Intel in writing, you may not remove or
 * alter this notice or any other notice embedded in Materials by Intel
 * or Intel's suppliers or licensors in any way.
 * 
 * For further details, please see the file README.TXT distributed with
 * this software.
 * 
 * -- End Intel Copyright Notice --
 */

#include "IxTypes.h"
#include "IxOsBuffMgt.h"
#include "IxOsBuffPoolMgt.h"
#include "IxOsServices.h"
#include "IxAtmCodelet_p.h"


typedef struct
{
    IX_MBUF_POOL *poolPtr;
    unsigned bufSize;
    unsigned numBufs;
} IxAtmUtilsBufManPoolInfo;


/*
 * Forward declarations
 */
void ixAtmUtilsMbufShow (void);

#ifdef  __vxworks
/* vx Works pool sizes */
#define LARGE_POOL_COUNT 4096
#define SMALL_POOL_COUNT 1000
#else
/* linux pool sizes */
#define LARGE_POOL_COUNT 1024
#define SMALL_POOL_COUNT 1000
#endif

static IxAtmUtilsBufManPoolInfo poolInfo[] =   /* pool information table */
{
    /*
      poolPtr     bufSize  numBufs
      ---------   -----    -------
    */
    {NULL,             64,        SMALL_POOL_COUNT},  /* Small packets, e.g. OAM */
    {NULL,             2048,      LARGE_POOL_COUNT}
};



IX_STATUS
ixAtmUtilsMbufPoolInit(void)
{
    int i, numPools;

    numPools = NELEMENTS (poolInfo);

    for (i = 0; i < numPools; i++)
    {
        /* Initialize the pool */
	if (IX_MBUF_POOL_INIT (&(poolInfo[i].poolPtr), poolInfo[i].numBufs, poolInfo[i].bufSize, "ixAtmUtils pool") != IX_SUCCESS)
        {
            return IX_FAIL;
        }
    }
    
    return IX_SUCCESS;
}

void
ixAtmUtilsMbufGet (UINT32 bufSize, IX_MBUF **buf)
{
    IX_MBUF_POOL *poolPtr = NULL;
    unsigned i,numPools;

    numPools = NELEMENTS (poolInfo);

    for (i = 0; i < numPools; i++)
    {
        if (poolInfo[i].bufSize >= bufSize)
	{
            poolPtr = poolInfo[i].poolPtr;
            break;
	}
    }

    if (poolPtr == NULL)
    {
        ixOsServLog (LOG_ERROR, "ixAtmUtilsMbufGet - Invalid bufSize specified\n", 0, 0, 0, 0, 0, 0);
        *buf = NULL;
        return;
    }

    IX_MBUF_POOL_GET (poolPtr, buf);
    
    if (*buf)
    {
        IX_MBUF_MLEN(*buf) = bufSize;
	/* memset (IX_MBUF_MDATA(*buf), 0xBF, IX_MBUF_MLEN(*buf)); */
    }
    else
    {
	ixOsServLog (LOG_ERROR, "ixAtmUtilsMbufGet returning a NULL buffer\n", 0, 0, 0, 0, 0, 0);
	ixAtmUtilsMbufShow ();
    }
}

void
ixAtmUtilsMbufFree(IX_MBUF *buf)
{
    IX_MBUF_POOL_PUT_CHAIN (buf);
}

void
ixAtmUtilsMbufShow (void)
{

    IX_MBUF_POOL *poolPtr = NULL;
    unsigned i,numPools;

    numPools = NELEMENTS (poolInfo);

    for (i = 0; i < numPools; i++)
    {
        poolPtr = poolInfo[i].poolPtr;
        if (poolPtr != NULL)
 	{
            IX_MBUF_POOL_SHOW (poolPtr);
	}
    }
}
