/**
 * @file IxAdsl_p.h
 *
 * @date 4-Jun-2003
 *
 * @brief  ADSL Driver header file for Public API (Component Interface module)
 *
 *
 * Design Notes:  this Adsl Driver only Supports Utopia Level 1
 *
 * @version $Revision: 1.1.1.1 $
 * 
 * @par
 * -- Intel Copyright Notice --
 * 
 * @par
 * Copyright 2000-2003 Intel Corporation All Rights Reserved.
 * 
 * @par
 * The source code contained or described herein and all documents
 * related to the source code ("Material") are owned by Intel Corporation
 * or its suppliers or licensors.  Title to the Material remains with
 * Intel Corporation or its suppliers and licensors.
 * 
 * @par
 * The Material is protected by worldwide copyright and trade secret laws
 * and treaty provisions. No part of the Material may be used, copied,
 * reproduced, modified, published, uploaded, posted, transmitted,
 * distributed, or disclosed in any way except in accordance with the
 * applicable license agreement .
 * 
 * @par
 * No license under any patent, copyright, trade secret or other
 * intellectual property right is granted to or conferred upon you by
 * disclosure or delivery of the Materials, either expressly, by
 * implication, inducement, estoppel, except in accordance with the
 * applicable license agreement.
 * 
 * @par
 * Unless otherwise agreed by Intel in writing, you may not remove or
 * alter this notice or any other notice embedded in Materials by Intel
 * or Intel's suppliers or licensors in any way.
 * 
 * @par
 * For further details, please see the file README.TXT distributed with
 * this software.
 * 
 * @par
 * -- End Intel Copyright Notice --
 */
#ifndef IXADSL_P_H
#define IXADSL_P_H

#include "IxAdslCtrleLib.h"
#include <IxAdsl.h>
#include <IxOsServices.h>
#include <taskLib.h>
/* ----------------------------------------------------------------------------------------------
 * #defines
 *-----------------------------------------------------------------------------------------------*/

#ifndef NDEBUG
#define DEBUG_CMD(test){ test; }   /**< Macro to show debug messages
                                     *   Usage: DEBUG_CMD(DEBUG_LOG("xxxxx"));
                                     */
#define DEBUG_LOG printf
#else
#define DEBUG_CMD(ignore)
#define DEBUG_LOG printf
#endif
#define IX_ADSL_WAIT_FOR_OPEN_CNT   10  /**< Number of attempts to Open Line before timing out
                                         */
#define IX_ADSL_POLL_DELAY          1000  /**< 1 second resolution for polling of adsl line state
                                           */

#define IX_ADSL_SIZEOF_CALLBACK_LIST 10   /**< Number of callbacks we can register per adsl line
                                           */
#define IX_ADSL_TASK_PRIORITY 25        /**< The ADSL task must run at a higher priority than
                                           * the vxWorks netTask as heavy ethernet traffic may
                                           * block this task from catching changes in the ADSL
                                           * line state */

#define IX_ADSL_DOWN_DEBOUNCE_CNT 3     /**< Number of Line Downs before considering really down */

#if IX_UTOPIAMODE==1    /**< Compiler switch for UTOPIA Level controlled by
                            top level Makefile */
#define IX_ADSL_NUM_LINES 1 /**< SPHY mode only supports one Adsl line */
#else
#define IX_ADSL_NUM_LINES 8 /**< MPHY mode: MTK20170/20150 Phy is 2 ports per line */
#endif

/* ---------------------------------------
 *  #defines for Diagnostics
 *---------------------------------------*/
#define IX_ADSL_TRAININGLOGINDEX 2        /**< Training Log Index for CtrlE address get */
#define IX_ADSL_TRAININGLOGSIZE 0x4000    /**< Training log size of 16 kBytes to be increased 
                                               if necessary to record up to the Showtime event */ 
#define IX_ADSL_TRAININGBLOCKSIZE 128     /**< Block size during data get */
#define IX_ADSL_SIZE1BYTE 1               /**< Size 1 byte */
#define IX_ADSL_SIZE2BYTE 2               /**< Size 2 byte */
#define IX_ADSL_SIZE3BYTE 3               /**< Size 3 byte */
#define IX_ADSL_SIZE4BYTE 4               /**< Size 4 byte */
#define IX_ADSL_INDEX0 0                  /**< Index 0 */
#define IX_ADSL_INDEX1 1                  /**< Index 1 */
#define IX_ADSL_INDEX2 2                  /**< Index 2 */
#define IX_ADSL_INDEX3 3                  /**< Index 3 */
#define IX_ADSL_INDEX4 4                  /**< Index 4 */
#define IX_ADSL_SHIFTBYTES_0 0            /**< Number of bits shifted for 0 byte */
#define IX_ADSL_SHIFTBYTES_1 8            /**< Number of bits shifted for 1 byte */
#define IX_ADSL_SHIFTBYTES_2 16           /**< Number of bits shifted for 2 byte */
#define IX_ADSL_SHIFTBYTES_3 24           /**< Number of bits shifted for 3 byte */
#define IX_ADSL_0x100      0x100          /**< Hex 0x100 used in modulus(%) operation
                                            *  to extract bytes from 32 bit word
                                            */
/* ----------------------------------------------------------------------------------------------
 *                                      TYPE DEFINITIONS
 *-----------------------------------------------------------------------------------------------*/
/**
 * @struct  IxAdslEnableModemLine_fp
 * @brief   Function pointer to CtrlE modem activation routines
 *
 */
typedef UINT32
(*IxAdslEnableModemLine_fp)
                ( UINT32 lineNum, T_adsl_ConfigurationData* configData );
/**
 * @struct  IxAdslVendorInfo
 * @brief   Data structure for Vendor ID Information
 *
 */
typedef struct
{
    UINT8 itu_vendorid_countrycode;
    UINT8 itu_vendorid_reserved;
    UINT8 itu_vendorid_vendorcode_1;
    UINT8 itu_vendorid_vendorcode_2;
    UINT8 itu_vendorid_vendorcode_3;
    UINT8 itu_vendorid_vendorcode_4;
    UINT8 itu_vendorid_vendorspecific_1;
    UINT8 itu_vendorid_vendorspecific_2;
} IxAdslVendorInfo;
/**
 * @enum  IxAdslSMState
 * @brief  Operational States in the State Machine
 *
 */
typedef enum
{
    IX_ADSL_LINE_WAIT,    /* nothing to do */
    IX_ADSL_LINE_INIT,    /* line open */
    IX_ADSL_LINE_OPEN,    /* wait for open response */
    IX_ADSL_LINE_POLLING, /* poll status */
    IX_ADSL_LINE_CLOSE    /* close the line */
} IxAdslSMState;

/**
 * @enum  IxAdsllineEnableState
 * @brief  Line lineEnable State
 *
 */
typedef enum
{
	IX_ADSL_LINE_DISABLE,
	IX_ADSL_LINE_ENABLE
}IxAdsllineEnableState;

#endif /* IXADSL_P_H */



