
/**
 * @file IxAdslCtrleConstants.h
 *
 * @date 29-April-2000
 *
 * @brief  ADSL Driver CTRL-E Library #defines adopted from STMicro(formerly Alcatel) reference design
 *
 *
 * Design Notes:
 *
 * @version $Revision: 1.1.1.1 $
 * 
 * @par
 * -- Intel Copyright Notice --
 * 
 * @par
 * Copyright 2000-2003 Intel Corporation All Rights Reserved.
 * 
 * @par
 * The source code contained or described herein and all documents
 * related to the source code ("Material") are owned by Intel Corporation
 * or its suppliers or licensors.  Title to the Material remains with
 * Intel Corporation or its suppliers and licensors.
 * 
 * @par
 * The Material is protected by worldwide copyright and trade secret laws
 * and treaty provisions. No part of the Material may be used, copied,
 * reproduced, modified, published, uploaded, posted, transmitted,
 * distributed, or disclosed in any way except in accordance with the
 * applicable license agreement .
 * 
 * @par
 * No license under any patent, copyright, trade secret or other
 * intellectual property right is granted to or conferred upon you by
 * disclosure or delivery of the Materials, either expressly, by
 * implication, inducement, estoppel, except in accordance with the
 * applicable license agreement.
 * 
 * @par
 * Unless otherwise agreed by Intel in writing, you may not remove or
 * alter this notice or any other notice embedded in Materials by Intel
 * or Intel's suppliers or licensors in any way.
 * 
 * @par
 * For further details, please see the file README.TXT distributed with
 * this software.
 * 
 * @par
 * -- End Intel Copyright Notice --
 */

#ifndef IXADSLCTRLECONSTANTS_H
#define	IXADSLCTRLECONSTANTS_H

#define  C_CONF_DATA_ACK 0
#define  C_CONF_DATA_REJ 1
#define  C_CONF_DATA_ALREADY_DOWN 2
#define  C_CONF_DATA_COMMPROBLEM 125
/**********CTRLE REGISTER ADDRESSES********************/
#define    TXCOMMANDREG 0x00
#define    RXCOMMANDREG 0x01
#define    RXCOMAVREG   0x03
#define    BLCKBADDRREG 0x08
#define    BLCKLENREG   0x0C
#define    BLCKDATAREG 	0x0E

#define    CTEAD_LT_MINNOISEMARGIN_DN       0x040
#define    CTEAD_LT_MAXPSD_DN               0x046
#define    CTEAD_LT_MAXAGGPOWERLEVEL_DN     0x048
#define    CTEAD_UTOPIA_LEVEL				0x04A
#define    CTEAD_LT_CARRIERMASK             0x050
#define    CTEAD_LT_RAMODE_DN               0x070
#define    CTEAD_LT_INTERL_PLANNED_BITRATE_DN 0x074
#define    CTEAD_LT_RARATIO_DN 				0x08C
#define    CTEAD_LT_RADOWNSHIFTMARGIN_DN 	0x090
#define    CTEAD_LT_RADOWNSHIFTINTERVAL_DN  0x094
#define    CTEAD_LT_INTERL_MAXDELAY_DN      0x09C
#define    CTEAD_ACC_BER_FAST               0x0A3
#define    CTEAD_ACC_BER_IL                 0x0B0
#define    CTEAD_ITU_VENDORID_COUNTRYCODE   0x0BA
#define    CTEAD_ADSL_REQUESTED_INFO_0      0x0E0
#define    CTEAD_MODEM_STATUS               0x100
#define    CTEAD_RVERSION_NEAR_END          0x102
#define    CTEAD_RVERSION_FAR_END           0x103
#define    CTEAD_RVENDOR_NEAR_END_LSB       0x104
#define    CTEAD_RVENDOR_FAR_END_LSB        0x106

/* LT Mode only*/
#define    CTEAD_LT_FAR_RELCAPACITYOCC_DN_LSB	0x108
#define    CTEAD_LT_FAR_NOISEMARGIN_DN 			0x10A
#define    CTEAD_LT_FAR_OUTPUTPOWER_UP 			0x10B
#define    CTEAD_LT_FAR_ATTENUATION_DN 			0x10C
#define    CTEAD_LT_FAR_ATTAINABLE_BITRATE_LSB 	0x10E
#define    CTEAD_LT_NEAR_RELCAPACITYOCC_UP_LSB 	0x110
#define    CTEAD_LT_NEAR_NOISEMARGIN_UP 		0x112
#define    CTEAD_LT_NEAR_OUTPUTPOWER_DN 		0x113
#define    CTEAD_LT_NEAR_ATTENUATION_UP 		0x114
#define    CTEAD_LT_NEAR_ATTAINABLE_BITRATE_LSB 0x116
#define    CTEAD_LT_NEAR_CARRIER_LOAD			0x118

/*NT Mode only */
#define    CTEAD_NT_NEAR_RELCAPACITYOCC_DN_LSB 	0x108
#define    CTEAD_NT_NEAR_NOISEMARGIN_DN 		0x10A
#define    CTEAD_NT_NEAR_OUTPUTPOWER_UP 		0x10B
#define    CTEAD_NT_NEAR_ATTENUATION_DN 		0x10C
#define    CTEAD_NT_FAR_RELCAPACITYOCC_UP_LSB	0x110
#define    CTEAD_NT_FAR_NOISEMARGIN_UP 			0x112
#define    CTEAD_NT_FAR_OUTPUTPOWER_DN 			0x113
#define    CTEAD_NT_FAR_ATTENUATION_UP 			0x114
#define    CTEAD_NT_FAR_CARRIER_LOAD 			0x118

/*Registers used for Any mode */
#define    CTEAD_NEAR_INT_CHANNELDATA_LSB 		0x1A0
#define    CTEAD_NEAR_FAST_CHANNELDATA_LSB 		0x1A2
#define    CTEAD_FAR_INT_CHANNELDATA_LSB 		0x1A4
#define    CTEAD_FAR_FAST_CHANNELDATA_LSB 		0x1A6
#define    CTEAD_NEAR_FEC_NI_LSB 			    0x1B0
#define    CTEAD_NEAR_BITMAP_STATUS 			0x1E0
#define    R_OPEN_FAILED_REG 				    0x1E4
#define    R_SELFTEST_RESULTS_REG 		   	    0x1E5
#define    CTEAD_FUNC_FIELD_1FC 			    0x1FC
#define    CTEAD_FUNC_FIELD_1FD 			    0x1FD
#define    CTEAD_CONTROLLER_SW_VERSION  		0x1FE
#define    R_ACTIVERXCELLSFAST 			        0x1D0
#define    R_ACTIVERXCELLSINTERLEAVED 			0x1D4
#define    R_ACTIVETXCELLSFAST 			        0x1D8
#define    R_ACTIVETXCELLSINTERLEAVED 			0x1DC

/*
 * Definitions for CTRLE parameter values
 */
#define CTEAD_ADSL_REG_ADDR_LSB		0x1E8
#define CTEAD_ADSL_REG_ADDR_MSB		0x1E9

#define CTEAD_ADSL_REG_DATA_LSB		0x1EC
#define CTEAD_ADSL_REG_DATA_MSB		0x1ED

#define ADSL_DYING_GASP_REG	        0x1FA

#define	MODEM_STATUS_UP			    0x20
#define	MODEM_STATUS_DOWN		    0x00
#define	MODEM_STATUS_WAIT_FOR_INIT	0x08
#define	MODEM_STATUS_INITIALIZING	0x10

#define	ADSL_CLOSE_ORDERLY_SHUTDOWN	0x0e
#define	ADSL_SEND_DYING_GASP		0x0d
#define ADSL_DYING_GASP_ENABLE		0x02

#define ADSL_OPEN_LOOPBACK		0x01
#define	ADSL_OPEN			    0x03
#define	ADSL_OPEN_GLITE			0x07
#define	ADSL_OPEN_GDMT			0x06
#define	ADSL_OPEN_ANSI			0x05
#define	ADSL_OPEN_MULTIMODE		0x08

#define	ADSL_CLOSE			       0x04
#define ADSL_SELFTEST_SEND_TONES   0x0F



#define	ADSL_SELFTEST_LONG		0x02
#define	ADSL_SELFTEST_SHORT		0x01



#define MODEM_REG_WRITE_CMD		0x10
#define MODEM_REG_READ_CMD		0x11

#define	SACHEM_VERSION_ADDRESS		0
#define	SACHEM_VERSION_LENGTH		0

#define	MODEM_LOAD_BLOCK		0x13
#define MODEM_DUMP_BLOCK		0x12
#define MODEM_JUMP_ADDR			0x14

#define	GET_NEAR_ITU_VENDOR_ID		0x32
#define	GET_FAR_ITU_VENDOR_ID		0x33
#define	GET_OPERATIONAL_MODE		0x31


#define ADSL_SIGNAL_LOST		    0x41
#define	ADSL_SUICIDE_REQUEST		0x42

#define	GABARIT_BASE_ADDRESS		0
#define	GABARIT_BLOCK_LENGTH		0
#define	LOG_BASE_ADDRESS_LT		    0
#define	LOG_BASE_ADDRESS_NT		    0
#define	LOG_BLOCK_LENGTH		   32


#define	 NUMBER_OF_TONES    256
#define	 NUMBER_OF_LOGWORDS 512

/*
 * ATU-R Rx Commands opcodes.
 */

#define  ADSL_OperationalMode_Available 0x12
#define  ADSL_OperatialMode_Nack  0x13
#define  ADSL_Near_End_Identification_Available 0x14
#define  ADSL_Near_End_Identification_Nack  0x15
#define  ADSL_Far_End_Identification_Available 0x16
#define  ADSL_Far_End_Identification_Nack  0x17
#define  ADSL_Open_Rejected  0x21
#define  ADSL_Open_Failed 0x22
#define  ADSL_Connection_Opened  0x24
#define  ADSL_Signal_Lost 0x41
#define  ADSL_Connection_Closed  0x25
#define  ADSL_Close_Rejected  0x26
#define  ADSL_Selftest_Results 0x27
#define  ADSL_Orderly_Shutdown_Executed 0x28
#define  ADSL_Orderly_Shutdown_Rejected 0x29
#define  ADSL_Orderly_Shutdown_Ack 0x30
#define  ADSL_Orderly_Shutdown_Nack 0x31
#define  ADSL_Dying_Gasp_Sent 0x34
#define  ADSL_Dying_Gasp_Rejected 0x35
#define  ADSL_Suicide_Request 0x42
#define  ADSL_Unknown_Opcode 0x60
#define  ADSL_Modem_Reg_Available 0x61
#define  ADSL_Modem_Reg_Write_Ack 0x62
#define  ADSL_Modem_Reg_Write_Nack 0x63
#define  ADSL_Modem_Block_Available 0x64
#define  ADSL_Modem_Block_Dump_Ack 0x65
#define  ADSL_Modem_Block_Dump_Nack 0x66

#define CURR_STATUS_NO_DEFECT 0x1
#define CURR_STATUS_LOSS_MARGIN 0x4
#define CURR_STATUS_LOSS_POWER 0x20
#define CURR_STATUS_LOSS_FRAME 0x40
#define CURR_STATUS_LOSS_SIGNAL 0x80
#define CURR_STATUS_LOSS_CD_INTERLEAVED 0x8
#define CURR_STATUS_LOSS_CD_NONINTERLEAVED 0x10

#define  IX_ASW_MODEMGETADDRESS_CMD     0x16
#define  IX_ASW_MODEMGETADDRESS_ACK     0x6A
#define  IX_ASW_MODEMGETADDRESS_NACK    0x6B
#define  IX_ASW_BLOCKDUMP_ACK 0x65
#define  IX_ASW_BLOCKDUMP_NACK 0x66

/* ----------------------------------------------
 *  #defines for Adsl Line configuration
 *  specific to 20150 and 20170
 *----------------------------------------------*/
#if IX_UTOPIAMODE == 1
#define IX_ADSL_UTOPIALEVEL 0x01  /**<  UtopiaLevel 1; */
#else
#define IX_ADSL_UTOPIALEVEL 0x02  /**<  UtopiaLevel 2; */
#endif

/* Adsl component subfunction code */
#ifdef IX_USE_ADSL_20150
/* 20150 specific defines */
#define  IX_ASW_SUBFUNCTION_CODE_CPE 0x15  /* 20154 AFE Sub-function code for CPE */
#define  IX_ASW_SUBFUNCTION_CODE_CO  0x6   /* 20154 AFE Sub-function code for CO */
                                          /* 0x6 for +20dbm max power
		                                   * 0x17 for +16.6 max power */
#else
#ifdef IX_USE_ADSL_20170
/* 20170 specific defines */
#define  IX_ASW_SUBFUNCTION_CODE_CPE 0x17   /* 20174 AFE Sub-function code for CPE */
#define  IX_ASW_SUBFUNCTION_CODE_CO  0x0    /* 20174 AFE does not support CO */
#define  IX_ASW_BLOCKDUMP_ACK_166 0x64      /* Block dump acknowledge is different for 20170 chipset */
#endif /* IX_USE_ADSL_20170 */
#endif /* IX_USE_ADSL_20150 */

/* Parameters for CO 20150 */
#define IX_ASW_CO_MaxAddNoiseMarginDnstr 31
#define IX_ASW_CO_MaxAddNoiseMarginUpstr 31
#define IX_ASW_CO_TargetNoiseMarginDnstr 6
#define IX_ASW_CO_TargetNoiseMarginUpstr 6
#define IX_ASW_CO_MaxPSDDnstr -40
#define IX_ASW_CO_MaxAggrPwrLvlDnstr 20
#define IX_ASW_CO_MaxAggrPwrLvlUpstr 13
#define IX_ASW_CO_RARatioDnstr 100
#define IX_ASW_CO_RARatioUpstr 100
#define IX_ASW_CO_InterlMaxDelayDnstr 16
#define IX_ASW_CO_InterlMaxDelayUpstr 16

#define IX_ASW_CO_FastMinBitrateDnstr 50
#define IX_ASW_CO_FastMinBitrateUpstr 10
#define IX_ASW_CO_FastMaxBitrateDnstr 8000
#define IX_ASW_CO_FastMaxBitrateUpstr 1000

#define IX_ASW_CO_InterlMinBitrateDnstr 50
#define IX_ASW_CO_InterlMinBitrateUpstr 10
#define IX_ASW_CO_InterlMaxBitrateDnstr 8000
#define IX_ASW_CO_InterlMaxBitrateUpstr 1000

#endif /* IXADSLCTRLECONSTANTS_H */


