/**********************************************************************
*h*   
*
*   Name:       	gnc01t.h
* 
*   Description:  	
*  
*   Author:  
*  
*   History:  
*  
*h*   
**********************************************************************/

#ifndef _GNC0101T_H
#define _GNC0101T_H

/*** Includes ***/

/*** Define Constants ***/

#define MAX_PRI_QUEUE 4

/* 
 *	PCI Configuration Register set.
 */

#define CFGID	0x00	/* Configuration Identification Register */
#define CFGCS	0x04	/* Configuration Command and Status Register */
#define CFGRID	0x08	/* Configuration Revision ID Register */
#define CFGLAT	0x0C	/* Configuration Latency Timer Register */
#define CFGIOA	0x10	/* Configuration IO Base Address Register */
#define CFGMA	0x14	/* Configuration Memory Address Register */
#define CFGMA1	0x18	/* Configuration Memory Address High Dword Register */

/* 1Ch - 28h	- Reserved (reads return zero)	*/

#define CFGSID	0x2C	/* Configuration Subsystem Identificaton Register */
#define CFGROM	0x30	/* Boot ROM Configuration Register */
#define CAPPTR	0x34	/* Capabilities Pointer Register */
#define CFGINT	0x3C	/* Configuration Interrupt Select Register */
#define PMCAP	0x40	/* Power Management Capabilities Register */
#define PMCS	0x44	/* Power Management Control and Status Register */

/* 48h - FFh	- Reserved (reads return zero)	*/

#define IOBASE_MASK		0xFFFFFF00	/*Mask for getting IO Address */
#define MEMBASE_MASK	0xFFFFFF00	/*Mask for getting MEM Address */

/*
 *	Operational Register Bit definitions
 */
#define	CR		0x00	/* Command Register */
#define	CFG		0x04	/* Configuration and Media Status Register */
#define MEAR	0x08	/* MII/EEPROM Access Register */
#define PTSCR	0x0C	/* PCI Test Control Register */
#define	ISR		0x10	/* Interrupt Status Register */
#define	IMR		0x14	/* Interrupt Mask Register */
#define	IER		0x18	/* Interrupt Enable Register */
#define	IHR		0x1C	/* Interrupt Holdoff Register */
#define	TXDP	0x20	/* Transmit Descriptor Pointer Register */
#define	TXDP_HI	0x24	/* Transmit Descriptor Pointer High Dword Register */
#define	TXCFG	0x28	/* Transmit Configuration Register */
#define	GPIOR	0x2C	/* General Purpose I/O Control Register */
#define	RXDP	0x30	/* Receive Descriptor pointer Register */
#define	RXDP_HI	0x34	/* Receive Descriptor pointer High Dword Register */
#define	RXCFG	0x38	/* Receive Configuration Register */
#define	PQCR	0x3C	/* Priority Queue Control Register */
#define	WCSR	0x40	/* Wake Command/Status Register */
#define	PCR		0x44	/* Pause Control/Status Register */
#define	RFCR	0x48	/* Receive Filter/Match Control Register */
#define	RFDR	0x4C	/* Receive Filter/Match Data Register */
#define	BRAR	0x50	/* Boot ROM Address Register */
#define	BRDR	0x54	/* Boot ROM Data Register */
#define	SRR		0x58	/* Silicon Revision Register */
#define	MIBC	0x5C	/* Management Information Base Control Register */
/*
 *	MIB Data Registers
 */
#define RXErroredPkts	0x60	
#define	RXFCSErrors		0x64
#define	RXMsdPktErrors 	0x68
#define	RXFAErrors		0x6C
#define	RXSymbolErrors	0x70
#define	RXFrameTooLong	0x74
#define	RXIRLErrors		0x78
#define	RXBadOpcodes	0x7C
#define	RXPauseFrames	0x80
#define	TXPauseFrames	0x84
#define	TXSQEErrors		0x88

/*	8c-9ch	Reserved	*/

#define	TXDP1	0xA0	/* Transmit Descriptor pointer prio 1  Register */
#define	TXDP2	0xA4	/* Transmit Descriptor pointer prio 2  Register */
#define	TXDP3	0xA8	/* Transmit Descriptor pointer prio 3  Register */

#define	RXDP1	0xB0	/* Receive Descriptor pointer prio 1  Register */
#define	RXDP2	0xB4	/* Receive Descriptor pointer prio 2  Register */
#define	RXDP3	0xB8	/* Receive Descriptor pointer prio 3  Register */

#define	VRCR	0xBC	/* VLAN/IP Receive Control Register */
#define	VTCR	0xC0	/* VLAN/IP Transmit Control Register */
#define	VDR		0xC4	/* VLAN Data Register */
#define	CGMR	0xC8	/* CGM Control Register */
#define	CCSR	0xCC	/* Clockrun Control/Status Register */

/*	D0-DCh	Reserved	*/

#define	TBICR	0xE0	/* TBI Control Register */
#define	TBISR	0xE4	/* TBI Status Register */
#define	TANAR	0xE8	/* TBI Auto-Negotiation Advertisement Register */
#define	TANLPAR	0xEC	/* TBI Auto-Negotiation Link Partner ability Register */
#define	TANER	0xF0	/* TBI Auto-Negotiation Expansion Register */
#define	TESR	0xF4	/* TBI Extended Status Register */


/*  
 *	CR  - command register bit definitions 
 */

#define TXE     0x00000001      /* transmitter enable - bit 0 */
#define TXD     0x00000002      /* transmitter disable - bit 1 */
#define RXE     0x00000004      /* receiver enable - bit 2 */
#define RXD     0x00000008      /* receiver disable - bit 3 */
#define TXR     0x00000010      /* transmitter reset - bit 4 */
#define RXR     0x00000020      /* receiver reset - bit 5 */

/* bit 6	     0x00000040 - 	Unused	*/

#define SWI     0x00000080      /* software interrupt - bit 7 */
#define RST     0x00000100      /* soft reset - bit 8 */

#define TXDP0_PRISEL       0x00000200      /* Tx Priority Queue 0 - bit 9 */
#define TXDP1_PRISEL       0x00000400      /* Tx Priority Queue 1 - bit 10 */
#define TXDP2_PRISEL       0x00000800      /* Tx Priority Queue 2 - bit 11 */
#define TXDP3_PRISEL       0x00001000      /* Tx Priority Queue 3 - bit 12 */

#define RXDP0_PRISEL       0x00002000      /* Tx Priority Queue 0 - bit 0 */
#define RXDP1_PRISEL       0x00004000      /* Tx Priority Queue 1 - bit 0 */
#define RXDP2_PRISEL       0x00008000      /* Tx Priority Queue 2 - bit 0 */
#define RXDP3_PRISEL       0x00010000      /* Tx Priority Queue 3 - bit 0 */

/*	     	bits 17 - 32 unused	*/

/*  
 *	CFG  - Configuration and Media Status Register
 */
#define BEM      	0x00000001      /* big endian mode */
#define BROM_DIS 	0x00000004      /* disable boot rom interface (unused) */
#define PESEL    	0x00000008      /* assert SERR on DPERR detection */
#define EXD      	0x00000010      /* disable excessive deferral errs */
#define POW      	0x00000020      /* program out-of-window */
#define SB       	0x00000040      /* Single Backoff */
#define REQALG   	0x00000080      /* PCI bus request algorithm */
#define EXTSTS_EN 	0x00000100      /* Extended Status Enable */
#define PHY_DIS  	0x00000200      /* disable interal phy */
#define PHY_RST  	0x00000400      /* reset internal phy */

#define PINT_DUPSTS	0x00100000      /* Enable Phy Intr. on Duplex Change */
#define PINT_LNKSTS	0x00080000      /* Enable Phy Intr. on Link Change */
#define PINT_SPDSTS	0x00040000      /* Enable Phy Intr. on Speed Change */

#define AUTO_1000	0x00200000      /* Enable Auto 1000Mb Operation */
#define MODE_1000	0x00400000      /* Enable 1000Mb Mode/GMII */
#define AUTO_DUP	0x00800000      /* Enable Auto Full duplex */
//Ramit
#define DATA64_EN	0x00001000		/* Enable 64 bit transfer */
#define TMRTEST		0x00020000		/* Enable 64 bit transfer */
/*		bits 25 - 27 Reserved	*/

#define	FULL_DUPLEX		0x01
#define HALF_DUPLEX		0x00
#define DUPSTS          0x10000000      /* speed 10Mb */

#define SPEED1000		0x00000000      /* speed 1000Mb */
#define SPEED10			0x20000000      /* speed 10Mb */
#define SPEED100		0x60000000      /* speed 100Mb */
#define SPEEDMASK       0x60000000      /* speed bit mask - All Speeds*/
#define LNKSTS          0x80000000      /* link status */

/* 
 * MEAR - MII / EEPROM Access Register.
 */
#define EEDI            0x00000001      /* EEPROM data in (out data out) */
#define EEDO            0x00000002      /* EEPROM data out (our data in) */
#define EECLK           0x00000004      /* EEPROM serial clock */
#define EESEL           0x00000008      /* EEPROM chip select */
#define MDIO            0x00000010      /* MII management data input/output */
#define MDDIR           0x00000020      /* MII management data direction */
#define MDC             0x00000040      /* MII management data clock */

#define	MIIread			0x60000000l
#define	MIIwrite		0x50020000l

/* 	bits 7-31 - unused	*/

/* 
 * PCSCR - PCI Test Control Register
 */
#define EEBIST_FAIL     0x00000001      /* EE BIST fail indication */
#define EEBIST_EN       0x00000002      /* enable EEPROM BIST */
#define EELOAD          0x00000004      /* enable EEPROM load */
#define RBIST_RXFFAIL   0x00000008      /* RX Filter BIST fail (RO) */
#define RBIST_HFFAIL    0x00000010      /* Hash Filter BIST fail (RO) */
#define RBIST_TX0FAIL   0x00000020      /* TX Data FIFO BIST fail (RO) */
#define RBIST_TX1FAIL   0x00000040      /* TX FIFO 1 BIST fail (RO) */
#define RBIST_RX0FAIL   0x00000080      /* RX Data FIFO BIST fail (RO) */
#define RBIST_RX1FAIL   0x00000100      /* RX FIFO 1 BIST fail (RO) */
#define RBIST_DONE      0x00000200      /* RX FIFO 1 BIST fail (RO) */
#define RBIST_EN        0x00000400      /* SRAM BIST Enable */
#define BMTM_EN         0x00001000      /* bus master test mode enable */

/* 
 *	ISR, IMR , IE , IHR - interrupt bit definitions 
 */
#define	INTR_MASK		0x00000000	/* Interrupt Mask */
#define RXOK            0x00000001      /* RX OK interrupt */
#define RXDESC          0x00000002      /* RX descriptor interrupt */
#define RXERR           0x00000004      /* RX packet error */
#define RXEARLY         0x00000008      /* RX Early Threshold */
#define RXIDLE          0x00000010      /* RX Idle */
#define RXORN           0x00000020      /* RX Overrun */

#define TXOK            0x00000040      /* TX OK interrupt */
#define TXDESC          0x00000080      /* TX descriptor interrupt */
#define TXERR           0x00000100      /* TX packet error */
#define TXIDLE          0x00000200      /* TX idle */
#define TXURN           0x00000400      /* TX underrun */

#define MIB             0x00000800      /* MIB service */
#define SWI_INTR        0x00001000      /* software interrupt */
#define PME             0x00002000      /* power management event */
#define PHY             0x00004000      /* phy interrupt */
#define HIBERR          0x00008000      /* hi bit error */
#define RXSOVR          0x00010000      /* rx status fifo overrun */
#define RTABT           0x00020000      /* received target abort */
#define RMABT           0x00040000      /* received system abort */
#define SSERR           0x00080000      /* signalled system error */
#define DPERR           0x00100000      /* detected parity error */
#define RXRCMP          0x00200000      /* receive reset complete */
#define TXRCMP          0x00400000      /* transmit reset complete */

#define RXDESC0			0x00800000	/* Rx Descriptor for priority Q 0 */
#define RXDESC1			0x01000000	/* Rx Descriptor for priority Q 1 */
#define RXDESC2			0x02000000	/* Rx Descriptor for priority Q 2 */
#define RXDESC3			0x04000000	/* Rx Descriptor for priority Q 3 */

#define TXDESC0			0x08000000	/* Tx Descriptor for priority Q 0 */
#define TXDESC1			0x10000000	/* Tx Descriptor for priority Q 1 */
#define TXDESC2			0x20000000	/* Tx Descriptor for priority Q 2 */
#define TXDESC3			0x40000000	/* Tx Descriptor for priority Q 3 */

/*	bit 31 - Reserved	*/

#define	IE				0x00000001	/* Interrupt Enable */

#define IHCTL			0x00000100	/* Interrupt HoldOff value */

/* 
 * Transmit Descriptor Pointer , Transmit Descriptor Pointer HighWord Register
 */

#define	TXDP_MASK		0xFFFFFFFC	/* Mask for Transmit Descriptor Pointer	*/
#define	TXDP_HI_MASK	0xFFFFFFFF	/* Mask for Transmit Descriptor High word 
										pointer */

/* 
 * TXCFG - Transmit Configuration Register
 */

/*	Max DMA burst size per Tx/Rx DMA burst	*/

#define	MXDMA8			0x00100000	/* 8 bytes	*/
#define	MXDMA16			0x00200000	/* 16 bytes	*/
#define	MXDMA32			0x00300000	/* 32 bytes	*/
#define	MXDMA64			0x00400000	/* 64 bytes	*/
#define	MXDMA128		0x00500000	/* 128 bytes	*/
#define	MXDMA256		0x00600000	/* 256 bytes	*/
#define	MXDMA512		0x00700000	/* 512 bytes	*/
#define	MXDMA1024		0x00000000	/* 1024 bytes	*/

#define	ATP				0x10000000	/*	Automatic Transmit Padding	*/
#define	HBI				0x40000000	/*	Heart Beat Ignore	*/
#define	CSI				0x80000000	/*	Carrier Sense Ignore	*/
//Madhu 
#define	ECRETRY			0x00800000  /* Excessive collission retry enable */
#define BRST_DIS        0x00080000  /* Excessive collission retry enable */

/* 
 * RXCFG - Receive Configuration Register
 */

#define	ALP				0x08000000
#define	RX_FD			0x10000000
#define	STRIPCRC		0x20000000
#define	ARP				0x40000000
#define AEP				0x80000000
#define AIRL			0x04000000

/*
 *	PQCR	- Priority Queueing Control Register.
 */
#define	TXPQEN			0x00000001
#define	RXPQ2			0x00000004
#define	RXPQ3			0x00000008
#define	RXPQ4			0x0000000c

/*
 *	Wake Command / Status Register. 
 */
#define	WKPHY			0x00000001
#define	WKUCP			0x00000002
#define	WKMCP			0x00000004
#define	WKBCP			0x00000008
#define	WKARP			0x00000010
#define	WKPAT0			0x00000020
#define	WKPAT1			0x00000040
#define	WKPAT2			0x00000080
#define	WKPAT3			0x00000100
#define	WKMAG			0x00000200
#define	MPSOE			0x00000400
#define	PHYINT			0x00400000
#define PATM0			0x08000000
#define PATM1			0x10000000
#define PATM2			0x20000000
#define PATM3			0x40000000
#define MPR				0x80000000

/*
 *	PCR - Pause Control / Status Register.
 */
#define	PS_FFLO_2K		0x00040000
#define	PS_FFLO_4K		0x00080000
#define	PS_FFLO_8K		0x000C0000

#define	PS_FFHI_2K		0x00100000
#define	PS_FFHI_4K		0x00200000
#define	PS_FFHI_8K		0x00300000

#define	PS_STLO_2		0x00400000
#define	PS_STLO_4		0x00800000
#define	PS_STLO_8		0x00C00000

#define	PS_STHI_2		0x01000000
#define	PS_STHI_4		0x02000000
#define	PS_STHI_8		0x03000000

#define	PLEN_SEL		0x00010000
#define PSEN			0x80000000
#define PS_MCAST		0x40000000
//Madhu: Clean up
#define PS_DA			0x20000000
#define PS_RCVD			0x08000000
//Ramit : Since PS_RCVD cannot be read back use PS_ACT
#define PS_ACT			0x10000000
/*
 *	Receive Filter / Match Control Register.
 */

#define APAT0			0x00800000
#define APAT1			0x01000000
#define APAT2			0x02000000
#define APAT3			0x04000000
#define RFEN			0x80000000

/*
 *	MIBC - Management Information Base Control Register.
 */
#define MIBS			0x00000008
#define	ACLR			0x00000004
#define FRZ				0x00000002

/*
 *	RFCR - Receive Flow/Filter Control Register
 */
#define RFAA_shift      28
#define RFEP_shift      16
#define RFEN            0x80000000  /* RF enable */
#define AAB           	0x40000000    /* RF accept all broadcasts */
#define AAM           	0x20000000    /* RF accept all multicasts */
#define AAU           	0x10000000    /* RF accept all unicast */
#define APM             0x08000000  /* accept on perfect match */
#define APAT            0x07800000  /* (&) accept on pattern match--bits 26-23 */
#define AARP            0x00400000      /* accept ARP packets */
#define MHEN            0x00200000      /* mulitcast hash enable */
#define UHEN            0x00100000      /* unicast hash enable */
#define ULM             0x00080000      /* U/L bit mask */

/*
 *      VTCR - VLAN/IP Transmit Control Register
 */
#define PPCHK   		0x00000008
#define GCHK   			0x00000004
#define VPPTI   		0x00000002
#define VGTI   			0x00000001

/*
 *      VRCR - VLAN/IP Receive Control Register
 */
#define RUDPE  			0x00000080
#define RTCPE  			0x00000040
#define RIPE  			0x00000020
#define IPEN   			0x00000010

/*
 *	GIG - PHY Register (DP83891) definitions.
 */

#define BMCR			0x00
#define	BMSR			0x01
#define	PHYIDR1			0x02
#define	PHYIDR2			0x03

#define	ANAR			0x04
#define	ANLPAR			0x05
#define	ANER			0x06
#define	ANNPTR			0x07
#define	ANNPRR			0x08
#define	KTCR			0x09
#define	KSTSR			0x0A
#define STROP			0x10

/*	0x0B - 0x0E	Reserved	*/

#define	KSCR			0x0F
#define	PHYSUP			0x11
#define ECR1			0x10
#define	TBTOR			0x12

/*
 * BMCR - Basic Mode Control Register
 */

#define	NCBIT			0x0400


/*
 * BMCR - Basic Mode Control Register
 */

#define	BMCR_RESET		0x8000
#define	AUTONEGENABLE	0x1000
#define	RESTARTAUTONEG	0x0200

/*
 * BMSR - bit defintions
 */
#define	AUTONEG_COMPLETE	0x0020
//Ramit
#define LINK_STATUS_UP		0x0004

/*
 * KTCR bit definitions.
 */
#define A1000BASETHD    0x00000100  /* Advertise 1000BASE-T Half duplex */
#define A1000BASETFD    0x00000200  /* Advertise 1000BASE-T Full duplex */


/*
 * ANAR - bit definitions.
 */
#define NP				0x8000
#define PAUSE 			0x0400
#define A10BASETHD      0x00000020  /* 10BASE-TX Half Duplex Support */
#define A10BASETFD      0x00000040  /* 10BASE-TX Full Duplex Support */
#define A100BASETHD     0x00000080  /* 100BASE-TX Half Duplex Support */
#define A100BASETFD     0x00000100  /* 100BASE-TX Full Duplex Support */

#define T4              0x00000200  /* 100BASE-T4 Support   */

/* 
 *	ANER Settings 
 */
#define PAGE_RX			0x0002
#define LP_NP_ABLE 		0x0008

/* 
 *	Speed settings 
 */

#define BMCR1000		0x0040
#define BMCR100			0x2000
#define BMCR10			0x0000

#define	PHY_SPEED_MASK  0x0018
#define	PHY_SPEED_10	0x0000
#define	PHY_SPEED_100	0x0008
#define	PHY_SPEED_1000	0x0010

#define	PHY_DUPLEX_MASK 0x0002
#define	PHY_LINK_UP		0x0004


#ifdef PM_WOL

/* Configuration command status register ( CFGCS ) */

#define IOSEN			0x00000001
#define MWIEN			0x00000010
#define SERREN			0x00000100
#define NCPEN 			0x00100000

#define PM_D3C 			0x80000000
#define PM_D3H 			0x40000000
#define PM_D2 			0x20000000
#define PM_D1 			0x10000000
#define PM_D0 			0x08000000

#endif

/*** Define Macros ***/

/*** Typedef Definitions ***/

/*** Global (extern) Data Declarations ***/

/*** Global (extern)Functions Declaration ***/

#endif 

