#!/bin/sh
##########################################################################
#
# dumb_int.sh   version: 1.20
# Copyright(c) 1993.  All Rights Reserved
#
##########################################################################
##########################################################################
#
# Dumb Printer Interface Program  for Printer Server TCP/IP
#
##########################################################################
# Log History:
#   /9/06/93   KMY  Created the program.
#   /12/13/93  KMY  Checked whether the filter program exists.
#   /09/08/94  KMY  Extracted all messages to a procedure.
#
##########################################################################


##############################
#
# strings(): assign values to all strings to be displayed.
#
##############################
strings() {
  Suser="User"
  Sjob="Job"
  Stitle="Title"
  Sdate="Date"
  err_mark="lp: ERROR:"
  err10="cannot execute"
  err20="Interface program got wrong number of arguments."
  err21="           Consult your system adminstrator."
}
##############################
#
# print_banner(): prints the banner page of the print job
#
##############################
print_banner() {
  echo "\n\r\n\r"
  echo "\rXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
  echo "\rXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
  echo "\rXXXXX"
  echo "\rXXXXX      $Suser: $user"
  echo "\rXXXXX      $Sjob:  $job_id"
 
  if [ -n "${title}" ]
  then
     echo "\rXXXXX     $Stitle: $title"
  fi

  echo "\rXXXXX      $Sdate: `date '+%a %H:%M %h %d, 19%y'` "
  echo "\rXXXXX"
  echo "\rXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
  echo "\rXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
  echo "\f\r"
  
}

##############################
#
# print_files(): for each file to be printed, copies it to the standard output
#                for num_of_copy times.
#
##############################
print_files() {
  for file in $files
  do
    i=1
    while [ $i -le $num_of_copy ] 
    do
      cat $file

      # if file break is required, add form feed to the end of each file.
      if [  "${filebreak}" = "yes" ]
      then
        echo "\f\r"
      fi

      # increment i
      i=`expr $i + 1`

    done
  done

}
  
############################################################################
############################################################################
#
# BEGINNING  of  MAIN
#
############################################################################
############################################################################
PATH="/bin:/usr/bin"
export PATH
strings

#############
# traps signals and send error message to the user. Exit_code 129 means the
# occurrence of a printer error
#############
trap 'echo "Dropped connection to the printer; check the status of the printer." >&2
      exit ' 1
trap 'echo "JOB $job_id is interrupted.  The reason is unknown." >&2
      exit' 2 3

##############
#  Job been cancelled. Because we have not done anything, we can just exit.
##############
trap 'exit 0' 15

# define the full path name of the PMfilter program
PMFILTER_CMD="/full_path/PMfilter -D pmti " 

PM_FullPath=`echo "$PMFILTER_CMD" | cut -f1 -d" "`
if [ ! -x $PM_FullPath ]
then
   #echo "$err_mark can't execute ${PM_FullPath}!"  >&2
   echo "$err_mark $err10 ${PM_FullPath}!"  >&2
   exit 1
fi

if [ $# -lt 5 ]
then
  #echo "lp: ERROR: Interface program got wrong number of arguments." >&2
  #echo "           Consult your system adminstrator." >&2
  echo "$err_mark $err20"
  echo "$err21"
  exit 1
fi
  
job_id=$1
user="$2"
#user=`grep "^$2:" /etc/passwd | line | cut -d: -f5`
title=$3
num_of_copy=$4
options=$5
shift 5
files="$*"

banner="yes"
filebreak="yes"

################
# Only nobanner and nofilebreak options are cared.  The other options 
# deal with the printer so we ignore them.
################
for opt in $options
do
case "${opt}" in

  nobanner | nb )
    banner="no";;
 
  nofilebreak | nfb )
    filebreak="no";;
esac
done

##############
# If FILTER is defined by Spooler, we pipe these files and/or banner to the
#  FILTER program and then pipe the output of the FILTER program to PMfilter
#  program.
##############
exit_code=0
if [ ! -z "$FILTER" ]
then

  if [ "${banner}" = "yes" ]
  then
     (print_banner; print_files) | eval $FILTER | eval $PMFILTER_CMD 
     exit_code=$?
  else
     print_files | eval $FILTER | eval $PMFILTER_CMD 
     exit_code=$?
  fi

##############
# If FILTER is not defined by Spooler, we pipe these files and/or banner to the
#  PMfilter program directly.
##############
else
  if [ "${banner}" = "yes" ]
  then
     (print_banner; print_files) | eval $PMFILTER_CMD 
     exit_code=$?
  else
     print_files | eval $PMFILTER_CMD 
     exit_code=$?
  fi

fi

exit $exit_code
