#!/bin/sh
############################################################################
#
# install.sh    version 1.06
# Copyright(c) 1995.  All Rights Reserved.
#
############################################################################
##############################################################################
#
# Installation program for Printer Server TCP/IP
#
# History:
# 09/14/93 KMY -Created the program
# 12/13/93 KMY -Extended the program to SCO 3.2, Sun 4.x, Sun5.x, HP 8.1,
#               AT&T 4.2
# 02/07/94 KMY -Added MIO and PMTI_Jr.
# 03/07/94 KMY -Modified the program to print error message if the UNIX
#               system is not supported.
# 05/20/94 KMY -Supported DEC OSF1, added delay_min option to quick_set and
#               added -T (LF->CR|LF) option.
# 09/14/94 KMY -Modified to use the C compiler on UNIX instead of precompiled
#               PMfilter.
# 09/16/94 KMY -Extracted all display messages to a file.
# 08/04/95 KMY -Modify the display message.
# 09/06/95 KMY -Support port=123S for 3P_1S.
# 06/10/97 LEE -Support port=123 for 3P.
# 10/03/97 LEE -Support port=123 for 3P for quickset .
#
##############################################################################
##############################################################################


########################
# read_in(): echo the question to the screen and read answers from user.
#            It will coutinue looping until user enters the right response.
########################
read_in() {
while  true 
do
  answer=Q
  read answer
  case "$answer" in
      [Qq][Uu][Ii][Tt] )
                      #echo "quit install.sh"
                      echo "$quit_inst"
                      rm -rf $temp_dir
                      exit 0
                         ;;
      *  ) ;; 
  esac

  #if user key in an empty string, ask user to enter again.
  if [ -z "$answer" ]
  then
          echo " "
          echo "$2" 
          echo $n "$enter_again $c" 
          continue 
  else
    
    echo " "
    echo $n "$Sis \"$answer\" ${Scorrect}? $yes_no $c" 
    response=Q
    read response
    case "$response" in
      [Qq][Uu][Ii][Tt] )
                      echo "$quit_inst"
                      rm -rf $temp_dir
                      exit 0
                         ;;
      [Yy]* ) break
              ;;
      * )   
             echo " "
             echo "$2" 
             echo $n "$enter_again $c" 
             continue 
             ;;
      esac
    fi
  done

# scan the command twice before executing it
eval $1=\"$answer\" 
}

##################################
#
# exec_cmd()
#            execute the command passed in and check its return value
#
##################################
exec_cmd() {
eval $command
if [ $? -ne 0 ]
then
  echo " "
  echo "$err_mark $command ${Sfailed}!" 
  rm -rf $temp_dir  
  exit 1
fi 
}


##################################
#
# error_of_unix_type
#   print the error message about the UNIX type that is not supported.
#
##################################
error_of_unix_type() {
uname_all=`uname -a`
echo " "
echo "$err_mark $nonsupport_ux $uname_all" 
#echo "Please read the readme.doc file for further information about "
#echo "manual installation."          
echo "$c40"
echo "$c41"


rm -rf $temp_dir

exit 1
}

##################################
#
## check_unix_type
#  check the unix type of the system and assign the corresponding values
#  to those variables.
#
##################################
#double check the UNIX system
check_unix_type() {
  temp_ux=`uname`
  case "$temp_ux" in
   scosysv ) unix_type=SCO
             interface_arg="/usr/spool/lp/admins/lp/interfaces" 
             model_dir="/usr/spool/lp/model"
             use_interface="yes"
         ;;

   SCO_SV ) unix_type=SCO_SV
             interface_arg="/var/spool/lp/admins/lp/interfaces" 
             model_dir="/var/spool/lp/model"
             use_interface="yes"
         ;;

   HP-UX ) unix_type=HP_UX
           interface_arg="/usr/spool/lp/interface"
           model_dir="/usr/spool/lp/model"
           use_interface="yes"
        ;;

   SunOS )  release=`uname -a | cut -f3 -d" " | cut -c1`
            if [ "$release" = "4" ]
            then
               unix_type=Sun4
               use_interface="no"
               LPC="/usr/etc/lpc"
            else
               unix_type="Sun5"
               interface_arg="/etc/lp/interfaces"
               model_dir="/etc/lp/model"
               use_interface="yes"
            fi 
           ;;
   UNIX_SV )
               unix_type="AT_and_T"
               interface_arg="/etc/lp/interfaces"
               model_dir="/etc/lp/model"
               use_interface="yes"
           ;;
   OSF1 )
           unix_type="DEC_OSF1"
           use_interface="no"
           LPC="/usr/sbin/lpc"
           ;;
 
     * ) 
               error_of_unix_type
       ;;
  esac

  if [ "$unix_type" = Sun4 -o "$unix_type" = DEC_OSF1 ]
  then
      if [ ! -x $LPC ]
      then
         error_of_unix_type
      fi 
  else
     if [ ! -d $interface_arg -o ! -d $model_dir ] 
      then
         error_of_unix_type
      fi 
  fi

}
##################################
#
# assign_var_for_quickset()
#
##################################
assign_var_for_quickset() {


  if [ "$use_interface" = "yes" ]
  then
    if [ -f "${interface_arg}/$printer_name" ]
    then
      echo "$err_mark $Sprt $printer_name $exist_already"
      rm -rf $temp_dir
      exit 1
    fi
  else
    if grep "^$printer_name" /etc/printcap > /dev/null 2>&1
    then
      echo "$err_mark $Sprt $printer_name $exist_already"
      rm -rf $temp_dir
      exit 1
    fi
 fi

  if  grep "	$host_name" $HOSTS > /dev/null 2>&1 
  then
   :
  else
    if  grep " $host_name" $HOSTS > /dev/null 2>&1 
    then 
       :
    else 
      #echo "$err_mark $OEM_mark $Shost $host_name isn't in /etc/hosts!"
      echo "$err_mark $OEM_mark $Shost $host_name $c50"
      rm -rf $temp_dir
      exit 1
   fi
  fi

if [ "$support_3P1S" = "no" ]
then 
  if [ "$port" -ne 1 -a "$port" -ne 2  -a "$port" -ne 3 ]
  then
    #echo "$err_mark printer port must be 1, 2 or 3."
    echo "$err_mark $c60"
    rm -rf $temp_dir
    exit 1
  fi
else
  if [ "$port" -ne 1 -a "$port" -ne 2  -a "$port" -ne 3 -a "$port" != "s" ]
  then
    #echo "$err_mark printer port must be 1, 2, 3 or s."
    echo "$err_mark $c61"
    rm -rf $temp_dir
    exit 1
  fi
fi

  if [ ! -f "$filter_cmd" ]
  then
    echo "$err_mark $filter_cmd $dont_exist"
    rm -rf $temp_dir
    exit 1
  fi

  if [ ! -x "$filter_cmd" ]
  then
    echo "$err_mark $filter_cmd $isnt_exec"
    rm -rf $temp_dir
    exit 1
  fi

  if [ "$use_interface" = "yes" ]
  then
    if [ "$stdintf" = "yes" ]
    then
      INTERFACE=`pwd`
      INTERFACE="${INTERFACE}/dumb_int.sh"
    else
      INTERFACE="${model_dir}/$model"
    fi
    
    if [ ! -f "$INTERFACE" ]
    then
        echo "$err_mark $INTERFACE $dont_exist"
        rm -rf $temp_dir
        exit 1
    fi

  fi

  if [ "$use_filter" = yes ]
  then
    if [ ! -f "$PRINT_FILTER" ]
    then
        echo "$err_mark $PRINT_FILTER $dont_exist"
        rm -rf $temp_dir
        exit 1
    fi
  fi


  auto_send="no"
  send_str="no"
  send_file="no"
}


#########################################
#process_filter_cmd_options
#########################################
process_filter_cmd_options() {
#-D <destination> option
filter_cmd="${filter_cmd} -D $host_name"

#-S, -H options 
if [ "$support_3P1S" = "no" ]
then
  case "$port" in
    2 ) filter_cmd="${filter_cmd} -P"
      ;;
    3 ) filter_cmd="${filter_cmd} -S"
      ;;
    * ) ;;
  esac
else
   filter_cmd="${filter_cmd} -o $port"
fi

#-p <prestring>, -s <sufstring> options
if [ "$send_str" = "yes" ]
then
  if [ "$prestr" != "" ]
  then
     filter_cmd="${filter_cmd} -p '${prestr}'"
  fi

  if [ "$sufstr" != "" ]
  then
     filter_cmd="${filter_cmd} -s '${sufstr}'"
  fi
fi

# -h <headfile>, -t <tailfile> options
if [ "$send_file" = "yes" ]
then
  if [ "$headfile" != "" ]
  then
     filter_cmd="${filter_cmd} -h ${headfile}"
  fi

  if [ "$tailfile" != "" ]
  then
     filter_cmd="${filter_cmd} -t ${tailfile}"
  fi
fi

# -a <other_ports> options
if [ "$auto_send" = "yes" ]
then
   if [ "$support_3P1S" = "no" ]
   then
     filter_cmd="${filter_cmd} -a $another_port"
   else
     filter_cmd="${filter_cmd} -r $another_port"
   fi 
fi

# -d <delay_min> option
if [ "$delay_changed" = "yes" ]
then
   filter_cmd="${filter_cmd} -d $delay_min"
fi


# -T <text_mode> option 
if [ "$text_mode" = "yes" ]
then
   filter_cmd="${filter_cmd} -T"
fi



# print the  whole command line to the screen
echo " "
#echo "The FILTER Command used in Interface program is "
echo "$c70"
echo " $filter_cmd"
echo " "

}
#####################################################################
# check_delay_min()
#
#####################################################################
check_delay_min() {

  echo "$delay_min" | grep "^.[0-9]*$" > /dev/null
  if [ $? = 0 ]
  then
    echo "$delay_min" | grep "^[0-9]*$" > /dev/null
    if [ $? != 0 ]
    then
      echo "$delay_min" | grep "^-[0-9]*$" > /dev/null
      if [ $? != 0 ]
      then
        error_delay_min=yes
      else
         error_delay_min=no
      fi
    else  
      error_delay_min=no
    fi
  else
    error_delay_min=yes
  fi
                       
}

##############################################################################
# invoke_mycc():check that errormsg.h and pmfilter.c are in the source directory
#              and then invoke mycc to compile pmfilter.c.
##############################################################################
invoke_mycc() {

 if [ ! -f "${source_dir}/errormsg.h" -o ! -f "${source_dir}/$program_source" ]
   then
     clear
     while true 
     do
       echo " "
       #"Enter the directory containing pmfilter.c and errormsg.h."
       echo "$dir_pmc_errh =>"
       read_in temp_sdir "$dir_pmc_errh"
       if [ -f "${temp_sdir}/errormsg.h" -a -f "${temp_sdir}/$program_source" ]
       then
         curr_dir=`pwd`
         cd $temp_sdir
         source_dir=`pwd`
         cd $curr_dir
         break
       else
         echo " "
         echo "$err_mark $errh_pmc_not_in $temp_sdir" 
         echo " "
       fi
     done
   fi

    filter_cmd="${source_dir}/${program_mark}"
    chmod 444 ${source_dir}/errormsg.h 
    chmod 644 ${source_dir}/$program_source 
    if [ -f ./mycc ]
    then
      chmod +x ./mycc
      ./mycc "$1" "$source_dir"
      if [ $? != 0 ]
      then
        echo " "
        echo "$err_mark $mycc_fail"
        rm -rf $temp_dir
        exit 1
      else
        echo " "
        echo "$press_to_cont"
        read dumb
       fi 
    else
      echo " "
      echo "$err_mark ./mycc $dont_exist"
      rm -rf $temp_dir
      exit 1
    fi
}
##############################################################################
# process_reroute_ports()
##############################################################################
process_reroute_ports() {
  another_port=""
  for p in $reroute_ports
  do
     case "$p" in
     1* ) 
          another_port="${another_port}1" 
          ;;
     2* ) 
          another_port="${another_port}2" 
          ;;
     3* ) 
          another_port="${another_port}3" 
          ;;
     S* | s* )
          another_port="${another_port}s" 
          ;;
     * )
        reroute_correct=no
        break
        ;;
    esac
  done
}
##############################################################################
##############################################################################
#
# begin of main
#
##############################################################################
##############################################################################
set -u
PATH="/bin:/usr/bin:/usr/ucb:/usr/etc:$PATH"
export PATH

err_mark="install.sh: ERROR:"
OEM_mark="Print_Server"
program_mark="PSfilter"
program_source="psfilter.c"
OPT_file=".psopts"
if [ -f ./instmsgs ]
then
  chmod +x ./instmsgs
  . ./instmsgs
else
  echo "$err_mark cannot find ./instmsgs!"
  exit 1
fi

if [ "$OEM_mark" = "LANpress" ]
then
   support_3P1S=yes
else
   support_3P1S=yes
fi

# Check the user  who runs the program is root   
user=`logname`
if [ "${user}" != "root" ]
then
#  echo "$err_mark only root has the privilege to run install.sh."
#  echo "                   Login as root and try again!"
   echo "$err_mark $c80"
   echo "$c81"
  exit 1
fi

usage1="Usage: install.sh printer_name ${OEM_mark}_name"
usage2="       [pn=port_num] [im=interface_model] [d=delay_min] [text]"
usage2s="       [port=port_num] [im=interface_model] [d=delay_min] [text]"
arg_num=$#
if [ "$arg_num" -eq 0 ]
then
  quick_set="no"
else
   if [ "$arg_num" -ge 2 -a "$arg_num" -le 6  ]
   then
   quick_set="yes"
   printer_name="$1"
   host_name="$2"
   if [ -z "$printer_name" -o -z "$host_name" ]
   then
       if [ "$OEM_mark" = "LANpress" ]
       then
             echo "$usage1"
             echo "$usage2s"
              exit 1
       else 
             echo "$usage1"
             echo "$usage2"
              exit 1
      
       fi
     fi
     shift
     shift
     use_filter=no
     port=1
     stdintf="yes"
     delay_changed=no
     delay_min=-1
     text_mode=no
     model=""
     if [ "$arg_num" -ne 2  ]
     then 
       for i in $*
       do
          case "$i" in 
            pn=* )  port=`expr "$i" : '.*=\(.*\)'`
                    case "$port" in
                     1 | 2 | 3 | s | S) ;;
                      * )
                         #echo "Port number must be 1, 2 or 3 or s."
                         echo "$err_mark $c92"
                         exit 1
                         ;;
                    esac
                  ;;
            port=* )  port=`expr "$i" : '.*=\(.*\)'`
                    case "$port" in
                     1 | 2 | 3 | s | S ) ;;
                      * )
                         #echo "Port number must be 1, 2, 3 or s."
                         echo "$err_mark $c93"
                         exit 1
                         ;;
                    esac
                  ;;
            im=* )  model=`expr "$i" : '.*=\(.*\)'`
                    stdintf="no"
                    if [ -z "$model" ]
                    then
                       #echo "$err_mark im=interface_model must be a file name."
                       echo "$err_mark $c90"
                       exit 1
                    fi
                  ;;
            d=* )  delay_min=`expr "$i" : '.*=\(.*\)'`
                   check_delay_min  
                 
                   if [ "$error_delay_min" = yes ]
                   then
                            #echo "$err_mark d=delay_min must be an integer."
                            echo "$err_mark $c91"
                            exit 1
                   fi
                   delay_changed="yes"
                   ;;
            [Tt][Ee][Xx][Tt] )
                              text_mode=yes
                              ;;
            * ) echo "$usage1"
                if [ "$support_3P1S" = "no" ]
                then
                  echo "$usage2"
                else
                  echo "$usage2s"
                fi
                exit 1
                break
                ;;
          esac  
       done
     fi
   else
       echo "$usage1"
       if [ "$support_3P1S" = "no" ]
       then
            echo "$usage2"
       else
            echo "$usage2s"
       fi
       exit  1
   fi
fi

#cat << EOF_EOF
#-----------------------------------------------
#|  install.sh    version 1.04                 |
#|  Copyright(c) 1995.  All Rights Reserved.   |
#-----------------------------------------------
#EOF_EOF
echo "$copyright1"
echo "$copyright2"
echo "$copyright3"
echo "$copyright4"

#echo "Processing..."
echo "$Sprocessing"
echo " "


if [ ! -f /etc/hosts ]
then
  #echo "$err_mark the file /etc/hosts doesn't exist!"
  echo "$err_mark $d10"
  exit 1
fi

temp_dir="/tmp/PM_dir_$$"

if [ ! -w /tmp ]
then
  chmod a+w /tmp
fi

if [ ! -r /tmp ]
then
  chmod a+r /tmp
fi

#if signals got, clear off the temp_dir we made.
trap "rm -rf $temp_dir; exit 1" 1 2 3 15

mkdir $temp_dir 2>/dev/null

# if mkdir failed
if [ $? != 0 ]
then
  echo " "
  #echo "$err_mark can't create working directory ${temp_dir}."
  echo "$err_mark $d20 ${temp_dir}."
  exit 1
fi

# preprocess the /etc/hosts file to filter out comments
HOSTS=$temp_dir/temp_hosts
touch $HOSTS
chmod  u+rw $HOSTS
grep -v "^#" /etc/hosts > $HOSTS

 # add read, write and execute permissions to user
 chmod u+rwx $temp_dir


# Check whether compile pmfilter.c or not?
# if ./PMTI/LPsource/PMfilter doesn't exit, pmfilter.c will be compiled.
curr_dir=`pwd`
source_dir="${curr_dir}/LPsource"
filter_cmd="${source_dir}/$program_mark"
if [ -f $filter_cmd -a -x $filter_cmd ]
then
  chmod 755 $source_dir
  chmod 555 $filter_cmd
  to_compile_pm=no
else
  to_compile_pm=yes
fi


echo "xxxx\c" > $temp_dir/echo_test
if grep "c" $temp_dir/echo_test > /dev/null 2>&1
then
   n="-n"
   c=""
else
   n=""
   c="\c"
fi



if [  "$quick_set" = "yes" ]
then
  unix_type="unknown"
  check_unix_type
  if [ "$unix_type" = DEC_OSF1 ]
  then
    if [ ! -z "$model" ]
    then
      use_filter=yes
      PRINT_FILTER="/usr/lbin/$model"
    else
      use_filter=no
    fi
  fi
  if [ "$to_compile_pm" = yes ]
  then
    ux_os=`uname`
    invoke_mycc "$ux_os"
  fi
  assign_var_for_quickset
fi


if [ "$quick_set" = "no" ]
then

# clear the screen

clear

#show message on the screen
#cat  << EOF_EOF
#  This shell program installs the $OEM_mark host software to 
#  add those printers that are attached to the $OEM_mark 
#  to the UNIX system.
#
#EOF_EOF
echo "$a10"
echo "$a11"
echo " "
echo "$type_quit"
echo " "
echo " "

while true
do
#cat  << EOF_EOF
# Which one of the following $OEM_mark types to be installed:
#  1. $OEM_mark      -- 3 printer ports.
#  2. ${OEM_mark}-Jr   -- 1 printer port
#  3. ${OEM_mark}-MIO. -- 2 printer ports
#EOF_EOF
if [ "$OEM_mark" != "LANpress" ]
then
  echo "$a20"
  echo "$a21"
  echo "$a22"
  echo "$a23"
  echo "$a24"
else
  echo "$L20"
  echo "$L21"
  echo "$L22"
  echo "$L23"
fi

echo $n "$choose_num =>$c"  
read_in device_type "$choose_num"
case "$device_type" in
 1 )
     device_type=dev3
     break
     ;;
 2 )
     device_type=dev1
     break
     ;;
 3 )
     if [ "$OEM_mark" != "LANpress" ]
     then
       device_type=dev2
       break
     else 
       device_type=dev4
       break
     fi
     ;;
 4 )
     support_3P1S=yes
     device_type=dev5
     break
     ;;
 * )
     echo " "
     echo "$err_mark $bad_choice"
     echo " "
     continue
     ;;
 esac 
done

clear
#cat  << EOF_EOF
# The program will ask you the following questions:
# 1. The type of UNIX system.
# 2. Printer Name. (e.g. NetPrinter)
# 3. Host name of the $OEM_mark device (e.g. PrtHost)
# 4. The full path of the directory containing the $program_mark program.
#    (e.g. /usr/local/bin)
# 5. Is strings to be sent before and/or after a print job?
# 6. Is files to be sent before and/or after a print job?
# 7. How many minutes is allowed for occurrence of printer faults before
#    the active print job is aborted ?  (the default value is infinite minutes.)
#    NOTE: 0 means that the print request will abort upon printer faults.
#         -1 (or negative number) means that infinite delay is allowed.
# 8. Is Line Feed to be converted to Carriage Return + Line Feed? (LF->CR+LF)
#EOF_EOF
echo "$a30"
echo "$a31"
echo "$a32"
echo "$a33"
echo "$a34"
echo "$a35"
echo "$a36"
echo "$a37"
echo "$a38"
echo "$a39"
echo "$a40"

if [ "$device_type" != "dev1" ]
then

#  if [ "$device_type" = "dev3" ]
#  then

#cat  << EOF_EOF
# 9. Which port of the $OEM_mark is the printer to be connected to?
#    1.)High speed parallel port 1.  2.)Parallel port 2.  3.) Serial port
#EOF_EOF
echo "$a50"
echo "$a51"

#  else

#cat  << EOF_EOF
# 9. Which port of the $OEM_mark is the printer to be connected to?
#    1.) MIO port 1.  2.) Serial port
#EOF_EOF
#echo "$a60"
#echo "$a61"


#  fi

#cat  << EOF_EOF
# 10. Is the print job to be automatically sent to another printer
#    connected to the $OEM_mark while the selected printer is busy?
#    NOTE: These printers must be of the same class.
#
#                  [ press RETURN to continue ]
#EOF_EOF
echo "$a70"
echo "$a71"
echo "$a72"
echo " "
echo "$press_to_cont"

else
   echo " "
   #echo "                  [ press RETURN to continue ]"
   echo "$press_to_cont"
 fi

#wait for user's pressing any key 
read dumb

# clear the screen
clear

#show message on the screen
#cat  << EOF_EOF
# The program will add the printer to the UNIX system automatically.  
# The printer can be used after the install.sh program has finished if
# the printer have been connected to the $OEM_mark correctly 
# and set its IP address already.
#
# Type quit or QUIT to exit install.sh
#
#                   [ press RETURN to continue ]
#EOF_EOF
#echo "$a80"
#echo "$a81"
#echo "$a82"
#echo "$a83"
#echo "  "
#echo "$type_quit"
#echo "  "
#echo "$press_to_cont"

#wait for user's pressing any key 
#read dumb

while true
do
# clear the screen
clear

#############
# read unix_type
#############
#cat  << EOF_EOF
# Choose the type of the UNIX system: 
# 1.SCO UNIX 3.2 i386
# 2.Hewlett Packard HP-UX 9.03 and higher; model 720
# 3.SunOS 4.x sparc
# 4.SunOS 5.x sparc
# 5.AT&T UNIX_SV release 4, 386/AT
# 6.DEC 3000 OSF1 version 1.3 and higher, alpha
# 7. UNIXWare versino 2.01 and higher
# 8. SCO UNIX Open Server ver 5.x
# 9.Others
#EOF_EOF
echo "$a90"
echo "$a91"
echo "$a92"
echo "$a93"
echo "$a94"
echo "$a95"
echo "$a96"
echo "$a97"
echo "$a98"
echo "$a99"
echo $n " =>$c"  

 read_in unix_type "$a90"

  case "$unix_type" in
    1 ) 
        use_interface="yes"
        interface_arg="/usr/spool/lp/admins/lp/interfaces" 
        model_dir="/usr/spool/lp/model"
        ux_os=scosysv
        unix_type=SCO
         ;;
    2 )
        use_interface="yes"
        interface_arg="/usr/spool/lp/interface"
        model_dir="/usr/spool/lp/model"
        ux_os=HP_UX
        unix_type="HP_UX"
         ;;
    3 )
        use_interface="no"
        unix_type=Sun4
        LPC="/usr/etc/lpc"
        ux_os=Sun4
         ;;
    4 )
        use_interface="yes"
        interface_arg="/etc/lp/interfaces"
        model_dir="/etc/lp/model"
        unix_type=Sun5
        ux_os=Sun5
         ;;
    5 | 7  )
        use_interface="yes"
        interface_arg="/etc/lp/interfaces"
        model_dir="/etc/lp/model"
        unix_type=AT_and_T
        ux_os=UNIX_SV
         ;;
    6 )
        use_interface="no"
        unix_type=DEC_OSF1
        LPC="/usr/sbin/lpc"
        ux_os=OSF1
        ;;
    8 ) 
        use_interface="yes"
        interface_arg="/var/spool/lp/admins/lp/interfaces" 
        model_dir="/var/spool/lp/model"
        ux_os=UNIX_SV
        unix_type=SCO_SV
         ;;

    * ) 
         error_of_unix_type
         ;;
  esac
  if [ "$unix_type" = Sun4 -o "$unix_type" = DEC_OSF1 ]
  then
      if [  -x $LPC ]
      then
        break
      fi 
  else
     if [ -d $interface_arg -a -d $model_dir ] 
      then
        break
      fi 
  fi


  echo " "
  #echo "$err_mark  Wrong type of UNIX system!"
  echo "$wrong_ux"
  echo " "
  # echo "                  [ press RETURN to continue ]"
  echo "$press_to_cont"

   #wait for user's pressing any key 
   read dumb
done


####### Invoke mycc to compile pmfilter.c if needed
if [ "$to_compile_pm" = yes ]
then
  invoke_mycc "$ux_os"
fi


while true
do

#initialize variables
port=1
auto_send=no
prestr=""
sufstr=""
headfile=""
tailfile=""
delay_min=-1
text_mode=no
use_filter=no


# clear the screen
clear

#############
# read printer_name
#############
  echo $n "$enter_prt =>$c" 
  read_in  printer_name "$enter_prt"

  if [ "$use_interface" = "yes" ]
  then
     while true
     do  
       if [ -f "${interface_arg}/$printer_name" ]
       then
         echo " "
         echo "$err_mark $Sprt $printer_name $exist_already!"
         echo " "
         echo $n "$enter_prt_agn =>$c" 
         read_in  printer_name "$enter_prt"
       else
         interface_arg=${interface_arg}/$printer_name
         break
       fi
     done
  else
     while true
     do  
       if grep "^$printer_name" /etc/printcap > /dev/null 2>&1
       then
         echo " "
         echo "$err_mark $Sprt $printer_name $exist_already"
         echo " "
         echo $n "$enter_prt_agn =>$c" 
         read_in  printer_name "$enter_prt"
       else
         break
       fi
     done
  fi
     

# clear the screen
clear

#############
# read and check host_name
#############
  while true
  do
    #echo $n "Enter the host name of the $OEM_mark device =>$c" 
    echo $n "$enter_ps =>$c" 
    read_in host_name "$enter_ps"

    # Don't let any output and error message for grep command go to screen.
    if  grep "	$host_name" $HOSTS > /dev/null 2>&1 
    then
      break 
    else
      if  grep " $host_name" $HOSTS > /dev/null 2>&1 
      then 
         break 
      else
         echo " "
         #echo "$err_mark the host name of the $OEM_mark \"$host_name\" is not in file /etc/hosts."
         echo "$err_mark $d30 \"$host_name\" $d31"
         echo " "
      fi
    fi
  done

#############
# read and check the full path of ${program_mark}
#############
  #get current  directory
  curr_dir=`pwd`

  #check if the ${program_mark} program is in the $unix_type subdirectory
  work_dir="$source_dir"


  if [ ! -x "${work_dir}/${program_mark}" ]
  then

# clear the screen
clear

    while true 
    do
#cat  << EOF_EOF
#Enter the full path of the directory containing the $program_mark program 
#EOF_EOF
echo "$b10"
echo $n "=>$c"

b10_readin="$b10 $program_mark"
read_in work_dir "$b10_readin"

      if [ -d "$work_dir" ]
      then
         if [ -f "${work_dir}/${program_mark}" ]
         then
           if [ ! -x "${work_dir}/${program_mark}" ]
           then
             echo " "
             echo "$err_mark  ${program_mark} $prg_non_exec"
             echo " "
           else
             break
           fi
         else
           echo " "
           echo "$err_mark  $program_mark $isnt_in $work_dir ."
           echo " "
         fi
     else
         echo " "
         echo "$err_mark $sw_dir $work_dir $dont_exist"
         echo " "
     fi
   done
 fi

 #Now, we got the full path of ${program_mark} program
 filter_cmd="${work_dir}/${program_mark}"


if [ "$device_type" = "dev3" ]
then

 # clear the screen
 clear

########################
# read port number for PMTI with 3 printer ports
########################
  # read port number until a correct one is selected
  while true
  do
#cat  << EOF_EOF
#Which port of the $OEM_mark is the printer to be connected to?
# 1. High speed parallel port 1
# 2. Parallel port 2
# 3. Serial port 
# (Default is high speed parallel port 1.)
#EOF_EOF
echo " "
echo "$b20"
echo "$b21"
echo "$b22"
echo "$b23"
echo "$b24"
echo $n "$choose_num =>$c"

read_in port  "$choose_prt_port"

    # only 1, 2 and 3 are valid
    if [ "$port" != 1 -a "$port" != 2 -a "$port" != 3 ]
    then
      echo " "
      echo "$err_mark $bad_choice"
      echo " "
    else
      if [ "$port" = 3 -a "$support_3P1S" = yes ]
      then
        port=s
      fi
      break
    fi
  done
fi    

if [ "$device_type" = "dev2" ]
then
################################
# read port number for PMTI with 2 printer ports
################################
  # read port number until a correct one is selected
  while true
  do
#cat  << EOF_EOF
#Which port of the $OEM_mark is the printer to be connected to?
# 1. MIO port 
# 2. Serial port 
# (Default is MIO port.)
#EOF_EOF
echo " "
echo "$b30"
echo "$b31"
echo "$b32"
echo "$b33"
echo $n "$choose_num =>$c"
read_in port  "$choose_prt_port"

    # only 1 and 2 are valid
    if [ "$port" != 1 -a "$port" != 2 ]
    then
      echo " "
      echo "$err_mark $bad_choice"
      echo " "
    else
      if [ "$port" = 2 -a "$support_3P1S" = yes ]
      then
        port=s
      fi
      if [ "$port" = 2 -a "$support_3P1S" = no ]
      then
         port=3
      fi
      break
    fi
  done
fi

if [ "$device_type" = dev4 ]
then
  # device_type = dev4
  # read port number until a correct one is selected
  while true
  do
#cat  << EOF_EOF
#Which port of the $OEM_mark is the printer to be connected to?
# 1. Parallel port 1
# 2. Parallel port 2
# 3. Parallel port 3
# 4. Serial port 
# (Default is high speed parallel port 1.)
#EOF_EOF
echo " "
echo "$b34"
echo "$b35"
echo "$b36"
echo "$b37"
echo "$b38"
echo "$b39"
echo $n "$choose_num =>$c"

read_in port  "$choose_prt_port"

    # only 1, 2, 3 and 4 are valid
    if [ "$port" != 1 -a "$port" != 2 -a "$port" != 3 -a "$port" != 4 ]
    then
      echo " "
      echo "$err_mark $bad_choice"
      echo " "
    else
      if [ "$port" = 4 ]
      then
         port=s
      fi
      break
    fi
  done
fi

if [ "$device_type" = dev5 ]
then
  # device_type = dev5
  # read port number until a correct one is selected
  while true
  do
#cat  << EOF_EOF
#Which port of the $OEM_mark is the printer to be connected to?
# 1. Parallel port 1
# 2. Parallel port 2
# 3. Parallel port 3
# (Default is high speed parallel port 1.)
#EOF_EOF
echo " "
echo "$b34"
echo "$b35"
echo "$b36"
echo "$b37"
echo "$b39"
echo $n "$choose_num =>$c"

read_in port  "$choose_prt_port"

    # only 1, 2, 3 are valid
    if [ "$port" != 1 -a "$port" != 2 -a "$port" != 3 ]
    then
      echo " "
      echo "$err_mark $bad_choice"
      echo " "
    else
      break
    fi
  done
fi

if [ "$device_type" != dev1 ]
then

# clear the screen
clear

#############
# read and check auto_sending
#############
#cat  << EOF_EOF
#Is the print job to be automatically sent to another printer
#connected to the $OEM_mark while the selected printer is busy? 
#EOF_EOF
echo "$b40"
echo "$b41"
echo $n "$yes_no $c"

read_in auto_send "${b40}?"

  case "$auto_send" in
    [Yy]* )  auto_send="yes"
             ;;
     * )  auto_send="no"
             ;;
  esac

if [ "$auto_send" = "yes" ]
then

#######################################
#  auto_sending for PMTI with 3 printer ports
#######################################
if [ "$device_type" = "dev3" ]
then
             while true
             do
#cat  << EOF_EOF
#
#Select one of the following port for auto sending:
# 1. High speed parallel port 1
# 2. Parallel port 2
# 3. Serial port
# 4. The other two ports
#EOF_EOF
echo " "
echo "$b50"
echo "$b51"
echo "$b52"
echo "$b53"
echo "$b54"

echo $n "$choose_num =>$c"
#read_in another_port "choose a port for auto sending"
read_in another_port "$choose_autosend_port"

               # another_port is any other port but the port which the printer
               #  connected to.
               if [ "$another_port" = "$port" ]
               then
                 echo " "
                 #echo "$err_mark Bad Choice: choose any ports other than the selected one."
                 echo "$err_mark $d40"
                 echo " "
                 continue
               else 
                 case "$another_port" in
                   1 ) 
                       if [ "$support_3P1S" = "no" ]
                       then
                          another_port=para1
                       else
                          another_port=1
                       fi
                       break
                       ;;
                   2 ) 
                       if [ "$support_3P1S" = "no" ]
                       then
                          another_port=para2
                       else
                          another_port=2
                       fi
                       break
                       ;;
                   3 ) 
                       if [ "$support_3P1S" = "no" ]
                       then
                          another_port=serial
                       else
                          another_port=s
                       fi
                       break
                       ;;
                   4 ) 
                       if [ "$support_3P1S" = "no" ]
                       then
                          another_port=all
                       else
                          another_port=12s
                       fi
                       break
                       ;;
                   * ) echo " "
                       echo "$bad_choice"
                       contiune
                    ;;
                 esac
                fi  
             done
fi

if [ "$device_type" = "dev2" ]
then
#######################################
#  auto_sending for PMTI with 2 printer ports
#######################################
  if [ "$port" = 3 ]
  then
    if [ "$support_3P1S" = "no" ]
    then
      another_port=para1
    else
      another_port=1
    fi
  else 
    if [ "$support_3P1S" = "no" ]
    then
      another_port=serial
    else
      another_port=s
    fi
  fi
fi


if [ "$device_type" = dev4 ]
then
# device_type = dev4
             while true
             do
#cat  << EOF_EOF
#
#Select a combination of the following ports for auto rerouting:
#There must be a space between any two port numbers.
#(e.g. 1 2 3;  2 3 4;  2 4;  1 3;  1;  3;   ...etc)
# 1. Parallel port 1
# 2. Parallel port 2
# 3. Parallel port 3
# 4. Serial port
#EOF_EOF
echo " "
echo "$b61"
echo "$b62"
echo "$b63"
echo "$b64"
echo "$b65"
echo "$b66"
echo "$b67"

echo $n "$b68 $c"
#read_in another_port "choose a port for auto sending"
read_in reroute_ports "$b68"
     reroute_correct=yes
     process_reroute_ports
     if [ "$reroute_correct" = "no" ]
     then
       echo " "
       echo "$err_mark $bad_choice"
       continue
     else
       break
     fi
     done
# end dev4
fi

if [ "$device_type" = dev5 ]
then
# device_type = dev5
             while true
             do
#cat  << EOF_EOF
#
#Select a combination of the following ports for auto rerouting:
#There must be a space between any two port numbers.
#(e.g. 1 2 3;  2 3 4;  2 4;  1 3;  1;  3;   ...etc)
# 1. Parallel port 1
# 2. Parallel port 2
# 3. Parallel port 3
#EOF_EOF
echo " "
echo "$b61"
echo "$b62"
echo "$b631"
echo "$b64"
echo "$b65"
echo "$b66"

echo $n "$b68 $c"
#read_in another_port "choose a port for auto sending"
read_in reroute_ports "$b68"
     reroute_correct=yes
     process_reroute_ports
     if [ "$reroute_correct" = "no" ]
     then
       echo " "
       echo "$err_mark $bad_choice"
       continue
     else
       break
     fi
     done
# end dev5
fi

# end autosend=yes
fi 

# end device_type != dev1
fi


# clear the screen
clear

#############
# read pre/suf strings
#############
#cat  << EOF_EOF
#Are strings to be sent before and/or after the print job?
#EOF_EOF
echo "$b60"
echo $n "$yes_no $c"
read_in send_str "$b60"

case "$send_str" in
    [Yy]* )
            send_str="yes"
            ;;
    * ) send_str="no"
            ;;
esac


if [ "$send_str" = "yes" ]
then
            echo " " 
           #echo $n "Is prefix string to be sent before print job? (Yes/No)=>$c"
           echo $n "$d50 $yes_no $c"
            read_in pres_sent  "$d50"
            case "$pres_sent" in
            [Yy]* ) pres_sent=yes
                    ;;
            * ) prestr=""
                pres_sent=no
                ;;
             esac
 
            if [ "$pres_sent" = "yes" ]
            then
#cat  << EOF_EOF
#
#Enter the prefix string to be sent before print job.
#EOF_EOF
echo " "
echo "$b70"
echo $n "$dont_quotes =>$c"
#read_in prestr "Enter the prefix string to be sent before print job.(Don't use quotes.)"
    
dont_quote_readin="$b70 $dont_quotes"
read_in prestr "$dont_quote_readin"
            fi



            echo " " 
            #echo $n "Is suffix string to be sent after print job? (Yes/No)=>$c"
            echo $n "$d60 $yes_no $c"
            read_in sufs_sent "$d60"
            case "$sufs_sent" in
            [Yy]* ) sufs_sent=yes
                    ;;
            * ) sufstr=""
                sufs_sent=no
                ;;
             esac
 
   
            if [ "$sufs_sent" = "yes" ]
            then
#cat  << EOF_EOF
#
#Enter the suffix string to be sent after print job.
#EOF_EOF
echo " "
echo "$b80"
echo $n "$dont_quotes =>$c"
sufstr_readin="$b80 $dont_quotes"
#read_in sufstr "Enter the suffix string to be sent after print job.(Don't use quotes.)"
read_in sufstr "$sufstr_readin"

        fi
fi 


# clear the screen
clear

#############
# read and check head/tail files
#############
#cat  << EOF_EOF
#Are files to be sent before and/or after the print job? 
#EOF_EOF
echo "$b90"
echo $n "$yes_no $c"
read_in send_file "$b90" 

  case "$send_file" in
  [Yy]* ) send_file=yes
          ;;
    * ) send_file="no"
          ;;
  esac

 if [ "$send_file" = "yes" ]
 then

  #clear the screen
  clear

#############
# read and check head files
#############

#echo $n "Is head file to be sent before print job? (Yes/No) =>$c"
echo $n "$d70 $yes_no $c"
read_in hf_sent  "$d70"
case "$hf_sent" in
[Yy]* ) hf_sent=yes
       ;;
* )
  hf_sent=no
  headfile=""
       ;;
esac


if [ "$hf_sent" = "yes" ]
then
  while true
  do
#cat  << EOF_EOF
#
#Enter the full path of the head file to be sent before print job.
#EOF_EOF
echo " "
echo "$b91"
echo $n "=>$c"
read_in headfile "$b91"
    
    #verify the head/tail files are readable
    is_error=no
    if [  "$headfile" = "" ]
    then
      break
    else
       if  [ ! -f "$headfile" ]     
       then
         echo " "
         #echo "$err_mark No such file $headfile . "
         echo "$err_mark $no_file $headfile . "
         echo " "
         is_error=yes
       else
         if  [ ! -r "$headfile" ]     
         then
           echo " "
           #echo "$err_mark  $headfile is not readable."
           echo "$err_mark  $headfile $isnt_read"
           echo " "
           is_error=yes
         fi
       fi
       if [ "$is_error" = "no" ]
       then
          break
       fi
    fi
  done
fi

# clear the screen
clear
#############
# read and check tail files
#############
#echo $n "Is tail file to be sent after print job? (Yes/No) =>$c"
echo $n "$d80 $yes_no $c"
read_in tf_sent "$d80"
case "$tf_sent" in
[Yy]* ) tf_sent=yes
      ;;
* ) tailfile=""
    tf_sent=no
      ;;
esac

if [ "$tf_sent" = "yes" ]
then
  while true
  do
#cat  << EOF_EOF
#
#Enter the full path of the tail file to be sent after print job.
#EOF_EOF
echo " "
echo "$b92"
echo $n " =>$c"
read_in tailfile "$b92"

    if [  "$tailfile" = "" ]
    then
      break
    else  
       is_error=no
       if  [ ! -f "$tailfile" ]     
       then
          echo " "
          #echo "$err_mark No such file $tailfile ."
          echo "$err_mark $no_file $tailfile ."
          echo " "
          is_error=yes
       else 
         if  [ ! -r "$tailfile" ]     
         then
            echo " "
            echo "$err_mark  $tailfile $isnt_read"
            echo " "
            is_error=yes
         fi
       fi
       if [ "$is_error" = "no" ]
       then
         break
       fi
   fi
done

fi
fi

# clear the screen
clear

#############
# read delay minutes for prointer I/O error
#############
#cat  << EOF_EOF
#Is the number of delay minutes allowed for printer faults to be changed? (Default is infinite (-1) ) 
#EOF_EOF
echo "$c10"
echo "$c101"
echo $n "$number $c"
#read_in delay_changed "Is the number of delay minutes allowed for pirnter faults to be changed? (Yes/No)"
delay_chg_readin="$c10 $yes_no"
read_in delay_changed "$delay_chg_readin"

  case "$delay_changed" in
   [Yy]* ) delay_changed="yes"
           error_delay_min=yes
           while ( true )
           do
#cat  << EOF_EOF
#
#Enter the delay minutes allowed for printer faults.
#(NOTE 0: no printer delay allowed. -1: infinite printer delay allowed.)
#EOF_EOF
echo " "
echo "$c11"
echo "$c12"
echo $n "=> $c"
         read_in delay_min "$c11"
           check_delay_min
            if [ "$error_delay_min" = no ]
            then
              break
            else
              echo " "
              #echo "$err_mark delay_minutes must be an integer."
              echo "$err_mark $d90"
              echo " "
            fi

          done
           ;;

    * ) delay_changed="no"
       ;;
  esac


###########################
# check if convert LF->CR|LF
###########################
clear
#cat << EOF_EOF
#Is Line Feed to be converted to Carriage Return and Line Feed in a text file?
#EOF_EOF
echo "$c20"
echo $n " (Yes/No) =>$c"
#read_in text_mode  "Is Line Feed to be converted to Carriage Return and Line Feed in a text file? (Yes/No)"
text_mode_readin="$c20 $yes_no"
read_in text_mode "$text_mode_readin"

case $text_mode in
 [Yy]* ) text_mode=yes
         ;;
    * ) text_mode=no
        ;;
esac





####################################################
#Use Interface
#
####################################################
if [ "$use_interface" = "yes" ]
then

#############
# read  and check interface program
#############
if [ "$unix_type" != "Sun5" ]
then
# clear the screen
clear
#cat  << EOF_EOF
#Is the interface program that $OEM_mark provides to be used? 
#EOF_EOF
echo "$c21"
echo $n "$yes_no $c"
read_in stdintf "$c21"


    case "$stdintf" in
      [Yy]* ) stdintf=yes
              ;;
       * ) stdintf=no
              ;;
    esac
else
  stdintf=yes
fi


  # the dumb_int.sh is used
  if [ "$stdintf" = "yes" ]
  then
    INTERFACE="${curr_dir}/dumb_int.sh"
    if [ ! -x "$INTERFACE" ]
    then

    # clear the screen
    clear

    while true
    do
#cat  << EOF_EOF
#
#Enter the full path of the directory containing the dumb_int.sh program.
#EOF_EOF
echo " "
echo "$c30"
echo $n " =>$c"
read_in work_dir "$c30"

      if [ -d "$work_dir" ]
      then
         if [ -f "${work_dir}/dumb_int.sh" ]
         then
           if [ -x "${work_dir}/dumb_int.sh" ]
           then
             INTERFACE="${work_dir}/dumb_int.sh"
             break
           else
             echo " "
             #echo "$err_mark the dumb_int.sh program isn't executable."
             echo "$err_mark $e10"
             echo " "
           fi
         else
           echo " "
           #echo "$err_mark the dumb_int.sh program is not in $work_dir ."
           echo "$err_mark $e20 $work_dir ."
           echo " "
         fi
     else
        echo " "
        #echo "$err_mark Software Directory $work_dir doesn't exist."
        echo "$err_mark $sw_dir $work_dir $dont_exist"
        echo " "
     fi
   done
   fi

 else
 # use model interface program
      while true
      do
        clear
        #echo "Choose an interface model:"
        echo "$e30"
        echo "$press_to_cont"
        read dumb
        ls $model_dir | more 
        echo " "
        #echo $n  "Enter the model of the interface program =>$c" 
        echo $n  "$e40 =>$c" 
        read_in model "$e40" 
        INTERFACE="${model_dir}/$model" 
        if [ ! -f "$INTERFACE" ] 
        then
          echo " "  
          #echo "$err_mark $model doesn't exist."
          echo "$err_mark $model $dont_exist"
          echo "$press_to_cont"
          read dumb
        else
          break
        fi
     done
   # end use model interface
   fi


# use_interface=no
else 
  if [ "$unix_type" = DEC_OSF1 ]
  then
  clear
  #echo "Is a specific print filter to be used for the printer?"
  #read_in use_filter "Is a specific print filter to be used for the printer? (Yes/No)"
  echo "$e50"
  use_filter_readin="$e50 $yes_no"
  read_in use_filter "$use_filter_readin"
  case "$use_filter" in 
   [Yy]* ) use_filter=yes
           ;;
    * )  use_filter=no
           ;;
  esac

  if [ "$use_filter" = "yes" ]
  then  
      curr_dir=`pwd`
      cd /usr/lbin
      while true
      do
        clear
        #echo "Choose a print filter:"
        echo "$e60"
        echo "$press_to_cont"
        read dumb
        ls *of* |grep -v ansi | more 
        echo " "
        #echo $n "Enter the FULL name of the print filter =>$c" 
        echo $n "$e70 =>$c" 
      read_in PRINT_FILTER "$e70" 

        PRINT_FILTER="/usr/lbin/$PRINT_FILTER" 
        if [ ! -f "$PRINT_FILTER" ] 
        then
          echo " "  
          echo "$err_mark $PRINT_FILTER $dont_exist"
          echo "$press_to_cont"
          read dumb
        else
          break
        fi
     done
     cd "$curr_dir"
  # end if use_filter=yes
  fi
 

  # end of unix_type = DEC_OSF1
  fi 
# end if use_interface=yes
fi


# clear the screen
clear

#############
# print all information 
#############
  echo " "
  echo " "
  #echo "Printer Name: $printer_name"
  #echo "Host Name: $host_name"
  #echo "${program_mark} program: $filter_cmd"
  echo "$e80 $printer_name"
  echo "$e81 $host_name"
  echo "${program_mark} $e82 $filter_cmd"
  if [ "$use_interface" = "yes" ]
  then
    #echo "Interface program: $INTERFACE"
    echo "$e83 $INTERFACE"
  fi

  case "$port" in
    1 ) 
        if [ "$device_type" = dev3 -o "$device_type" = dev4 -o "$device_type" = dev5 ]
        then
           #echo "The printer is connected to parallel port 1."
           echo "$e84"
        fi
        if [ "$device_type" = dev2 ]
        then
           #echo "The printer is connected to MIO port."
           echo "$e85"
        fi
         ;;
    3 ) 
        if [ "$support_3P1S" = "no" ]
        then  
           if [ "$device_type" = dev5 ] 
           then
              #echo "The printer is connected to parallel port 3."
              echo "$e79"
           else
              #echo "The printer is connected to serial port."
              echo "$e86"
           fi
        else
           #echo "The printer is connected to parallel port 3."
           echo "$e79"
        fi 
         ;;
    2 ) #echo "The printer is connected to parallel port 2."
        echo "$e87"
         ;;
    s | S ) 
          #echo "The printer is connected to serial port."
          echo "$e86"
         ;;
  esac

  if [ "$auto_send" = "yes" ] 
  then
    case "$another_port" in  
      serial ) temp_port="serial port"
               ;;
      para2 ) temp_port="standard centronic parallel port 2"
               ;;
      para1 ) 
              if [ "$device_type" != dev2 ]
              then
                temp_port="high speed parallel port 1"
              else
                temp_port="MIO port"
              fi
              ;;
      all ) temp_port="the other two ports" 
               ;;
      * ) temp_port="$another_port" 
               ;;
    esac
    #echo "The port for auto sending: $temp_port ." 
    echo "$e88 $temp_port"
  fi
 
  if [ "$send_str" = "yes" ]
  then 
    if [ "$prestr" != "" ]
    then
      #echo "Prefix string to be sent before print job is \"${prestr}\"."
      echo "$e89 \"${prestr}\"."
    fi
  
    if [ "$sufstr" != "" ]
    then
       #echo "Suffix string to be sent after print job is \"${sufstr}\"."
       echo "$e90 \"${sufstr}\"."
    fi
  fi

 
  if [ "$send_file" = "yes" ]
  then 
    if [ "$headfile" != "" ]
    then
      #echo "Head file to be sent before print job is \"${headfile}\"."
      echo "$e91 \"${headfile}\"."
    fi
  
    if [ "$tailfile" != "" ]
    then
       #echo "Tail file to be sent after print job is \"${tailfile}\"."
       echo "$e92 \"${tailfile}\"."
    fi
  fi

  if [ "$delay_changed" = "yes" ]
  then
    #echo "Delay minutes allowed for printer faults is $delay_min ."
    echo "$e93 $delay_min ."

  fi
  
  if [ "$text_mode" = yes ]
  then
    #echo "Line Feed will be converted to Carriage Return and Line Feed."
    echo "$e94"
  fi


  if [ "$use_filter" = yes ]
  then
    #echo "The print filter: $PRINT_FILTER "
    echo "$e95 $PRINT_FILTER "
  fi



  echo " "
  #echo $n "Double Check: Is the information above correct? (Yes/No) =>$c"
  echo $n "$e96 $yes_no $c"
  dchk=Q
  read dchk
  case "$dchk" in
     [Qq][Uu][Ii][Tt] )
                      #echo "quit install.sh"
                      echo "$quit_inst"
                      rm -rf $temp_dir
                      exit 0
                         ;;
    [Yy]* ) break
           ;;
    * ) 
           ;;
  esac

done
#end of while double check

fi
#end of quick_set=no

#####################################################
#####################################################
###
# process filter command 
###
#####################################################
#####################################################

################################
################################
###
###  Use Interface Program
###
################################
################################


if [ "$use_interface" = "yes" ]
then

  process_filter_cmd_options


#############
# modify the interface program 
#############

# if $is_error is "yes", the interface script can't be modified.
is_error=no 



#else

  TEMPF="$temp_dir/PMinstall_$$"

 #copy  the interface program to temp_dir so that it can be modified.
  cp $INTERFACE $TEMPF

  # add read and write permissions to user
  chmod u+w $TEMPF
  chmod a+xr $TEMPF

  #echo "Modifying the interface program."
  echo "$f11"

#######################
#modify the interface script so that it can redirect its standard output
#to the ${program_mark} program
#######################
  # dumb_int.sh is used
  if [ "$stdintf" = "yes" ]
  then 

    # find the line number of PMFILTER_CMD in the interface program.
    delimter=`cat $TEMPF | grep -n "PMFILTER_CMD=" |cut -d: -f1`

    # if PMFILTER_CMD not found in the interface program
    if [ X"$delimter" = X ]
    then
      is_error=yes
      echo " "
      #echo "$err_mark can't find 'PMFILTER_CMD=' in $INTERFACE"
      #echo "                Please check the interface program."
      echo "$err_mark $f20 $INTERFACE"
      echo "$f21"
      rm -rf $temp_dir
      exit 1
    else  
      ED_FILE="${temp_dir}/edfile"

      #write the edition commands to a temp file
      #It will change the first line which contains "PMFILTER_CMD" to 
      # the new options specified by user.
      cat > $ED_FILE  << EOF_CAT
${delimter}c
PMFILTER_CMD="$filter_cmd"
.
w
q
EOF_CAT

      # ed will read input from ED_FILE and perform the edition
      # don't let any ed output go to screen
      cat $ED_FILE | ed $TEMPF > /dev/null 


      # if unix_type is HP_UX, we change "#!/bin/sh" to "#!/bin/ksh" 
      if [ "$unix_type" = HP_UX ]
      then
        cat > $ED_FILE  << EOF_CAT
1c
#!/bin/ksh
.
w
q
EOF_CAT

        # ed will read input from ED_FILE and perform the edition
        # don't let any ed output go to screen
        cat $ED_FILE | ed $TEMPF > /dev/null 

      fi

    fi

  # model interface script is used instead of dumb_int.sh
  else

    # The first line in the interface script may contain the type of
    # Shell used.  Therefore, we won't put it under the parenthsises
    # that pipe the output to ${program_mark}
    head -1  $TEMPF | grep "#!"  > /dev/null 2>&1

    # found
    if [ $? = 0 ]
    then

# inster the parenthsis to the 2nd line
ed $TEMPF > /dev/null << EOF_ED 
2i
(
.
w
q
EOF_ED

    # not found
    else

# inster the parenthsis to the 1st line
ed $TEMPF  > /dev/null << EOF_ED 
1i
(
.
w
q
EOF_ED
    fi

      # append the filter_cmd  
      echo ") | $filter_cmd " >> $TEMPF
      echo 'exit $? ' >> $TEMPF
  fi  
#fi


# shut down the print service
if [ "$unix_type" = "HP_UX" ]
then
  echo " "
  #echo "Shutting down the print services."
  echo "$f30"
  echo "/usr/lib/lpshut"
  command="/usr/lib/lpshut"
  exec_cmd
fi


chmod a+r /tmp
# add the printer to the system by using our own interface program
echo " " 
#echo "Adding printer $printer_name to the system."
echo "$f40 $printer_name $f41"
echo "/usr/lib/lpadmin -p$printer_name -v/dev/null -i$TEMPF"
command="/usr/lib/lpadmin -p$printer_name -v/dev/null -i$TEMPF"
  exec_cmd


# restart the print service
if [ "$unix_type" = "HP_UX" ]
then
  echo " " 
  #echo "Restarting the print services."
  echo "$f50"
  echo "/usr/lib/lpsched"
  command="/usr/lib/lpsched"
  exec_cmd
fi

# Let the printer accept print jobs
echo " " 
echo "/usr/lib/accept $printer_name"
command="/usr/lib/accept $printer_name"
  exec_cmd

# Enable the printer 
echo " " 
echo "enable $printer_name"
command="enable $printer_name"
  exec_cmd


# save information of installation to /tmp/LPInstall.log
echo " "
#echo "Saving information of installation to /tmp/LPInstall.log."
echo "$f60"
LOGF="/tmp/LPInstall.log"
if [ ! -f "$LOGF" ] 
then
  touch $LOGF
fi
  chmod u+w $LOGF
  echo "Printer Name: $printer_name" >> $LOGF
  echo "${program_mark} program: $filter_cmd" >> $LOGF
  echo "Interface program: $INTERFACE" >> $LOGF
  if [ "is_error" = "yes" ]
  then
    echo "Interface script modification failed!" >> $LOGF
  else
    echo "Interface script modification succeed!" >> $LOGF
  fi
  echo "UNIX system: $unix_type" >> $LOGF
  echo "Date: `date`" >> $LOGF
  echo "  " >> $LOGF 
  echo "  " >> $LOGF 
  chmod 400 $LOGF


# print message to the screen
if [ "$is_error" = "yes" ]
then
  
  echo " "
  #echo "WARNING: The interface program can't be modified!"
  #echo "Please modify $interface_arg"
  #echo "according to the suggestions in User's Guide."
  echo "$f70"
  echo "$f71 $interface_arg"
  echo "$f72"
  echo " "
  #echo "     [ End of Installation. ]"
  echo "$end_inst"
else
  echo " "
  #echo "The printer $printer_name can be used immediately"
  echo "$f80 $printer_name $f81"
  echo " "
  #echo "     [ End of Installation. ]"
  echo "$end_inst"
fi

################################
################################
###
###  Don't Use Interface Program
###
################################
################################
else 


SPOOL_DIR="/usr/spool/$printer_name"


clear

if [ -d "$SPOOL_DIR" ]
then
  #echo "Spool directory $SPOOL_DIR exists already."
  echo "$spool_dir $SPOOL_DIR $exist_already"
  echo " "
else
  #create spool directory
  if mkdir $SPOOL_DIR 2> /dev/null
  then
    #echo "Spool directory $SPOOL_DIR has been created!"
    echo "$spool_dir $SPOOL_DIR $created"
    echo " "
  else
    echo " "
    echo " "
    #echo "$err_mark Can't create spool directory $SPOOL_DIR ."
    #echo "                   Please check it and rerun install.sh."
    echo "$err_mark $f90 $SPOOL_DIR ."
    echo "$f91"
    rm -rf $temp_dir
    exit 1
  fi
fi

chmod 775 $SPOOL_DIR
chown daemon $SPOOL_DIR
chgrp daemon $SPOOL_DIR

# create the option file
if [ "$use_filter" = no ]
then
  PMOPTS="${SPOOL_DIR}/${OPT_file}"
  if [ ! -f "$PMOPTS" ]
  then
    touch $PMOPTS
  fi

  chmod 644 $PMOPTS
  
  #-D <destination> option
  echo "D $host_name" > $PMOPTS
  
  if [ "$support_3P1S" = "no" ]
  then
    if [ "$device_type" = "dev5" ]
    then
      case "$port" in
      1 | 2 | 3 | s | S ) 
          echo "o $port" >> $PMOPTS 
          ;;
      *)
          ;;
      esac
    else
      #-S, -H options 
      case "$port" in
        2 ) 
          echo "P" >> $PMOPTS 
          ;;
        3 )
          echo "S" >> $PMOPTS 
          ;;
        * ) ;;
      esac
    fi
  else
    case "$port" in
      1 | 2 | 3 | s | S ) 
          echo "o $port" >> $PMOPTS 
          ;;
      *)
          ;;
     esac
  fi
  
  #-p <prestring>, -s <sufstring> options
  if [ "$send_str" = "yes" ]
  then
    if [ "$prestr" != "" ]
    then
       echo "p '${prestr}'" >> $PMOPTS
    fi
  
    if [ "$sufstr" != "" ]
    then
       echo "s '${sufstr}'" >> $PMOPTS
    fi
  fi
  
  # -h <headfile>, -t <tailfile> options
  if [ "$send_file" = "yes" ]
  then
    if [ "$headfile" != "" ]
    then
      echo "h $headfile" >> $PMOPTS
    fi
  
    if [ "$tailfile" != "" ]
    then
       echo "t $tailfile" >> $PMOPTS
    fi
  fi
  
  # -a <other_ports> options
  if [ "$auto_send" = "yes" ]
  then
    if [ "$support_3P1S" = "no" ]
    then
       echo "a $another_port" >> $PMOPTS
    else
       echo "r $another_port" >> $PMOPTS
    fi
  fi
  
  # -d <delay_min> option
  if [ "$delay_changed" = "yes" ]
  then
     echo "d $delay_min" >> $PMOPTS
  fi

  # -T <Text_Mode> option
  if [ "$text_mode" = "yes" ]
  then
     echo "T" >> $PMOPTS
  fi

  # print the  whole command line to the screen
  echo " "
  #echo "The ${program_mark} options used in $PMOPTS is "
  echo "$Sthe ${program_mark} $g10 $PMOPTS $Sis "
  echo " "
  cat $PMOPTS 
  echo " "
  echo "$press_to_cont"
  read dumb

# use_filter=yes DEC_OSF1 only
else
  process_filter_cmd_options



# end  use_interface=no
fi 
  if test -r /dev/$printer_name 
  then 
    echo "/dev/$printer_name exist!!!"
    exit 1
  else
    if cp /dev/null /dev/$printer_name 2> /dev/null
    then
      LP_DEV="/dev/$printer_name"
      chmod 666 $LP_DEV
    else
      LP_DEV="/dev/null"
    fi
  fi

  of_name="$filter_cmd"
  # process print_filter used in DEC_OSF1
  if [ "$use_filter" = yes ]
  then
    of_name="${SPOOL_DIR}/.psof"
    #echo "Create $of_name "
    echo "$Screate $of_name "
    > "$of_name"
    chmod 555 $of_name  
    echo "#!/bin/sh" >> $of_name
    echo "$PRINT_FILTER \$* | $filter_cmd" >> "$of_name"
    echo "exit \$? " >> $of_name
  fi



  
  PRINTCAP="$temp_dir/temp_printcap"
  #create printcap entry
  touch $PRINTCAP

  chmod a+r $PRINTCAP
  chmod u+w $PRINTCAP

  echo "${printer_name}| $OEM_mark printer on port $port :\\" >> $PRINTCAP
  echo "	:lp=${LP_DEV}:\\" >> $PRINTCAP
  echo "	:sd=${SPOOL_DIR}:\\" >> $PRINTCAP
  echo "	:of=${of_name}:\\" >> $PRINTCAP
  echo "	:mx#0:" >> $PRINTCAP

  clear
  #echo "$printer_name entry in /etc/printcap is:"
  echo "$printer_name $g20"
  echo " "
  cat $PRINTCAP
  echo " "

  if [ "$use_filter" = yes ]
  then
    echo " "
    #echo "Contents of ${of_name}:"
    echo "$g30 ${of_name}:"
    echo " "
    cat $of_name
  fi


  echo " "
  echo "$press_to_cont"
  read dumb


  cp /etc/printcap /etc/printcap.old.$$ 2> /dev/null

  echo " "
  echo " "
  #echo "Appending printer entry to /etc/printcap."
  echo "$g40"

  if [ ! -f /etc/printcap ]
  then 
    touch /etc/printcap
    chmod 644 /etc/printcap
  fi

  cat $PRINTCAP >> /etc/printcap
  
  #echo "Starting the printer $printer_name ."
  echo "$g41 $printer_name ."
  echo "lpc start $printer_name"
  echo " "
  command="${LPC} start $printer_name"
  exec_cmd

  # save information of installation to /tmp/PMInstall.log
  echo " "
  #echo "Saving information of installation to /tmp/LPInstall.log."
  echo "$g50"
  echo " "
  LOGF="/tmp/LPInstall.log"
  if [ ! -f "$LOGF" ] 
  then
    touch $LOGF
  fi
  chmod u+w $LOGF
  echo "Printer Name: $printer_name" >> $LOGF
  echo "${program_mark} program: $filter_cmd" >> $LOGF
  echo "UNIX system: $unix_type" >> $LOGF
  echo "Date: `date`" >> $LOGF
  echo "  " >> $LOGF 
  echo "  " >> $LOGF 
  chmod 400 $LOGF


  echo " "
  #echo "The old printcap file has been moved to printcap.old.$$ ."
  #echo "The printer $printer_name can be used immediately"
  echo "$g60 printcap.old.$$ ."
  echo "$g61 $printer_name $g62"
  echo " "
  #echo "   [ End of Installation. ]"
  echo "$end_inst"
fi

# clear the temp directory we made
rm -rf $temp_dir
exit 0
