#include "sys/types.h"
#include "sys/stream.h"
#include "/etc/conf/cf.d/config.h"

/*
** for deciding burst length in C00 register.
*/
#define W840_BL0        0x0
#define W840_BL1        0x00000100
#define W840_BL2        0x00000200
#define W840_BL4        0x00000400
#define W840_BL8        0x00000800
#define W840_BL16       0x00001000
#define W840_BL32       0x00002000

/*
** for deciding cache alignment in C00 register.
*/
#define W840_CA0        0x0
#define W840_CA1        0x00004000
#define W840_CA2        0x00008000
#define W840_CA3        0x0000c000

/* 87-5-18 add, (begin) */
/*
** for deciding Nway function.
*/
#define NWAYDEFAULT     -1
#define NWAYOFF         0
#define NWAYON          1
/* 87-5-18 add, (end)

/*
** for deciding line speed value.
*/
#define AUTODETECTLINESPEED     0
#define LINESPEED10M            1
#define LINESPEED100M           2

/*
** for deciding full duplex function.
*/
#define AUTODETECTFULLDUPLEX    0
#define DISABLEFULLDUPLEX       1
#define ENABLEFULLDUPLEX        2

/*
** define the default value of Burst Length.
*/
#define W840_BURSTLEN_0       W840_BL32
#define W840_BURSTLEN_1       W840_BL32
#define W840_BURSTLEN_2       W840_BL32
#define W840_BURSTLEN_3       W840_BL32

/*
** define the default value of Cache Alignment.
*/
#define W840_CACHEALIGN_0     W840_CA3
#define W840_CACHEALIGN_1     W840_CA3
#define W840_CACHEALIGN_2     W840_CA3
#define W840_CACHEALIGN_3     W840_CA3

/*
** define the default value of transmit threshold.
*/
#define W840_TXTHRESHOLD_0    6
#define W840_TXTHRESHOLD_1    6
#define W840_TXTHRESHOLD_2    6
#define W840_TXTHRESHOLD_3    6

/* 87-5-18 add, (begin) */
/*
** define the default value of line speed.
*/
#define W840_NWAY_0     NWAYDEFAULT
#define W840_NWAY_1     NWAYDEFAULT
#define W840_NWAY_2     NWAYDEFAULT
#define W840_NWAY_3     NWAYDEFAULT
/* 87-5-18 add, (end) */

/*
** define the default value of line speed.
*/
#define W840_LINESPEED_0      AUTODETECTLINESPEED
#define W840_LINESPEED_1      AUTODETECTLINESPEED
#define W840_LINESPEED_2      AUTODETECTLINESPEED
#define W840_LINESPEED_3      AUTODETECTLINESPEED

/*
** define the default value of full duplex function.
*/
#define W840_FULLDUPLEX_0     AUTODETECTFULLDUPLEX
#define W840_FULLDUPLEX_1     AUTODETECTFULLDUPLEX
#define W840_FULLDUPLEX_2     AUTODETECTFULLDUPLEX
#define W840_FULLDUPLEX_3     AUTODETECTFULLDUPLEX

#if defined(W8403_UNITS)
#define NW840UNIT 4
ushort w840irq[NW840UNIT]={W840_0_VECT, W8401_0_VECT, W8402_0_VECT,
                           W8403_0_VECT};
ulong w840burstlen[NW840UNIT]={W840_BURSTLEN_0, W840_BURSTLEN_1,
                               W840_BURSTLEN_2, W840_BURSTLEN_3};
ulong w840cachealign[NW840UNIT]={W840_CACHEALIGN_0, W840_CACHEALIGN_1,
                                 W840_CACHEALIGN_2, W840_CACHEALIGN_3};
ulong w840txthreshold[NW840UNIT]={W840_TXTHRESHOLD_0, W840_TXTHRESHOLD_1,
                                  W840_TXTHRESHOLD_2, W840_TXTHRESHOLD_3};
short w840nway[NW840UNIT]={W840_NWAY_0, W840_NWAY_1, W840_NWAY_2,
                            W840_NWAY_3};
ushort w840linespeed[NW840UNIT]={W840_LINESPEED_0, W840_LINESPEED_1,
                                 W840_LINESPEED_2, W840_LINESPEED_3};
ushort w840fullduplex[NW840UNIT]={W840_FULLDUPLEX_0, W840_FULLDUPLEX_1,
                                  W840_FULLDUPLEX_2, W840_FULLDUPLEX_3};
#elif defined(W8402_UNITS)
#define NW840UNIT 3
ushort w840irq[NW840UNIT]={W840_0_VECT, W8401_0_VECT, W8402_0_VECT};
ulong w840burstlen[NW840UNIT]={W840_BURSTLEN_0, W840_BURSTLEN_1,
                               W840_BURSTLEN_2};
ulong w840cachealign[NW840UNIT]={W840_CACHEALIGN_0, W840_CACHEALIGN_1,
                                 W840_CACHEALIGN_2};
ulong w840txthreshold[NW840UNIT]={W840_TXTHRESHOLD_0, W840_TXTHRESHOLD_1,
                                  W840_TXTHRESHOLD_2};
short w840nway[NW840UNIT]={W840_NWAY_0, W840_NWAY_1, W840_NWAY_2};
ushort w840linespeed[NW840UNIT]={W840_LINESPEED_0, W840_LINESPEED_1,
                                 W840_LINESPEED_2};
ushort w840fullduplex[NW840UNIT]={W840_FULLDUPLEX_0, W840_FULLDUPLEX_1,
                                  W840_FULLDUPLEX_2};
#elif defined(W8401_UNITS)
#define NW840UNIT 2
ushort w840irq[NW840UNIT]={W840_0_VECT, W8401_0_VECT};
ulong w840burstlen[NW840UNIT]={W840_BURSTLEN_0, W840_BURSTLEN_1};
ulong w840cachealign[NW840UNIT]={W840_CACHEALIGN_0, W840_CACHEALIGN_1};
ulong w840txthreshold[NW840UNIT]={W840_TXTHRESHOLD_0, W840_TXTHRESHOLD_1};
short w840nway[NW840UNIT]={W840_NWAY_0, W840_NWAY_1};
ushort w840linespeed[NW840UNIT]={W840_LINESPEED_0, W840_LINESPEED_1};
ushort w840fullduplex[NW840UNIT]={W840_FULLDUPLEX_0, W840_FULLDUPLEX_1};
#elif defined(W840_UNITS)
#define NW840UNIT 1
ushort w840irq[NW840UNIT]={W840_0_VECT};
ulong w840burstlen[NW840UNIT]={W840_BURSTLEN_0};
ulong w840cachealign[NW840UNIT]={W840_CACHEALIGN_0};
ulong w840txthreshold[NW840UNIT]={W840_TXTHRESHOLD_0};
short w840nway[NW840UNIT]={W840_NWAY_0};
ushort w840linespeed[NW840UNIT]={W840_LINESPEED_0};
ushort w840fullduplex[NW840UNIT]={W840_FULLDUPLEX_0};
#endif

ushort w840InstalledBoardNo = NW840UNIT;

